/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.FailedOperationException;
import net.fortuna.ical4j.connector.dav.enums.SupportedFeature;
import net.fortuna.ical4j.connector.dav.property.CSDavPropertyName;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.xml.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavClient {
    protected HttpClient httpClient;
    private String principalPath;
    private String userPath;
    protected HostConfiguration hostConfiguration;

    public DavClient(URL url, String principalPath, String userPath) {
        this.principalPath = principalPath;
        this.userPath = userPath;
        Protocol protocol = Protocol.getProtocol((String)url.getProtocol());
        this.hostConfiguration = new HostConfiguration();
        this.hostConfiguration.setHost(url.getHost(), url.getPort(), protocol);
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            String port = System.getProperty("http.proxyPort");
            try {
                Integer p = Integer.parseInt(port);
                this.hostConfiguration.setProxy(host, p.intValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void begin() {
        this.httpClient = new HttpClient();
        this.httpClient.getParams().setAuthenticationPreemptive(false);
    }

    ArrayList<SupportedFeature> begin(String username, char[] password) throws IOException, FailedOperationException {
        ArrayList<SupportedFeature> supportedFeatures = new ArrayList<SupportedFeature>();
        this.begin();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, new String(password));
        this.httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        ArrayList<String> authPrefs = new ArrayList<String>(2);
        authPrefs.add("Digest");
        authPrefs.add("Basic");
        this.httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(DavPropertyName.RESOURCETYPE);
        props.add(CSDavPropertyName.CTAG);
        DavPropertyName owner = DavPropertyName.create((String)"owner", (Namespace)DavConstants.NAMESPACE);
        props.add(owner);
        PropFindMethod aGet = new PropFindMethod(this.principalPath, 0, props, 0);
        aGet.setDoAuthentication(true);
        int status = this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)aGet);
        if (status >= 300) {
            throw new FailedOperationException(String.format("Principals not found at [%s]", this.userPath));
        }
        Header[] davHeaders = aGet.getResponseHeaders("DAV");
        int headerIndex = 0;
        while (headerIndex < davHeaders.length) {
            Header header = davHeaders[headerIndex];
            HeaderElement[] elements = header.getElements();
            int elementIndex = 0;
            while (elementIndex < elements.length) {
                SupportedFeature supportedFeature;
                String feature = elements[elementIndex].getName();
                if (feature != null && (supportedFeature = SupportedFeature.findByDescription(feature)) != null) {
                    supportedFeatures.add(supportedFeature);
                }
                ++elementIndex;
            }
            ++headerIndex;
        }
        return supportedFeatures;
    }

    public int execute(HttpMethodBase method) throws IOException {
        return this.httpClient.executeMethod(this.hostConfiguration, (HttpMethod)method);
    }

    public int execute(HostConfiguration _hostConfiguration, DavMethodBase method) throws IOException {
        return this.httpClient.executeMethod(_hostConfiguration, (HttpMethod)method);
    }

    protected String getUserName() {
        return ((UsernamePasswordCredentials)this.httpClient.getState().getCredentials(AuthScope.ANY)).getUserName();
    }
}

