/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav;

public abstract class PathResolver {
    public static final PathResolver CHANDLER = new ChandlerPathResolver();
    public static final PathResolver CGP = new CgpPathResolver();
    public static final PathResolver KMS = new KmsPathResolver();
    public static final PathResolver ZIMBRA = new ZimbraPathResolver();
    public static final PathResolver ICAL_SERVER = new ICalServerPathResolver();
    public static final PathResolver CALENDAR_SERVER = new CalendarServerPathResolver();
    public static final PathResolver GCAL = new GCalPathResolver();
    public static final PathResolver SOGO = new SOGoPathResolver();
    public static final PathResolver DAVICAL = new DAViCalPathResolver();
    public static final PathResolver BEDEWORK = new BedeworkPathResolver();
    public static final PathResolver ORACLE_CS = new OracleCalendarServerPathResolver();
    public static final PathResolver GENERIC = new GenericPathResolver();

    public abstract String getUserPath(String var1);

    public abstract String getPrincipalPath(String var1);

    private static class BedeworkPathResolver
    extends PathResolver {
        private BedeworkPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/ucaldav/principals/users/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/ucaldav/users/" + username + "/";
        }
    }

    private static class CalendarServerPathResolver
    extends PathResolver {
        private CalendarServerPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/dav/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/dav/" + username + "/";
        }
    }

    private static class CgpPathResolver
    extends PathResolver {
        private CgpPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/CalDAV/";
        }

        public String getUserPath(String arg0) {
            return "/CalDAV/";
        }
    }

    private static class ChandlerPathResolver
    extends PathResolver {
        private ChandlerPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/dav/users/" + username;
        }

        public String getUserPath(String username) {
            return "/dav/" + username + "/";
        }
    }

    private static class DAViCalPathResolver
    extends PathResolver {
        private DAViCalPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/caldav.php/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/caldav.php/" + username + "/";
        }
    }

    private static class GCalPathResolver
    extends PathResolver {
        private GCalPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/calendar/dav/" + username + "/user/";
        }

        public String getUserPath(String username) {
            return "/calendar/dav/" + username + "/events/";
        }
    }

    public static class GenericPathResolver
    extends PathResolver {
        private String principalPath;
        private String userPath;

        public String principalPath() {
            return this.principalPath;
        }

        public void setPrincipalPath(String principalPath) {
            this.principalPath = principalPath;
        }

        public String getPrincipalPath(String username) {
            return String.valueOf(this.principalPath) + "/" + username + "/";
        }

        public String userPath() {
            return this.userPath;
        }

        public void setUserPath(String userPath) {
            this.userPath = userPath;
        }

        public String getUserPath(String username) {
            return String.valueOf(this.userPath) + "/" + username;
        }
    }

    private static class ICalServerPathResolver
    extends PathResolver {
        private ICalServerPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/principals/users/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/dav/" + username + "/";
        }
    }

    private static class KmsPathResolver
    extends PathResolver {
        private KmsPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/caldav/";
        }

        public String getUserPath(String arg0) {
            return null;
        }
    }

    private static class OracleCalendarServerPathResolver
    extends PathResolver {
        private OracleCalendarServerPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/dav/principals/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/dav/home/" + username + "/";
        }
    }

    private static class SOGoPathResolver
    extends PathResolver {
        private SOGoPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/SOGo/dav/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/SOGo/dav/" + username + "/";
        }
    }

    private static class ZimbraPathResolver
    extends PathResolver {
        private ZimbraPathResolver() {
        }

        public String getPrincipalPath(String username) {
            return "/principals/users/" + username + "/";
        }

        public String getUserPath(String username) {
            return "/dav/" + username + "/";
        }
    }
}

