/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.enums;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceType {
    CALENDAR("calendar"),
    FREE_BUSY_URL("free-busy-url"),
    SCHEDULE_OUTBOX("schedule-outbox"),
    NOTIFICATION("notification"),
    DROPBOX_HOME("dropbox-home"),
    CALENDAR_PROXY_WRITE("calendar-proxy-write"),
    CALENDAR_PROXY_READ("calendar-proxy-read"),
    SHARE_OWNER("shared-owner"),
    ADRESSBOOK("addressbook"),
    SUBSCRIBED("subscribed"),
    COLLECTION("collection"),
    SCHEDULE_INBOX("schedule-inbox");

    private String description;
    private static Set<String> index;

    static {
        index = new HashSet<String>();
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType supportedFeature = resourceTypeArray[n2];
            index.add(supportedFeature.description());
            ++n2;
        }
    }

    private ResourceType(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public static ArrayList<String> descriptions() {
        return new ArrayList<String>(index);
    }

    public static ResourceType findByDescription(String value) {
        ResourceType[] resourceTypeArray = ResourceType.values();
        int n = resourceTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceType feature = resourceTypeArray[n2];
            if (feature.description().equals(value)) {
                return feature;
            }
            ++n2;
        }
        return null;
    }
}

