/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.dav.method;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import net.fortuna.ical4j.connector.dav.CalDavConstants;
import net.fortuna.ical4j.connector.dav.property.CalDavPropertyName;
import net.fortuna.ical4j.connector.dav.property.CardDavPropertyName;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.VCardBuilder;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.report.PrincipalMatchReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.DOMException;

public class ReportMethod
extends org.apache.jackrabbit.webdav.client.methods.ReportMethod {
    public static final ReportType CALENDAR_QUERY = ReportType.register((String)"calendar-query", (Namespace)CalDavConstants.CALDAV_NAMESPACE, PrincipalMatchReport.class);
    public static final ReportType FREEBUSY_QUERY = ReportType.register((String)"free-busy-query", (Namespace)CalDavConstants.CALDAV_NAMESPACE, PrincipalMatchReport.class);
    public static final ReportType ADDRESSBOOK_QUERY = ReportType.register((String)"addressbook-query", (Namespace)CalDavConstants.CARDDAV_NAMESPACE, PrincipalMatchReport.class);

    public ReportMethod(String uri, ReportInfo reportInfo) throws IOException {
        super(uri, reportInfo);
    }

    public Calendar[] getCalendars() throws IOException, DavException, DOMException, ParserException {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        MultiStatus multi = this.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] multiStatusResponseArray = multi.getResponses();
        int n = multiStatusResponseArray.length;
        int n2 = 0;
        while (n2 < n) {
            MultiStatusResponse response = multiStatusResponseArray[n2];
            DavPropertySet props = response.getProperties(200);
            if (props.get(CalDavPropertyName.CALENDAR_DATA) != null) {
                String value = (String)props.get(CalDavPropertyName.CALENDAR_DATA).getValue();
                CalendarBuilder builder = new CalendarBuilder();
                calendars.add(builder.build((Reader)new StringReader(value)));
            }
            ++n2;
        }
        return calendars.toArray(new Calendar[calendars.size()]);
    }

    public VCard[] getVCards() throws IOException, DavException, DOMException {
        ArrayList<VCard> cards = new ArrayList<VCard>();
        MultiStatus multi = this.getResponseBodyAsMultiStatus();
        MultiStatusResponse[] multiStatusResponseArray = multi.getResponses();
        int n = multiStatusResponseArray.length;
        int n2 = 0;
        while (n2 < n) {
            MultiStatusResponse response = multiStatusResponseArray[n2];
            DavPropertySet props = response.getProperties(200);
            if (props.get(CardDavPropertyName.ADDRESS_DATA) != null) {
                String value = (String)props.get(CardDavPropertyName.ADDRESS_DATA).getValue();
                VCardBuilder builder = new VCardBuilder((Reader)new StringReader(value));
                try {
                    cards.add(builder.build());
                }
                catch (ParserException e) {
                    System.out.println(e.getMessage());
                    System.out.println(value);
                }
            }
            ++n2;
        }
        return cards.toArray(new VCard[cards.size()]);
    }
}

