/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.connector.jcr;

import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import net.fortuna.ical4j.connector.ObjectCollection;
import net.fortuna.ical4j.connector.ObjectNotFoundException;
import net.fortuna.ical4j.connector.ObjectStore;
import net.fortuna.ical4j.connector.ObjectStoreException;
import net.fortuna.ical4j.connector.jcr.AbstractJcrObjectCollection;
import net.fortuna.ical4j.connector.jcr.AbstractJcrObjectCollectionDao;
import net.fortuna.ical4j.model.Calendar;
import org.jcrom.Jcrom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJcrObjectStore<C extends AbstractJcrObjectCollection<?>>
implements ObjectStore<C> {
    private final Repository repository;
    private final String path;
    private Session session;
    private final Jcrom jcrom;

    public AbstractJcrObjectStore(Repository repository, String path, Jcrom jcrom) {
        this.repository = repository;
        this.path = path;
        this.jcrom = jcrom;
    }

    @Override
    public final boolean connect() throws ObjectStoreException {
        if (this.repository == null) {
            throw new ObjectStoreException("Repository not configured");
        }
        try {
            this.session = this.repository.login();
        }
        catch (LoginException le) {
            throw new ObjectStoreException("Unable to login", le);
        }
        catch (RepositoryException re) {
            throw new ObjectStoreException("Error connecting", re);
        }
        return this.session != null;
    }

    @Override
    public final boolean connect(String username, char[] password) throws ObjectStoreException {
        if (this.repository == null) {
            throw new ObjectStoreException("Repository not configured");
        }
        try {
            this.session = this.repository.login((Credentials)new SimpleCredentials(username, password));
        }
        catch (LoginException le) {
            throw new ObjectStoreException("Unable to login", le);
        }
        catch (RepositoryException re) {
            throw new ObjectStoreException("Error connecting", re);
        }
        return this.session != null;
    }

    @Override
    public final void disconnect() throws ObjectStoreException {
        this.assertConnected();
        this.session.logout();
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isLive();
    }

    @Override
    public final C addCollection(String name) throws ObjectStoreException {
        this.assertConnected();
        try {
            Node pathNode = !this.session.nodeExists(this.path) ? this.session.getRootNode().addNode(this.path.substring(1)) : this.session.getNode(this.path);
            if (!pathNode.hasNode("collections")) {
                pathNode.addNode("collections");
            }
        }
        catch (RepositoryException e) {
            throw new ObjectStoreException("Unexpected error", e);
        }
        AbstractJcrObjectCollection collection = null;
        boolean update = false;
        List<C> collections = this.getCollectionDao().findByCollectionName(String.valueOf(this.path) + "/collections", name);
        if (!collections.isEmpty()) {
            collection = (AbstractJcrObjectCollection)collections.get(0);
            update = true;
            throw new ObjectStoreException("Collection already exists: " + name);
        }
        collection = (AbstractJcrObjectCollection)this.newCollection();
        collection.setStore(this);
        collection.setName(name);
        collection.setCollectionName(name);
        if (update) {
            this.getCollectionDao().update(collection);
        } else {
            this.getCollectionDao().create(String.valueOf(this.path) + "/collections", collection);
        }
        return (C)collection;
    }

    @Override
    public final C addCollection(String name, String displayName, String description, String[] supportedComponents, Calendar timezone) throws ObjectStoreException {
        ObjectCollection collection = this.addCollection(name);
        ((AbstractJcrObjectCollection)collection).setDisplayName(displayName);
        ((AbstractJcrObjectCollection)collection).setDescription(description);
        this.getCollectionDao().update(collection);
        return (C)collection;
    }

    @Override
    public final C getCollection(String name) throws ObjectStoreException, ObjectNotFoundException {
        List<C> collections = this.getCollectionDao().findByCollectionName(String.valueOf(this.path) + "/collections", name);
        if (!collections.isEmpty()) {
            AbstractJcrObjectCollection collection = (AbstractJcrObjectCollection)collections.get(0);
            collection.setStore(this);
            return (C)collection;
        }
        throw new ObjectNotFoundException("Collection doesn't exist: " + name);
    }

    @Override
    public List<C> getCollections() throws ObjectStoreException, ObjectNotFoundException {
        return this.getCollectionDao().findAll(this.path);
    }

    @Override
    public final C removeCollection(String name) throws ObjectStoreException, ObjectNotFoundException {
        ObjectCollection collection = this.getCollection(name);
        this.getCollectionDao().remove(this.getJcrom().getPath((Object)collection));
        return (C)collection;
    }

    final Session getSession() {
        return this.session;
    }

    final Jcrom getJcrom() {
        return this.jcrom;
    }

    protected final void assertConnected() throws ObjectStoreException {
        if (this.session == null) {
            throw new ObjectStoreException("Not connected");
        }
    }

    protected abstract C newCollection();

    protected abstract AbstractJcrObjectCollectionDao<C> getCollectionDao();
}

