/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.control;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.SocketClient;
import net.sf.borg.common.SocketHandler;
import net.sf.borg.common.SocketServer;
import net.sf.borg.model.EmailReminder;
import net.sf.borg.model.Model;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.db.jdbc.JdbcDBHelper;
import net.sf.borg.model.tool.ConversionTool;
import net.sf.borg.ui.UIControl;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.ModalMessage;
import net.sf.borg.ui.util.ScrolledDialog;

public class Borg
implements SocketHandler,
Observer {
    private static Borg singleton = null;
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private Timer mailTimer_ = null;
    private ModalMessage modalMessage = null;
    private SocketServer socketServer_ = null;
    private Timer syncTimer_ = null;

    public static Borg getReference() {
        if (singleton == null) {
            singleton = new Borg();
        }
        return singleton;
    }

    private static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Borg b = Borg.getReference();
        b.init(args);
    }

    public static void shutdown() {
        if (Borg.getReference().syncTimer_ != null) {
            Borg.getReference().syncTimer_.cancel();
        }
        if (Borg.getReference().mailTimer_ != null) {
            Borg.getReference().mailTimer_.cancel();
        }
        try {
            DBHelper.getController().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Timer shutdownTimer = new Timer("ShutdownTimer");
        shutdownTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.exit(0);
            }
        }, 3000L, 1680000L);
    }

    private Borg() {
    }

    @Override
    public synchronized String processMessage(String msg) {
        log.fine("Got msg: " + msg);
        if (msg.equals("sync")) {
            try {
                Model.syncModels();
                return "sync success";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "sync error: " + e.toString();
            }
        }
        if (msg.equals("shutdown")) {
            System.exit(0);
        } else {
            if (msg.equals("open")) {
                UIControl.toFront();
                return "ok";
            }
            if (msg.startsWith("lock:")) {
                final String lockmsg = msg.substring(5);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Borg.this.modalMessage == null || !Borg.this.modalMessage.isShowing()) {
                            Borg.this.modalMessage = new ModalMessage(lockmsg, false);
                            Borg.this.modalMessage.setVisible(true);
                        } else {
                            Borg.this.modalMessage.appendText(lockmsg);
                        }
                        Borg.this.modalMessage.setEnabled(false);
                        Borg.this.modalMessage.toFront();
                    }
                });
                return "ok";
            }
            if (msg.startsWith("log:")) {
                final String lockmsg = msg.substring(4);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Borg.this.modalMessage != null && Borg.this.modalMessage.isShowing()) {
                            Borg.this.modalMessage.appendText(lockmsg);
                            Borg.this.modalMessage.setEnabled(false);
                            Borg.this.modalMessage.toFront();
                        }
                    }
                });
                return "ok";
            }
            if (msg.equals("unlock")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Borg.this.modalMessage.isShowing()) {
                            Borg.this.modalMessage.setEnabled(true);
                        }
                    }
                });
                return "ok";
            }
        }
        return "Unknown msg: " + msg;
    }

    private void init(String[] args) {
        String testdb = null;
        String trayname = "BORG";
        boolean testing = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-trayname")) {
                if (++i >= args.length) {
                    System.out.println("Error: missing trayname argument");
                    System.exit(1);
                }
                trayname = args[i];
                continue;
            }
            if (args[i].equals("-db")) {
                if (++i >= args.length) {
                    System.out.println(Resource.getResourceString("-db_argument_is_missing"));
                    System.exit(1);
                }
                testdb = args[i];
                continue;
            }
            if (args[i].equals("-test")) {
                testing = true;
                continue;
            }
            if (!args[i].equals("-runtool")) continue;
            if (++i >= args.length) {
                System.out.println("tool name is missing");
                System.exit(1);
            }
            String toolName = args[i];
            try {
                Class<?> toolClass = Class.forName("net.sf.borg.model.tool." + toolName);
                Object tool = toolClass.newInstance();
                if (tool instanceof ConversionTool) {
                    ((ConversionTool)tool).convert();
                }
                System.exit(0);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (testing) {
            Prefs.setPrefRootNode("net/sf/borg/test");
        }
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(Level.ALL);
        log.addHandler(ch);
        log.setUseParentHandlers(false);
        boolean debug = Prefs.getBoolPref(PrefName.DEBUG);
        if (debug) {
            log.setLevel(Level.ALL);
        } else {
            log.setLevel(Level.INFO);
        }
        log.fine("Debug logging turned on");
        int port = Prefs.getIntPref(PrefName.SOCKETPORT);
        if (port != -1 && !testing) {
            try {
                String resp = SocketClient.sendMsg("localhost", port, "open");
                if (resp != null && resp.equals("ok")) {
                    System.exit(0);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            if (!testing) {
                String home = System.getProperty("user.home", "");
                FileOutputStream errStr = new FileOutputStream(home + "/.borg.out", false);
                PrintStream printStream = new PrintStream(errStr);
                System.setErr(printStream);
                System.setOut(printStream);
                FileHandler fh = new FileHandler("%h/.borg.log");
                fh.setFormatter(new SimpleFormatter());
                fh.setLevel(ch.getLevel());
                log.removeHandler(ch);
                log.addHandler(fh);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Prefs.getBoolPref(PrefName.DYNAMIC_LOADING)) {
            File parentDir = null;
            try {
                URL jarURL = this.getJarURL();
                String jarPath = jarURL.toURI().getPath();
                if (jarPath != null) {
                    parentDir = new File(jarPath).getParentFile();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            File ext = null;
            if (!(parentDir == null || (ext = new File(parentDir, "lib/ext")).exists() && ext.isDirectory())) {
                ext = null;
            }
            if (ext == null) {
                ext = new File("lib/ext");
            }
            log.info("using ext lib dir=" + ext);
            if (ext.exists() && ext.isDirectory()) {
                File[] files;
                for (File file : files = ext.listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    log.info("Loading JAR: " + file.getName());
                    try {
                        Borg.addURL(file.toURI().toURL());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        String country = Prefs.getPref(PrefName.COUNTRY);
        String language = Prefs.getPref(PrefName.LANGUAGE);
        if (!language.equals("")) {
            Locale.setDefault(new Locale(language, country));
        }
        DBHelper.setFactory((DBHelper.Factory)new JdbcDBHelper());
        DBHelper.setController((DBHelper.Controller)new JdbcDBHelper());
        String dbdir = null;
        try {
            dbdir = testdb != null ? testdb : DBHelper.getController().buildURL();
            if (dbdir.equals("not-set")) {
                String home = System.getProperty("user.home", "");
                File borgdir = null;
                String os = System.getProperty("os.name").toLowerCase();
                borgdir = os.indexOf("mac") != -1 ? new File(home, "Library/BorgCalendar") : new File(home + "/.borg_db");
                if (!borgdir.exists()) {
                    borgdir.mkdir();
                }
                if (borgdir.isDirectory() && borgdir.canWrite()) {
                    Prefs.putPref(PrefName.H2DIR, borgdir.getAbsolutePath());
                    Prefs.putPref(PrefName.DBTYPE, "h2");
                    dbdir = DBHelper.getController().buildURL();
                } else {
                    JOptionPane.showMessageDialog(null, Resource.getResourceString("selectdb"), Resource.getResourceString("Notice"), 1);
                    OptionsView.dbSelectOnly();
                    return;
                }
            }
            DBHelper.getController().connect(dbdir);
            UIControl.setShutdownListener(this);
            final String traynm = trayname;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UIControl.startUI(traynm);
                }
            });
            GregorianCalendar cal = new GregorianCalendar();
            int emailmins = Prefs.getIntPref(PrefName.EMAILTIME);
            int curmins = 60 * cal.get(11) + cal.get(12);
            int mailtime = emailmins - curmins;
            if (mailtime < 0) {
                try {
                    EmailReminder.sendDailyEmailReminder(null);
                }
                catch (Exception e) {
                    final Exception fe = e;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Errmsg.getErrorHandler().errmsg(fe);
                        }
                    });
                }
                mailtime += 1440;
            }
            this.mailTimer_ = new Timer("MailTimer");
            this.mailTimer_.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        EmailReminder.sendDailyEmailReminder(null);
                    }
                    catch (Exception e) {
                        final Exception fe = e;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Errmsg.getErrorHandler().errmsg(fe);
                            }
                        });
                    }
                }
            }, mailtime * 60 * 1000, 86400000L);
            int syncmins = Prefs.getIntPref(PrefName.SYNCMINS);
            String dbtype = Prefs.getPref(PrefName.DBTYPE);
            if ((dbtype.equals("mysql") || dbtype.equals("jdbc")) && syncmins != 0) {
                this.syncTimer_ = new Timer("SyncTimer");
                this.syncTimer_.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Model.syncModels();
                                }
                                catch (Exception e) {
                                    Errmsg.getErrorHandler().errmsg(e);
                                }
                            }
                        });
                    }
                }, syncmins * 60 * 1000, (long)(syncmins * 60 * 1000));
            }
            if (port != -1 && this.socketServer_ == null) {
                this.socketServer_ = new SocketServer(port, this);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            String es = e.toString();
            es = es + Resource.getResourceString("db_set_to") + dbdir;
            es = es + Resource.getResourceString("bad_db_2");
            int ret = ScrolledDialog.showOptionDialog(es);
            if (ret == 0) {
                OptionsView.dbSelectOnly();
                return;
            }
            System.exit(1);
        }
    }

    protected URL getJarURL() throws MalformedURLException {
        Class<?> cls = this.getClass();
        ProtectionDomain domain = cls.getProtectionDomain();
        CodeSource codeSource = domain.getCodeSource();
        URL sourceLocation = codeSource.getLocation();
        return new URL(sourceLocation.toString());
    }

    @Override
    public void update(Observable o, Object arg) {
        Borg.shutdown();
    }
}

