/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.View;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.InputDialog;

public class CategoryChooser
extends View {
    private static final long serialVersionUID = 1L;
    private static CategoryChooser singleton = null;
    private JButton applyButton;
    private JPanel buttonPanel;
    private ArrayList<JCheckBox> cbs = null;
    private JPanel checkBoxPanel;
    private JButton clearAllButton = null;
    private JMenuItem delcatMI;
    private JButton dismissButton;
    private JScrollPane jScrollPane = null;
    private JButton selectAllButton = null;
    private JPanel topPanel = null;

    public static CategoryChooser getReference() {
        if (singleton == null || !singleton.isShowing()) {
            singleton = new CategoryChooser();
        }
        return singleton;
    }

    private CategoryChooser() {
        this.initComponents();
        try {
            CategoryModel catmod = CategoryModel.getReference();
            Collection curcats = catmod.getShownCategories();
            TreeSet allcats = catmod.getCategories();
            if (allcats == null) {
                allcats = new TreeSet();
            }
            this.cbs = new ArrayList();
            for (String cat : allcats) {
                JCheckBox cb = new JCheckBox(cat);
                this.cbs.add(cb);
                if (curcats != null && curcats.contains(cat)) {
                    cb.setSelected(true);
                }
                this.checkBoxPanel.add(cb);
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.pack();
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        TreeSet<String> newcats = new TreeSet<String>();
        for (JCheckBox cb : this.cbs) {
            if (!cb.isSelected()) continue;
            newcats.add(cb.getText());
        }
        CategoryModel.getReference().setShownCategories(newcats);
    }

    @Override
    public void destroy() {
        this.dispose();
    }

    private void dismissButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }

    public JMenu getCategoryMenu() {
        JMenu catmenu = new JMenu();
        catmenu.setIcon(new ImageIcon(this.getClass().getResource("/resource/Preferences16.gif")));
        ResourceHelper.setText(catmenu, "Categories");
        JMenuItem chooseCategoriesMI = new JMenuItem();
        chooseCategoriesMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Preferences16.gif")));
        ResourceHelper.setText(chooseCategoriesMI, "choosecat");
        chooseCategoriesMI.setActionCommand("Choose Displayed Categories");
        chooseCategoriesMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryChooser.getReference().setVisible(true);
            }
        });
        catmenu.add(chooseCategoriesMI);
        JMenuItem addCategoryMI = new JMenuItem();
        addCategoryMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
        ResourceHelper.setText(addCategoryMI, "addcat");
        addCategoryMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String inputValue = null;
                while (true) {
                    if ((inputValue = InputDialog.show(Resource.getResourceString("AddCat"), 15)) == null) {
                        return;
                    }
                    if (!inputValue.trim().isEmpty()) break;
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("Category_Name_Required"));
                }
                try {
                    CategoryModel.getReference().addCategory(inputValue);
                    CategoryModel.getReference().showCategory(inputValue);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        catmenu.add(addCategoryMI);
        JMenuItem removeCategoryMI = new JMenuItem();
        removeCategoryMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        ResourceHelper.setText(removeCategoryMI, "remcat");
        removeCategoryMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    CategoryModel.getReference().sync();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        catmenu.add(removeCategoryMI);
        catmenu.add(this.getDelcatMI());
        return catmenu;
    }

    private JButton getClearButton() {
        if (this.clearAllButton == null) {
            this.clearAllButton = new JButton();
            ResourceHelper.setText(this.clearAllButton, "clear_all");
            this.clearAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (JCheckBox cb : CategoryChooser.this.cbs) {
                        cb.setSelected(false);
                    }
                }
            });
        }
        return this.clearAllButton;
    }

    private JMenuItem getDelcatMI() {
        if (this.delcatMI == null) {
            this.delcatMI = new JMenuItem();
            ResourceHelper.setText(this.delcatMI, "delete_cat");
            this.delcatMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
            this.delcatMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        CategoryModel catmod = CategoryModel.getReference();
                        Collection allcats = catmod.getCategories();
                        allcats.remove(CategoryModel.UNCATEGORIZED);
                        if (allcats.isEmpty()) {
                            Errmsg.getErrorHandler().notice(Resource.getResourceString("No_Categories"));
                            return;
                        }
                        Object[] cats = allcats.toArray();
                        Object o = JOptionPane.showInputDialog(null, Resource.getResourceString("delete_cat_choose"), "", 3, null, cats, cats[0]);
                        if (o == null) {
                            return;
                        }
                        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("delcat_warn") + " [" + (String)o + "]!", "", 2, 2);
                        if (ret == 0) {
                            String cat;
                            for (Appointment ap : AppointmentModel.getReference().getAllAppts()) {
                                cat = ap.getCategory();
                                if (cat == null || !cat.equals(o)) continue;
                                AppointmentModel.getReference().delAppt(ap);
                            }
                            for (Task t : TaskModel.getReference().getTasks()) {
                                cat = t.getCategory();
                                if (cat == null || !cat.equals(o)) continue;
                                TaskModel.getReference().delete(t.getKey());
                            }
                            for (Task t : TaskModel.getReference().getProjects()) {
                                cat = t.getCategory();
                                if (cat == null || !cat.equals(o)) continue;
                                TaskModel.getReference().deleteProject(t.getKey());
                            }
                            try {
                                CategoryModel.getReference().deleteCategory((String)o);
                            }
                            catch (Exception ex) {
                                Errmsg.getErrorHandler().errmsg(ex);
                            }
                        }
                    }
                    catch (Exception ex) {
                        Errmsg.getErrorHandler().errmsg(ex);
                    }
                }
            });
        }
        return this.delcatMI;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(40, 200));
            this.jScrollPane.setViewportView(this.checkBoxPanel);
        }
        return this.jScrollPane;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            this.topPanel.add((Component)this.buttonPanel, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 0.0));
            this.topPanel.add((Component)this.getJScrollPane(), GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        }
        return this.topPanel;
    }

    private void initComponents() {
        GridLayout gridLayout2 = new GridLayout();
        this.checkBoxPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.applyButton = new JButton();
        this.dismissButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setTitle(Resource.getResourceString("catchooser"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CategoryChooser.this.exitForm(evt);
            }
        });
        this.checkBoxPanel.setLayout(new GridLayout(0, 1));
        this.checkBoxPanel.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.buttonPanel.setLayout(gridLayout2);
        this.getContentPane().add((Component)this.checkBoxPanel, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        this.applyButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(this.applyButton, "apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryChooser.this.applyButtonActionPerformed(evt);
            }
        });
        this.dismissButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Stop16.gif")));
        ResourceHelper.setText(this.dismissButton, "Dismiss");
        this.dismissButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CategoryChooser.this.dismissButtonActionPerformed(evt);
            }
        });
        this.setDismissButton(this.dismissButton);
        this.setSize(250, 147);
        this.setContentPane(this.getTopPanel());
        gridLayout2.setRows(1);
        this.buttonPanel.add((Component)this.selectAllButton(), null);
        this.buttonPanel.add((Component)this.getClearButton(), null);
        this.buttonPanel.add((Component)this.applyButton, null);
        this.buttonPanel.add((Component)this.dismissButton, null);
        this.getContentPane().add((Component)this.buttonPanel, GridBagConstraintsFactory.create(0, 1, 2));
        this.pack();
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    private JButton selectAllButton() {
        if (this.selectAllButton == null) {
            this.selectAllButton = new JButton();
            ResourceHelper.setText(this.selectAllButton, "select_all");
            this.selectAllButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (JCheckBox cb : CategoryChooser.this.cbs) {
                        cb.setSelected(true);
                    }
                }
            });
        }
        return this.selectAllButton;
    }
}

