/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Model;
import net.sf.borg.ui.MainMenu;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.ViewSize;

public abstract class DockableView
extends JPanel
implements Model.Listener {
    static Image image = Toolkit.getDefaultToolkit().getImage(DockableView.class.getResource("/resource/borg32x32.jpg"));
    private static final long serialVersionUID = 1L;
    private MainMenu mainMenu = null;
    private JFrame frame = null;

    private static void recordSize(Component c, PrefName pn) {
        String s = Prefs.getPref(pn);
        ViewSize vs = ViewSize.fromString(s);
        vs.setX(c.getBounds().x);
        vs.setY(c.getBounds().y);
        vs.setWidth(c.getBounds().width);
        vs.setHeight(c.getBounds().height);
        JFrame v = (JFrame)c;
        vs.setMaximized(v.getExtendedState() == 6);
        Prefs.putPref(pn, vs.toString());
    }

    protected void addModel(Model m) {
        m.addListener((Model.Listener)this);
    }

    protected boolean canClose() {
        return true;
    }

    protected void cleanUp() {
    }

    public void close() {
        if (!this.canClose()) {
            return;
        }
        this.cleanUp();
        if (this.isDocked()) {
            this.getParent().remove(this);
        } else {
            this.frame.dispose();
            this.frame = null;
        }
    }

    private void dock() {
        MultiView.getMainView().addView(this.getFrameTitle(), this);
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
        String s = Prefs.getPref(this.getFrameSizePref());
        ViewSize vs = ViewSize.fromString(s);
        vs.setDock(ViewSize.DockType.DOCK);
        Prefs.putPref(this.getFrameSizePref(), vs.toString());
    }

    protected void updateTitle() {
        if (this.isDocked()) {
            MultiView.getMainView().setTabTitle(this.getFrameTitle(), this);
        } else if (this.frame != null) {
            this.frame.setTitle(this.getFrameTitle());
        }
    }

    protected PrefName getFrameSizePref() {
        return new PrefName(this.getFrameTitle() + "_framesize", "-1,-1,800,600,N");
    }

    public abstract String getFrameTitle();

    public boolean isDocked() {
        return this.frame == null;
    }

    private ViewSize manageMySize(PrefName pname) {
        String s = Prefs.getPref(pname);
        ViewSize vs = ViewSize.fromString(s);
        vs.setDock(ViewSize.DockType.UNDOCK);
        Prefs.putPref(pname, vs.toString());
        if (vs.isMaximized()) {
            this.frame.setExtendedState(6);
        } else if (vs.getX() != -1) {
            this.frame.setBounds(new Rectangle(vs.getX(), vs.getY(), vs.getWidth(), vs.getHeight()));
        } else if (vs.getWidth() != -1) {
            this.frame.setSize(new Dimension(vs.getWidth(), vs.getHeight()));
        }
        this.frame.validate();
        final PrefName pn = pname;
        this.frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                DockableView.recordSize(e.getComponent(), pn);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                DockableView.recordSize(e.getComponent(), pn);
            }
        });
        return vs;
    }

    public JFrame openInFrame() {
        this.frame = new JFrame();
        this.manageMySize(this.getFrameSizePref());
        this.frame.setContentPane(this);
        if (this.mainMenu == null) {
            this.mainMenu = new MainMenu();
            if (this instanceof MultiView.Module) {
                final MultiView.Module mod = (MultiView.Module)((Object)this);
                this.mainMenu.addAction(new ImageIcon(this.getClass().getResource("/resource/Print16.gif")), Resource.getResourceString("Print"), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        mod.print();
                    }
                }, 0);
            }
            this.mainMenu.addAction(null, Resource.getResourceString("dock"), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DockableView.this.dock();
                }
            }, 0);
        }
        this.frame.setJMenuBar(this.mainMenu.getMenuBar());
        this.frame.setDefaultCloseOperation(0);
        this.frame.setTitle(this.getFrameTitle());
        final DockableView dv = this;
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                dv.close();
            }
        });
        this.frame.setIconImage(image);
        this.frame.getLayeredPane().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                dv.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.frame.setVisible(true);
        return this.frame;
    }

    public abstract void refresh();

    public void showView() {
        if (this.frame != null && this.frame.isDisplayable()) {
            this.frame.toFront();
            return;
        }
        if (this.isDisplayable()) {
            return;
        }
        PrefName p = this.getFrameSizePref();
        ViewSize vs = ViewSize.fromString(Prefs.getPref(p));
        if (vs.getDock() == ViewSize.DockType.DOCK) {
            this.dock();
        } else {
            this.openInFrame();
        }
    }

    public void bgStart() {
        PrefName p = this.getFrameSizePref();
        ViewSize vs = ViewSize.fromString(Prefs.getPref(p));
        if (vs.getDock() == ViewSize.DockType.DOCK) {
            this.dock();
        }
    }

    public static DockableView findDockableParent(Component c) {
        for (Container cont = c.getParent(); cont != null; cont = cont.getParent()) {
            if (!(cont instanceof DockableView)) continue;
            return (DockableView)cont;
        }
        return null;
    }
}

