/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableModel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AddressModel;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.MemoModel;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Address;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TableSorter;

public class EntitySelector
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static ArrayList<KeyedEntity<?>> list_ = new ArrayList();
    private JButton clearButton;
    private String[] fields_;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private Collection<? extends KeyedEntity<?>> records_ = null;
    private JButton selectButton;

    public static Address selectAddress() throws Exception {
        Collection addrs = AddressModel.getReference().getAddresses();
        return (Address)EntitySelector.selectBean(addrs, new TableSorter(new String[]{Resource.getResourceString("Last"), Resource.getResourceString("First")}, new Class[]{String.class, String.class}), new String[]{"LastName", "FirstName"});
    }

    public static Appointment selectAppointment(List<Appointment> exclude) throws Exception {
        Collection apps = AppointmentModel.getReference().getAllAppts();
        apps.removeAll(exclude);
        if (Prefs.getPref(PrefName.SHOWPRIVATE).equals("false")) {
            LinkedList<Appointment> privAppts = new LinkedList<Appointment>();
            for (Appointment app : apps) {
                if (!app.isPrivate()) continue;
                privAppts.add(app);
            }
            apps.removeAll(privAppts);
        }
        return (Appointment)EntitySelector.selectBean(apps, new TableSorter(new String[]{Resource.getResourceString("Text"), Resource.getResourceString("Time")}, new Class[]{String.class, Date.class}), new String[]{"ClearText", "Date"});
    }

    private static Object selectBean(Collection<? extends KeyedEntity<?>> records, TableModel tm, String[] fields) {
        new EntitySelector(records, tm, fields, false).setVisible(true);
        if (list_.size() != 0) {
            KeyedEntity<?> b = list_.get(0);
            return b;
        }
        return null;
    }

    public static Memo selectMemo() throws Exception {
        Collection memos = MemoModel.getReference().getMemos();
        return (Memo)EntitySelector.selectBean(memos, new TableSorter(new String[]{Resource.getResourceString("Memo_Name")}, new Class[]{String.class}), new String[]{"MemoName"});
    }

    public static Project selectProject() throws Exception {
        Collection projects = TaskModel.getReference().getProjects();
        return (Project)EntitySelector.selectBean(projects, new TableSorter(new String[]{Resource.getResourceString("Item_#"), Resource.getResourceString("Description")}, new Class[]{Integer.class, String.class}), new String[]{"Key", "Description"});
    }

    public static Task selectTask() throws Exception {
        Collection tasks = TaskModel.getReference().getTasks();
        return (Task)EntitySelector.selectBean(tasks, new TableSorter(new String[]{Resource.getResourceString("Item_#"), Resource.getResourceString("Description")}, new Class[]{Integer.class, String.class}), new String[]{"Key", "Description"});
    }

    private EntitySelector(Collection<? extends KeyedEntity<?>> records, TableModel tm, String[] fields, boolean multiple) {
        this.setModal(true);
        this.records_ = records;
        this.fields_ = fields;
        list_.clear();
        this.initComponents();
        if (tm != null) {
            this.jTable1.setModel(tm);
        }
        this.setTitle(Resource.getResourceString("Select"));
        if (multiple) {
            this.jTable1.setSelectionMode(2);
        } else {
            this.jTable1.setSelectionMode(0);
        }
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EntitySelector.this.jTable1MouseClicked(evt);
            }
        });
        this.loadData();
        this.pack();
    }

    private void clearbuttonActionPerformed(ActionEvent evt) {
        list_.clear();
        this.dispose();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.jTable1 = new StripedTable();
        this.jPanel1 = new JPanel();
        this.selectButton = new JButton();
        this.jTable1.setBorder(new LineBorder(new Color(0, 0, 0)));
        DefaultListSelectionModel mylsmodel = new DefaultListSelectionModel();
        mylsmodel.setSelectionMode(2);
        this.jTable1.setSelectionModel(mylsmodel);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                EntitySelector.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.setPreferredSize(new Dimension(554, 404));
        this.jScrollPane1.setViewportView(this.jTable1);
        this.selectButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Add16.gif")));
        this.selectButton.setText(Resource.getResourceString("Select"));
        this.selectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntitySelector.this.selectbuttonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.selectButton);
        this.clearButton = new JButton();
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Undo16.gif")));
        this.clearButton.setText(Resource.getResourceString("Clear"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EntitySelector.this.clearbuttonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.clearButton);
        this.getContentPane().add((Component)this.jScrollPane1, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        this.getContentPane().add((Component)this.jPanel1, GridBagConstraintsFactory.create(0, 2));
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            this.selectbuttonActionPerformed(null);
        }
    }

    public void loadData() {
        TableSorter tm = (TableSorter)this.jTable1.getModel();
        tm.addMouseListenerToHeaderInTable(this.jTable1);
        tm.setRowCount(0);
        for (KeyedEntity<?> r : this.records_) {
            try {
                Class<?> beanClass = r.getClass();
                Object[] ro = new Object[this.fields_.length];
                for (int i = 0; i < this.fields_.length; ++i) {
                    String method = "get" + this.fields_[i];
                    Method m = beanClass.getMethod(method, null);
                    ro[i] = m.invoke(r, (Object[])null);
                }
                tm.addRow(ro);
                tm.tableChanged(new TableModelEvent(tm));
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
        }
    }

    private void selectbuttonActionPerformed(ActionEvent evt) {
        list_.clear();
        int[] index = this.jTable1.getSelectedRows();
        if (index.length == 0) {
            return;
        }
        for (int i = 0; i < index.length; ++i) {
            try {
                TableSorter tm = (TableSorter)this.jTable1.getModel();
                int k = tm.getMappedIndex(index[i]);
                Object[] oa = this.records_.toArray();
                KeyedEntity b = (KeyedEntity)oa[k];
                list_.add(b);
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        this.dispose();
    }
}

