/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.IOHelper;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ExportImport;
import net.sf.borg.model.Model;
import net.sf.borg.model.db.DBHelper;
import net.sf.borg.model.undo.UndoLog;
import net.sf.borg.ui.CategoryChooser;
import net.sf.borg.ui.HelpLauncher;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.SqlRunner;
import net.sf.borg.ui.UIControl;
import net.sf.borg.ui.ical.IcalModule;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.ScrolledDialog;

class MainMenu {
    private JMenu actionMenu = new JMenu();
    private JMenu helpmenu = new JMenu();
    private JMenu optionsMenu = new JMenu();
    private JMenu pluginMenu = null;
    private JMenuBar menuBar = new JMenuBar();

    public MainMenu() {
        this.menuBar.setBorder(new BevelBorder(0));
        this.actionMenu.setIcon(new ImageIcon(this.getClass().getResource("/resource/Application16.gif")));
        ResourceHelper.setText(this.actionMenu, "Action");
        JMenuItem syncMI = new JMenuItem();
        syncMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Refresh16.gif")));
        syncMI.setText(Resource.getResourceString("Synchronize"));
        syncMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Model.syncModels();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        this.actionMenu.add(syncMI);
        JMenuItem sqlMI = new JMenuItem();
        sqlMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Refresh16.gif")));
        ResourceHelper.setText(sqlMI, "RunSQL");
        sqlMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new SqlRunner().setVisible(true);
            }
        });
        this.actionMenu.add(sqlMI);
        JMenuItem exitMenuItem = new JMenuItem();
        exitMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/resource/Stop16.gif")));
        exitMenuItem.setText(Resource.getResourceString("Exit"));
        exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UIControl.shutDownUI();
            }
        });
        this.actionMenu.add(exitMenuItem);
        this.menuBar.add(this.actionMenu);
        this.optionsMenu.setIcon(new ImageIcon(this.getClass().getResource("/resource/Preferences16.gif")));
        ResourceHelper.setText(this.optionsMenu, "Options");
        JMenuItem editPrefsMenuItem = new JMenuItem();
        ResourceHelper.setText(editPrefsMenuItem, "ep");
        editPrefsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsView.getReference().setVisible(true);
            }
        });
        this.optionsMenu.add(editPrefsMenuItem);
        JMenuItem exportPrefsMI = new JMenuItem();
        exportPrefsMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Export16.gif")));
        ResourceHelper.setText(exportPrefsMI, "export_prefs");
        exportPrefsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.expPrefs();
            }
        });
        this.optionsMenu.add(exportPrefsMI);
        JMenuItem importPrefsMI = new JMenuItem();
        importPrefsMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Import16.gif")));
        ResourceHelper.setText(importPrefsMI, "import_prefs");
        importPrefsMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.impPrefs();
            }
        });
        this.optionsMenu.add(importPrefsMI);
        this.menuBar.add(this.optionsMenu);
        this.menuBar.add(CategoryChooser.getReference().getCategoryMenu());
        JMenu impexpMenu = new JMenu();
        impexpMenu.setIcon(new ImageIcon(this.getClass().getResource("/resource/Export16.gif")));
        ResourceHelper.setText(impexpMenu, "impexpMenu");
        JMenuItem importMI = new JMenuItem();
        importMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.importMIActionPerformed();
            }
        });
        importMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Import16.gif")));
        ResourceHelper.setText(importMI, "impXML");
        impexpMenu.add(importMI);
        JMenuItem importZipMI = new JMenuItem();
        ResourceHelper.setText(importZipMI, "import_zip");
        importZipMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.importZipMIActionPerformed();
            }
        });
        importZipMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Import16.gif")));
        impexpMenu.add(importZipMI);
        JMenuItem exportMI = new JMenuItem();
        exportMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.exportMIActionPerformed();
            }
        });
        exportMI.setIcon(new ImageIcon(this.getClass().getResource("/resource/Export16.gif")));
        ResourceHelper.setText(exportMI, "expXML");
        impexpMenu.add(exportMI);
        this.menuBar.add(impexpMenu);
        this.menuBar.add(this.getUndoMenu());
        this.menuBar.add(IcalModule.getIcalMenu());
        this.menuBar.add(this.getPluginMenu());
        this.menuBar.add(Box.createHorizontalGlue());
        this.helpmenu.setIcon(new ImageIcon(this.getClass().getResource("/resource/Help16.gif")));
        ResourceHelper.setText(this.helpmenu, "Help");
        JMenuItem helpMI = new JMenuItem();
        ResourceHelper.setText(helpMI, "Help");
        helpMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    HelpLauncher.launchHelp();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        this.helpmenu.add(helpMI);
        JMenuItem dbMI = new JMenuItem();
        ResourceHelper.setText(dbMI, "DatabaseInformation");
        dbMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.dbMIActionPerformed();
            }
        });
        this.helpmenu.add(dbMI);
        JMenuItem AboutMI = new JMenuItem();
        ResourceHelper.setText(AboutMI, "About");
        AboutMI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainMenu.AboutMIActionPerformed();
            }
        });
        this.helpmenu.add(AboutMI);
        this.helpmenu.insertSeparator(this.helpmenu.getItemCount() - 1);
        this.menuBar.add(this.helpmenu);
        String dbtype = Prefs.getPref(PrefName.DBTYPE);
        if (dbtype.equals("mysql") || dbtype.equals("jdbc")) {
            syncMI.setEnabled(true);
        } else {
            syncMI.setEnabled(false);
        }
    }

    private static void importZipMIActionPerformed() {
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.zip,*.ZIP", "zip", "ZIP");
        chooser.setFileFilter(filter);
        chooser.setCurrentDirectory(IOHelper.getHomeDirectory());
        chooser.setDialogTitle(Resource.getResourceString("Please_choose_File_to_Import_From"));
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        String fileName = chooser.getSelectedFile().getAbsolutePath();
        IOHelper.setHomeDirectory(fileName);
        try {
            ExportImport.importFromZip((String)fileName);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void addAction(Icon icon, String text, ActionListener action, int insertIndex) {
        JMenuItem item = new JMenuItem();
        item.setIcon(icon);
        item.setText(text);
        item.addActionListener(action);
        this.actionMenu.insert(item, insertIndex);
    }

    public void addHelpMenuItem(Icon icon, String text, ActionListener action) {
        JMenuItem item = new JMenuItem();
        item.setIcon(icon);
        item.setText(text);
        item.addActionListener(action);
        this.helpmenu.insert(item, this.helpmenu.getItemCount() - 2);
    }

    public void addOptionsMenuItem(JMenuItem item) {
        this.optionsMenu.add(item);
    }

    public static void AboutMIActionPerformed() {
        String build_info = "";
        String version = "";
        try {
            InputStream is = MainMenu.class.getResource("/properties").openStream();
            Properties props = new Properties();
            props.load(is);
            is.close();
            version = Resource.getVersion();
            build_info = Resource.getResourceString("Build_Time:_") + props.getProperty("build.time");
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        String info = Resource.getResourceString("Berger-Organizer_v") + version + "\n" + Resource.getResourceString("copyright") + " (2003-2014) Michael Berger <i_flem@users.sourceforge.net>\nhttp://borg-calendar.sourceforge.net\n\n" + Resource.getResourceString("contributions_by") + "\n" + Resource.getResourceString("contrib") + "\n" + Resource.getResourceString("translations") + "\n\n" + build_info + "\n" + "Java " + System.getProperty("java.version");
        Object[] opts = new Object[]{Resource.getResourceString("Dismiss")};
        JOptionPane.showOptionDialog(null, info, Resource.getResourceString("About_BORG"), 0, 1, new ImageIcon(MainMenu.class.getResource("/resource/borg.jpg")), opts, opts[0]);
    }

    private static void dbMIActionPerformed() {
        String dbtype = Prefs.getPref(PrefName.DBTYPE);
        String info = Resource.getResourceString("DatabaseInformation") + ":\n\n";
        info = info + dbtype + " URL: " + DBHelper.getController().buildURL() + "\n\n";
        try {
            for (Model model : Model.getExistingModels()) {
                info = info + model.getInfo() + "\n";
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
            return;
        }
        ScrolledDialog.showNotice(info);
    }

    private static void exportMIActionPerformed() {
        String s;
        while (true) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(IOHelper.getHomeDirectory());
            chooser.setDialogTitle(Resource.getResourceString("Please_choose_directory_to_place_XML_files"));
            chooser.setFileSelectionMode(1);
            chooser.setApproveButtonText(Resource.getResourceString("select_export_dir"));
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            s = chooser.getSelectedFile().getAbsolutePath();
            IOHelper.setHomeDirectory(s);
            File dir = new File(s);
            String err = null;
            if (!dir.exists()) {
                err = Resource.getResourceString("Directory_[") + s + Resource.getResourceString("]_does_not_exist");
            } else if (!dir.isDirectory()) {
                err = "[" + s + Resource.getResourceString("]_is_not_a_directory");
            }
            if (err == null) break;
            Errmsg.getErrorHandler().notice(err);
        }
        try {
            ExportImport.exportToZip((String)s, (boolean)false);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private static void expPrefs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(IOHelper.getHomeDirectory());
        chooser.setDialogTitle(Resource.getResourceString("choose_file"));
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        String s = chooser.getSelectedFile().getAbsolutePath();
        IOHelper.setHomeDirectory(s);
        File file = new File(s);
        try {
            if (MainMenu.checkOverwrite(file.getAbsolutePath())) {
                Prefs.export(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public static boolean checkOverwrite(String fname) {
        File f = new File(fname);
        if (!f.exists()) {
            return true;
        }
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("overwrite_warning") + fname + " ?", "confirm_overwrite", 2);
        return ret == 0;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private JMenu getPluginMenu() {
        if (this.pluginMenu == null) {
            this.pluginMenu = new JMenu();
            this.pluginMenu.setText(Resource.getResourceString("Plugins"));
            this.pluginMenu.setIcon(new ImageIcon(this.getClass().getResource("/resource/Preferences16.gif")));
            this.pluginMenu.setVisible(false);
        }
        return this.pluginMenu;
    }

    public void addPluginSubMenu(JMenu menu) {
        this.pluginMenu.add(menu);
        this.pluginMenu.setVisible(true);
    }

    private JMenu getUndoMenu() {
        JMenu m = new JMenu();
        m.setText(Resource.getResourceString("undo"));
        m.setIcon(new ImageIcon(this.getClass().getResource("/resource/Refresh16.gif")));
        final JMenu menu = m;
        m.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent arg0) {
            }

            @Override
            public void menuDeselected(MenuEvent arg0) {
            }

            @Override
            public void menuSelected(MenuEvent e) {
                menu.removeAll();
                final String top = UndoLog.getReference().getTopItem();
                if (top != null) {
                    JMenuItem mi = new JMenuItem(Resource.getResourceString("undo") + ": " + top);
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("undo") + ": " + top + "\n\n" + Resource.getResourceString("please_confirm"), "", 2);
                            if (ret != 0) {
                                return;
                            }
                            UndoLog.getReference().executeUndo();
                        }
                    });
                    menu.add(mi);
                    JMenuItem cmi = new JMenuItem();
                    cmi.setText(Resource.getResourceString("clear_undos"));
                    cmi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("clear_undos") + "\n\n" + Resource.getResourceString("please_confirm"), "", 2);
                            if (ret != 0) {
                                return;
                            }
                            UndoLog.getReference().clear();
                        }
                    });
                    menu.add(cmi);
                    boolean show_stack = Prefs.getBoolPref(PrefName.SHOW_UNDO_STACK);
                    if (show_stack) {
                        JMenu all_mi = new JMenu(Resource.getResourceString("all_undos"));
                        for (String item : UndoLog.getReference().getItemStrings()) {
                            JMenuItem item_mi = new JMenuItem(Resource.getResourceString("undo") + ": " + item);
                            all_mi.add(item_mi);
                        }
                        menu.add(all_mi);
                    }
                } else {
                    menu.add(new JMenuItem(Resource.getResourceString("no_undos")));
                }
            }
        });
        return m;
    }

    private static void importMIActionPerformed() {
        try {
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(Resource.getResourceString("xml_file"), "xml", "XML");
            chooser.setFileFilter(filter);
            chooser.setCurrentDirectory(IOHelper.getHomeDirectory());
            chooser.setDialogTitle(Resource.getResourceString("Please_choose_File_to_Import_From"));
            chooser.setFileSelectionMode(0);
            int returnVal = chooser.showOpenDialog(null);
            if (returnVal != 0) {
                return;
            }
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            IOHelper.setHomeDirectory(fileName);
            BufferedReader in = new BufferedReader(new FileReader(new File(fileName)));
            Model model = ExportImport.getImportModelForXML((BufferedReader)in);
            in.close();
            if (model == null) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("import_format_error"));
                return;
            }
            int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Importing_") + " " + model.getExportName() + ", OK?", Resource.getResourceString("Import_WARNING"), 2);
            if (ret != 0) {
                return;
            }
            try {
                ExportImport.importFromXmlFile((Model)model, (InputStream)new FileInputStream(fileName));
            }
            catch (Exception e) {
                Errmsg.logError(e);
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Import_error"));
            }
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private static void impPrefs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(IOHelper.getHomeDirectory());
        chooser.setDialogTitle(Resource.getResourceString("choose_file"));
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal != 0) {
            return;
        }
        String s = chooser.getSelectedFile().getAbsolutePath();
        IOHelper.setHomeDirectory(s);
        File file = new File(s);
        try {
            Prefs.importPrefs(file.getAbsolutePath());
        }
        catch (Exception e) {
            String err = Resource.getResourceString("import_format_error") + ": " + e.getLocalizedMessage();
            Errmsg.getErrorHandler().notice(err);
        }
    }
}

