/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.util.DateDialog;

public class NavPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton label = new JButton();
    private Navigator nav_ = null;

    public NavPanel(Navigator nav) {
        this.nav_ = nav;
        this.setLayout(new GridBagLayout());
        JButton Prev = new JButton();
        Prev.setMaximumSize(new Dimension(16, 16));
        Prev.setIcon(new ImageIcon(this.getClass().getResource("/resource/Back16.gif")));
        Prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavPanel.this.nav_.prev();
                NavPanel.this.label.setText(NavPanel.this.nav_.getNavLabel());
            }
        });
        JButton Next = new JButton();
        Next.setIcon(new ImageIcon(this.getClass().getResource("/resource/Forward16.gif")));
        Next.setHorizontalTextPosition(2);
        Next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavPanel.this.nav_.next();
                NavPanel.this.label.setText(NavPanel.this.nav_.getNavLabel());
            }
        });
        JButton Today = new JButton();
        Today.setIcon(new ImageIcon(this.getClass().getResource("/resource/Home16.gif")));
        Today.setToolTipText(Resource.getResourceString("Today"));
        Today.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NavPanel.this.nav_.today();
                NavPanel.this.label.setText(NavPanel.this.nav_.getNavLabel());
            }
        });
        JButton Goto = new JButton();
        Goto.setIcon(new ImageIcon(this.getClass().getResource("/resource/Undo16.gif")));
        Goto.setToolTipText(Resource.getResourceString("Go_To"));
        Goto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DateDialog dlg = new DateDialog(null);
                dlg.setCalendar(new GregorianCalendar());
                dlg.setVisible(true);
                Calendar dlgcal = dlg.getCalendar();
                if (dlgcal == null) {
                    return;
                }
                NavPanel.this.nav_.goTo(dlgcal);
                NavPanel.this.label.setText(NavPanel.this.nav_.getNavLabel());
            }
        });
        this.label.setHorizontalAlignment(0);
        this.label.setHorizontalTextPosition(0);
        this.label.setText(this.nav_.getNavLabel());
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 0;
        cons.gridx = 0;
        cons.gridy = 0;
        this.add((Component)Today, cons);
        cons.gridx = 1;
        this.add((Component)Prev, cons);
        cons.gridx = 2;
        cons.weightx = 1.0;
        cons.fill = 2;
        this.add((Component)this.label, cons);
        cons.fill = 0;
        cons.weightx = 0.0;
        cons.gridx = 3;
        this.add((Component)Next, cons);
        cons.gridx = 4;
        this.add((Component)Goto, cons);
    }

    public void setLabel(String l) {
        this.label.setText(l);
    }

    public static interface Navigator {
        public String getNavLabel();

        public void goTo(Calendar var1);

        public void next();

        public void prev();

        public void today();
    }
}

