/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui;

class ViewSize {
    private int height = -1;
    private int width = -1;
    private int x = -1;
    private int y = -1;
    private boolean maximized = false;
    private DockType dock = DockType.DOCK;

    public static ViewSize fromString(String s) {
        ViewSize vs = new ViewSize();
        String[] toks = s.split(",");
        vs.x = Integer.parseInt(toks[0]);
        vs.y = Integer.parseInt(toks[1]);
        vs.width = Integer.parseInt(toks[2]);
        vs.height = Integer.parseInt(toks[3]);
        vs.maximized = toks[4].equals("Y");
        if (toks.length > 5) {
            try {
                vs.dock = DockType.valueOf(toks[5]);
            }
            catch (Exception e) {
                vs.dock = DockType.DOCK;
            }
        }
        return vs;
    }

    public String toString() {
        return Integer.toString(this.x) + "," + Integer.toString(this.y) + "," + Integer.toString(this.width) + "," + Integer.toString(this.height) + "," + (this.maximized ? "Y" : "N") + "," + this.dock.toString();
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public DockType getDock() {
        return this.dock;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public void setDock(DockType dock) {
        this.dock = dock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ViewSize)) {
            return false;
        }
        ViewSize other = (ViewSize)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        if (this.isMaximized() != other.isMaximized()) {
            return false;
        }
        DockType this$dock = this.getDock();
        DockType other$dock = other.getDock();
        return !(this$dock == null ? other$dock != null : !((Object)((Object)this$dock)).equals((Object)other$dock));
    }

    public boolean canEqual(Object other) {
        return other instanceof ViewSize;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = result * 31 + this.getHeight();
        result = result * 31 + this.getWidth();
        result = result * 31 + this.getX();
        result = result * 31 + this.getY();
        result = result * 31 + (this.isMaximized() ? 1231 : 1237);
        DockType $dock = this.getDock();
        result = result * 31 + ($dock == null ? 0 : ((Object)((Object)$dock)).hashCode());
        return result;
    }

    public static enum DockType {
        DOCK,
        UNDOCK;

    }
}

