/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.DateUtil;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.common.Warning;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.link.LinkPanel;
import net.sf.borg.ui.popup.PopupOptionsView;
import net.sf.borg.ui.util.DateTimePanel;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.LimitDocument;
import net.sf.borg.ui.util.PasswordHelper;

public class AppointmentPanel
extends JPanel
implements PopupOptionsView.PopupOptionsListener {
    private static final long serialVersionUID = 1L;
    private static SpinnerNumberModel prioritySpinnerModel = new SpinnerNumberModel(5, 1, 10, 1);
    private JTextArea appointmentBodyTextArea;
    private JTextField apptTitleField = null;
    private LinkPanel linkPanel = null;
    private JComboBox<String> categoryBox;
    private JSpinner prioritySpinner;
    private JCheckBox dateChangeCheckBox;
    private JComboBox<String> colorComboBox;
    private String[] colors = new String[]{"red", "blue", "green", "black", "white", "strike"};
    private char[] custRemTimes;
    private int day_;
    private int month_;
    private int year_;
    private int starthour;
    private int startminute;
    private JToggleButton[] dayToggles = new JToggleButton[7];
    private JPanel selectDayButtonPanel = null;
    private JComboBox<String> repeatFrequencyComboBox;
    private JCheckBox halfDayVacationCheckBox;
    private JCheckBox holidayCheckBox;
    private int currentlyShownAppointmentKey;
    private JSpinner nTimesValue = null;
    private JLabel newAppointmentIndicatorLabel;
    private JDateChooser newdatefield;
    private JCheckBox untimedCheckBox;
    private JLabel popupTimesLabel;
    private JCheckBox privateCheckBox;
    private JCheckBox showRepeatNumberCheckBox = null;
    private JSpinner numberOfRepeatsSpinner;
    private DateTimePanel startTimePanel = null;
    private DateTimePanel endTimePanel = null;
    private JCheckBox todoCheckBox;
    private JCheckBox vacationCheckBox;
    private JButton decryptButton = null;
    private JLabel durationLabel = new JLabel();
    private JCheckBox encryptBox = null;
    private JDateChooser untilDate = null;
    private JRadioButton repeatForeverRadio = null;
    private JRadioButton repeatTimesRadio = null;
    private JRadioButton repeatUntilRadio = null;
    private JButton saveCloseButton = null;
    private JButton saveButton = null;

    public AppointmentPanel(int year, int month, int day) {
        this.initComponents();
        this.decryptButton.setEnabled(false);
        this.prioritySpinner.setModel(prioritySpinnerModel);
        this.prioritySpinner.setVisible(true);
        try {
            Collection cats = CategoryModel.getReference().getCategories();
            Iterator it = cats.iterator();
            while (it.hasNext()) {
                this.categoryBox.addItem((String)it.next());
            }
            this.categoryBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        this.setDate(year, month, day);
        this.setCustRemTimes(null);
        this.apptTitleField.requestFocus();
        this.startTimePanel.addTimeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    Date s = AppointmentPanel.this.startTimePanel.getTime();
                    AppointmentPanel.this.endTimePanel.setTime(new Date(s.getTime() + 1800000L));
                    AppointmentPanel.this.durationLabel.setText(DateUtil.minuteString(30));
                }
                catch (Warning warning) {
                    // empty catch block
                }
            }
        });
        this.endTimePanel.addTimeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    int mins = (int)((AppointmentPanel.this.endTimePanel.getTime().getTime() - AppointmentPanel.this.startTimePanel.getTime().getTime()) / 60000L);
                    if (mins < 0) {
                        mins += 1440;
                    } else if (mins >= 1440) {
                        mins -= 1440;
                    }
                    AppointmentPanel.this.durationLabel.setText(DateUtil.minuteString(mins));
                }
                catch (Warning warning) {
                    // empty catch block
                }
            }
        });
    }

    private static void encryptAppt(Appointment appt) throws Exception {
        String pw = PasswordHelper.getReference().getPassword();
        if (pw == null) {
            return;
        }
        appt.encrypt(pw);
    }

    private void add_appt() throws Warning, Exception {
        AppointmentModel calmod_ = AppointmentModel.getReference();
        Appointment r = calmod_.newAppt();
        this.setAppt(r, true);
        if (this.encryptBox.isSelected()) {
            AppointmentPanel.encryptAppt(r);
        }
        calmod_.saveAppt(r);
        this.showapp(-1, null);
    }

    private void chg_appt() throws Warning, Exception {
        AppointmentModel calmod_ = AppointmentModel.getReference();
        Appointment appt = calmod_.newAppt();
        boolean dateChg = this.setAppt(appt, true);
        appt.setKey(this.currentlyShownAppointmentKey);
        if (!dateChg) {
            try {
                Appointment originalAppt = calmod_.getAppt(this.currentlyShownAppointmentKey);
                GregorianCalendar origDate = new GregorianCalendar();
                origDate.setTime(originalAppt.getDate());
                GregorianCalendar newDate = new GregorianCalendar();
                newDate.setTime(appt.getDate());
                newDate.set(1, origDate.get(1));
                newDate.set(2, origDate.get(2));
                newDate.set(5, origDate.get(5));
                appt.setDate(newDate.getTime());
                appt.setCreateTime(originalAppt.getCreateTime());
                appt.setLastMod(originalAppt.getLastMod());
                appt.setUid(originalAppt.getUid());
                if (appt.getTimes().intValue() == originalAppt.getTimes().intValue() && appt.getRepeatUntil() == originalAppt.getRepeatUntil() && appt.getFrequency() != null && originalAppt.getFrequency() != null && Repeat.getFreq((String)appt.getFrequency()).equals(Repeat.getFreq((String)originalAppt.getFrequency())) && appt.isTodo() == originalAppt.isTodo() && appt.isRepeatFlag() == originalAppt.isRepeatFlag()) {
                    appt.setSkipList(originalAppt.getSkipList());
                    appt.setNextTodo(originalAppt.getNextTodo());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.encryptBox.isSelected()) {
                AppointmentPanel.encryptAppt(appt);
            }
            calmod_.saveAppt(appt);
        } else {
            appt.setKey(this.currentlyShownAppointmentKey);
            try {
                if (this.encryptBox.isSelected()) {
                    AppointmentPanel.encryptAppt(appt);
                }
                calmod_.saveAppt(appt);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        this.showapp(-1, null);
    }

    private JPanel createDaySelectPanel() {
        this.selectDayButtonPanel = new JPanel();
        SimpleDateFormat shortDayFmt = new SimpleDateFormat("EEE");
        GregorianCalendar tmpcal = new GregorianCalendar();
        tmpcal.set(7, 1);
        for (int i = 0; i < this.dayToggles.length; ++i) {
            this.dayToggles[i] = new JToggleButton();
            this.dayToggles[i].setText(shortDayFmt.format(tmpcal.getTime()));
            this.selectDayButtonPanel.add(this.dayToggles[i]);
            tmpcal.add(7, 1);
        }
        return this.selectDayButtonPanel;
    }

    private JPanel createRepeatPanel() {
        String fs;
        JPanel theRepeatPanel = new JPanel();
        theRepeatPanel.setLayout(new GridBagLayout());
        theRepeatPanel.setBorder(new TitledBorder(null, Resource.getResourceString("Recurrence"), 0, 0, null, null));
        JLabel frequencyLabel = new JLabel();
        frequencyLabel.setHorizontalAlignment(4);
        ResourceHelper.setText(frequencyLabel, "Frequency");
        frequencyLabel.setLabelFor(this.repeatFrequencyComboBox);
        theRepeatPanel.add((Component)frequencyLabel, GridBagConstraintsFactory.create(0, 0));
        this.repeatFrequencyComboBox = new JComboBox();
        this.repeatFrequencyComboBox.setOpaque(false);
        int i = 0;
        while ((fs = Repeat.getFreqString((int)i)) != null) {
            this.repeatFrequencyComboBox.addItem(fs);
            ++i;
        }
        this.repeatFrequencyComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppointmentPanel.this.timesEnable();
            }
        });
        theRepeatPanel.add(this.repeatFrequencyComboBox, GridBagConstraintsFactory.create(1, 0, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.repeatTimesRadio = new JRadioButton();
        ResourceHelper.setText(this.repeatTimesRadio, "Times");
        theRepeatPanel.add((Component)this.repeatTimesRadio, GridBagConstraintsFactory.create(0, 1, 1));
        buttonGroup.add(this.repeatTimesRadio);
        this.numberOfRepeatsSpinner = new JSpinner();
        theRepeatPanel.add((Component)this.numberOfRepeatsSpinner, GridBagConstraintsFactory.create(1, 1, 1));
        SpinnerNumberModel mod = (SpinnerNumberModel)this.numberOfRepeatsSpinner.getModel();
        mod.setMinimum(new Integer(1));
        mod.setMaximum(new Integer(99999));
        this.repeatUntilRadio = new JRadioButton();
        ResourceHelper.setText(this.repeatUntilRadio, "Until");
        theRepeatPanel.add((Component)this.repeatUntilRadio, GridBagConstraintsFactory.create(0, 2, 1));
        buttonGroup.add(this.repeatUntilRadio);
        this.untilDate = new JDateChooser();
        theRepeatPanel.add((Component)this.untilDate, GridBagConstraintsFactory.create(1, 2, 1));
        this.nTimesValue = new JSpinner();
        this.nTimesValue.setModel(new SpinnerNumberModel(2, 2, 3000, 1));
        theRepeatPanel.add((Component)this.nTimesValue, GridBagConstraintsFactory.create(2, 0, 2));
        this.repeatForeverRadio = new JRadioButton();
        ResourceHelper.setText(this.repeatForeverRadio, "forever");
        theRepeatPanel.add((Component)this.repeatForeverRadio, GridBagConstraintsFactory.create(2, 1, 1));
        buttonGroup.add(this.repeatForeverRadio);
        this.showRepeatNumberCheckBox = new JCheckBox();
        ResourceHelper.setText(this.showRepeatNumberCheckBox, "show_rpt_num");
        theRepeatPanel.add((Component)this.showRepeatNumberCheckBox, GridBagConstraintsFactory.create(2, 2, 1));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridwidth = 2;
        theRepeatPanel.add((Component)this.createDaySelectPanel(), gridBagConstraints1);
        return theRepeatPanel;
    }

    private void initComponents() {
        JLabel subjectLabel = new JLabel();
        subjectLabel.setText(Resource.getResourceString("subject"));
        this.newAppointmentIndicatorLabel = new JLabel();
        JScrollPane apptTextScroll = new JScrollPane();
        this.appointmentBodyTextArea = new JTextArea(new LimitDocument(Prefs.getIntPref(PrefName.MAX_TEXT_SIZE)));
        this.prioritySpinner = new JSpinner();
        JLabel starttimeLabel = new JLabel();
        JLabel endTimeLabel = new JLabel();
        this.untimedCheckBox = new JCheckBox();
        JLabel newDateLabel = new JLabel();
        this.newdatefield = new JDateChooser();
        this.newdatefield.setDateFormatString("MMM dd, yyyy");
        this.dateChangeCheckBox = new JCheckBox();
        JPanel appointmentPropetiesPanel = new JPanel();
        this.todoCheckBox = new JCheckBox();
        this.vacationCheckBox = new JCheckBox();
        this.halfDayVacationCheckBox = new JCheckBox();
        this.holidayCheckBox = new JCheckBox();
        this.privateCheckBox = new JCheckBox();
        JLabel lblColor = new JLabel();
        this.colorComboBox = new JComboBox();
        this.categoryBox = new JComboBox();
        JLabel lblCategory = new JLabel();
        JLabel lblPriority = new JLabel();
        JPanel buttonPanel = new JPanel();
        this.saveButton = new JButton();
        this.saveCloseButton = new JButton();
        JButton savedefaultsbutton = new JButton();
        this.apptTitleField = new JTextField();
        lblCategory.setLabelFor(this.categoryBox);
        lblColor.setLabelFor(this.colorComboBox);
        newDateLabel.setLabelFor((Component)this.newdatefield);
        this.setLayout(new GridBagLayout());
        this.newAppointmentIndicatorLabel.setForeground(Color.red);
        this.add((Component)this.newAppointmentIndicatorLabel, GridBagConstraintsFactory.create(0, 0, 1));
        JPanel appointmentTextPanel = new JPanel();
        appointmentTextPanel.setLayout(new GridBagLayout());
        appointmentTextPanel.setBorder(new TitledBorder(Resource.getResourceString("appttext")));
        this.appointmentBodyTextArea.setColumns(40);
        this.appointmentBodyTextArea.setLineWrap(true);
        this.appointmentBodyTextArea.setRows(5);
        this.appointmentBodyTextArea.setWrapStyleWord(true);
        this.appointmentBodyTextArea.setBorder(new BevelBorder(1));
        this.appointmentBodyTextArea.setMinimumSize(new Dimension(284, 140));
        apptTextScroll.setViewportView(this.appointmentBodyTextArea);
        appointmentTextPanel.add((Component)subjectLabel, GridBagConstraintsFactory.create(0, 0));
        appointmentTextPanel.add((Component)this.apptTitleField, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        appointmentTextPanel.add((Component)apptTextScroll, GridBagConstraintsFactory.create(1, 1, 1, 0.5, 0.5));
        GridBagConstraints gridBagConstraints3 = GridBagConstraintsFactory.create(0, 1, 1);
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.weightx = 1.5;
        gridBagConstraints3.weighty = 2.0;
        this.add((Component)appointmentTextPanel, gridBagConstraints3);
        JPanel appointmentTimePanel = new JPanel();
        appointmentTimePanel.setLayout(new GridBagLayout());
        appointmentTimePanel.setBorder(new TitledBorder(Resource.getResourceString("appttime")));
        ResourceHelper.setText(starttimeLabel, "Start_Time:");
        appointmentTimePanel.add((Component)starttimeLabel, GridBagConstraintsFactory.create(0, 0, 1));
        this.startTimePanel = new DateTimePanel(false, Prefs.getBoolPref(PrefName.MILTIME));
        appointmentTimePanel.add((Component)this.startTimePanel, GridBagConstraintsFactory.create(1, 0, 1));
        ResourceHelper.setText(this.untimedCheckBox, "No_Specific_Time");
        this.untimedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppointmentPanel.this.untimedCheckBoxActionPerformed();
            }
        });
        GridBagConstraints gridBagConstraints12 = GridBagConstraintsFactory.create(2, 0, 1);
        appointmentTimePanel.add((Component)this.untimedCheckBox, gridBagConstraints12);
        endTimeLabel.setText(Resource.getResourceString("EndTime") + ":");
        appointmentTimePanel.add((Component)endTimeLabel, GridBagConstraintsFactory.create(0, 1, 1));
        this.endTimePanel = new DateTimePanel(false, Prefs.getBoolPref(PrefName.MILTIME));
        appointmentTimePanel.add((Component)this.endTimePanel, GridBagConstraintsFactory.create(1, 1, 1));
        this.durationLabel.setText("1/2 hour");
        appointmentTimePanel.add((Component)this.durationLabel, GridBagConstraintsFactory.create(2, 1, 1));
        ResourceHelper.setText(this.dateChangeCheckBox, "changedate");
        this.dateChangeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AppointmentPanel.this.newdatefield.setEnabled(AppointmentPanel.this.dateChangeCheckBox.isSelected());
            }
        });
        appointmentTimePanel.add((Component)new JLabel("       "), GridBagConstraintsFactory.create(3, 0, 2));
        appointmentTimePanel.add((Component)this.dateChangeCheckBox, GridBagConstraintsFactory.create(4, 0, 2));
        ResourceHelper.setText(newDateLabel, "newDate:");
        appointmentTimePanel.add((Component)newDateLabel, GridBagConstraintsFactory.create(5, 0, 1));
        appointmentTimePanel.add((Component)this.newdatefield, GridBagConstraintsFactory.create(6, 0, 1));
        appointmentPropetiesPanel.setLayout(new GridBagLayout());
        appointmentPropetiesPanel.setBorder(new TitledBorder(Resource.getResourceString("Properties")));
        appointmentPropetiesPanel.setMinimumSize(new Dimension(539, 128));
        ResourceHelper.setText(this.todoCheckBox, "To_Do");
        this.todoCheckBox.setOpaque(false);
        appointmentPropetiesPanel.add((Component)this.todoCheckBox, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 0.0));
        this.vacationCheckBox.setForeground(new Color(0, 102, 0));
        ResourceHelper.setText(this.vacationCheckBox, "Vacation");
        this.vacationCheckBox.setOpaque(false);
        appointmentPropetiesPanel.add((Component)this.vacationCheckBox, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        this.halfDayVacationCheckBox.setForeground(new Color(0, 102, 102));
        ResourceHelper.setText(this.halfDayVacationCheckBox, "Half_Day");
        this.halfDayVacationCheckBox.setOpaque(false);
        appointmentPropetiesPanel.add((Component)this.halfDayVacationCheckBox, GridBagConstraintsFactory.create(2, 0, 1, 1.0, 0.0));
        ResourceHelper.setText(this.holidayCheckBox, "Holiday");
        this.holidayCheckBox.setOpaque(false);
        appointmentPropetiesPanel.add((Component)this.holidayCheckBox, GridBagConstraintsFactory.create(3, 0, 1, 1.0, 0.0));
        ResourceHelper.setText(this.privateCheckBox, "Private");
        this.privateCheckBox.setOpaque(false);
        appointmentPropetiesPanel.add((Component)this.privateCheckBox, GridBagConstraintsFactory.create(4, 0, 1, 1.0, 0.0));
        JPanel subPanel = new JPanel();
        subPanel.setLayout(new GridBagLayout());
        subPanel.add((Component)new JLabel(), GridBagConstraintsFactory.create(-1, 0, 1, 1.0, 0.0));
        lblColor.setHorizontalAlignment(4);
        ResourceHelper.setText(lblColor, "Color");
        subPanel.add((Component)lblColor, GridBagConstraintsFactory.create(-1, 0, 1));
        this.colorComboBox.setOpaque(false);
        subPanel.add(this.colorComboBox, GridBagConstraintsFactory.create(-1, 0, 1));
        ColorBoxRenderer cbr = new ColorBoxRenderer();
        this.colorComboBox.setRenderer(cbr);
        this.colorComboBox.setEditable(false);
        for (int i = 0; i < this.colors.length; ++i) {
            this.colorComboBox.addItem(this.colors[i]);
        }
        lblCategory.setHorizontalAlignment(4);
        ResourceHelper.setText(lblCategory, "Category");
        subPanel.add((Component)lblCategory, GridBagConstraintsFactory.create(-1, 0, 1, 1.0, 0.0));
        subPanel.add(this.categoryBox, GridBagConstraintsFactory.create(-1, 0, 1));
        lblPriority.setHorizontalAlignment(4);
        ResourceHelper.setText(lblPriority, "Priority");
        subPanel.add((Component)lblPriority, GridBagConstraintsFactory.create(-1, 0, 1, 1.0, 0.0));
        subPanel.add((Component)this.prioritySpinner, GridBagConstraintsFactory.create(-1, 0, 1));
        subPanel.add((Component)new JLabel(), GridBagConstraintsFactory.create(-1, 0, 1, 1.0, 0.0));
        GridBagConstraints subPanelConstraints = GridBagConstraintsFactory.create(0, 1, 1, 1.0, 0.0);
        subPanelConstraints.gridwidth = 5;
        appointmentPropetiesPanel.add((Component)subPanel, subPanelConstraints);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(this.saveButton, "Save");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (AppointmentPanel.this.currentlyShownAppointmentKey == -1) {
                        AppointmentPanel.this.add_appt();
                    } else {
                        AppointmentPanel.this.chg_appt();
                    }
                }
                catch (Warning w) {
                    Errmsg.getErrorHandler().notice(w.getMessage());
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        buttonPanel.add(this.saveButton);
        this.saveCloseButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(this.saveCloseButton, "Save_&_Close");
        this.saveCloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (AppointmentPanel.this.currentlyShownAppointmentKey == -1) {
                        AppointmentPanel.this.add_appt();
                    } else {
                        AppointmentPanel.this.chg_appt();
                    }
                }
                catch (Warning w) {
                    Errmsg.getErrorHandler().notice(w.getMessage());
                    return;
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
                DockableView parent = DockableView.findDockableParent(AppointmentPanel.this.saveCloseButton);
                if (parent != null) {
                    parent.close();
                }
            }
        });
        buttonPanel.add(this.saveCloseButton);
        this.encryptBox = new JCheckBox();
        this.encryptBox.setText(Resource.getResourceString("EncryptOnSave"));
        buttonPanel.add((Component)this.encryptBox, null);
        this.decryptButton = new JButton();
        this.decryptButton.setText(Resource.getResourceString("decrypt"));
        this.decryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int newlineIndex;
                    Appointment appt = AppointmentModel.getReference().getAppt(AppointmentPanel.this.currentlyShownAppointmentKey);
                    if (appt == null) {
                        return;
                    }
                    String pw = PasswordHelper.getReference().getPassword();
                    if (pw == null) {
                        return;
                    }
                    appt.decrypt(pw);
                    String t = appt.getText();
                    String title = "";
                    String body = "";
                    if (t == null) {
                        t = "";
                    }
                    if ((newlineIndex = t.indexOf(10)) != -1) {
                        title = t.substring(0, newlineIndex);
                        body = t.substring(newlineIndex + 1);
                    } else {
                        title = t;
                    }
                    AppointmentPanel.this.appointmentBodyTextArea.setText(body);
                    AppointmentPanel.this.apptTitleField.setText(title);
                    AppointmentPanel.this.appointmentBodyTextArea.setEditable(true);
                    AppointmentPanel.this.apptTitleField.setEditable(true);
                    AppointmentPanel.this.decryptButton.setEnabled(false);
                    AppointmentPanel.this.saveButton.setEnabled(true);
                    AppointmentPanel.this.saveCloseButton.setEnabled(true);
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                }
            }
        });
        buttonPanel.add((Component)this.decryptButton, null);
        savedefaultsbutton.setIcon(new ImageIcon(this.getClass().getResource("/resource/SaveAs16.gif")));
        ResourceHelper.setText(savedefaultsbutton, "save_Def");
        savedefaultsbutton.setToolTipText(Resource.getResourceString("sd_tip"));
        savedefaultsbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Appointment appt = new Appointment();
                try {
                    AppointmentPanel.this.setAppt(appt, false);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
                AppointmentModel.getReference().saveDefaultAppointment(appt);
            }
        });
        buttonPanel.add(new JLabel("          "));
        buttonPanel.add(savedefaultsbutton);
        this.popupTimesLabel = new JLabel();
        this.popupTimesLabel.setHorizontalAlignment(4);
        JButton popupTimesBtn = new JButton();
        ResourceHelper.setText(popupTimesBtn, "Change");
        final AppointmentPanel thisPanel = this;
        popupTimesBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String apptTitle = AppointmentPanel.this.apptTitleField.getText();
                if (apptTitle.equals("")) {
                    apptTitle = Resource.getResourceString("*****_NEW_APPT_*****");
                }
                PopupOptionsView pv = new PopupOptionsView(new String(AppointmentPanel.this.custRemTimes), apptTitle, thisPanel);
                pv.setVisible(true);
            }
        });
        JPanel popupReminderPanel = new JPanel();
        popupReminderPanel.setBorder(new TitledBorder(Resource.getResourceString("popup_reminders")));
        popupReminderPanel.add(this.popupTimesLabel);
        popupReminderPanel.add(popupTimesBtn);
        GridBagConstraints gridBagConstraints17 = GridBagConstraintsFactory.create(0, 2, 1, 1.0, 1.0);
        gridBagConstraints17.gridwidth = 0;
        this.add((Component)appointmentTimePanel, gridBagConstraints17);
        this.setSize(648, 590);
        GridBagConstraints gridBagConstraints38 = GridBagConstraintsFactory.create(0, 3, 1);
        gridBagConstraints38.gridwidth = 2;
        this.add((Component)appointmentPropetiesPanel, gridBagConstraints38);
        this.add((Component)this.createRepeatPanel(), GridBagConstraintsFactory.create(0, 5, 1));
        GridBagConstraints gridBagConstraints91 = GridBagConstraintsFactory.create(0, 6, 1);
        gridBagConstraints91.gridwidth = 2;
        this.add((Component)buttonPanel, gridBagConstraints91);
        GridBagConstraints gridBagConstraints87 = GridBagConstraintsFactory.create(0, 4, 1, 9.0, 1.0);
        gridBagConstraints87.gridwidth = 2;
        this.add((Component)popupReminderPanel, gridBagConstraints87);
        this.linkPanel = new LinkPanel();
        this.linkPanel.setBorder(new TitledBorder(Resource.getResourceString("links")));
        this.add((Component)this.linkPanel, GridBagConstraintsFactory.create(1, 5, 1));
    }

    private void untimedCheckBoxActionPerformed() {
        if (this.untimedCheckBox.isSelected()) {
            this.startTimePanel.setTime(DateUtil.setToMidnight(new Date()));
            this.startTimePanel.setEnabled(false);
            this.endTimePanel.setTime(DateUtil.setToMidnight(new Date()));
            this.endTimePanel.setEnabled(false);
        } else {
            this.startTimePanel.setEnabled(true);
            this.endTimePanel.setEnabled(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean setAppt(Appointment appt, boolean validate) throws Warning, Exception {
        nd = null;
        dateChg = false;
        if (this.dateChangeCheckBox.isSelected()) {
            nd = this.newdatefield.getDate();
            dateChg = true;
        }
        d = this.startTimePanel.getTime();
        g = new GregorianCalendar();
        g.setTime(d);
        if (nd == null) {
            g.set(1, this.year_);
            g.set(2, this.month_);
            g.set(5, this.day_);
        } else {
            g2 = new GregorianCalendar();
            g2.setTime(nd);
            g.set(1, g2.get(1));
            g.set(2, g2.get(2));
            g.set(5, g2.get(5));
        }
        appt.setDate(g.getTime());
        if (this.untimedCheckBox.isSelected()) {
            appt.setUntimed("Y");
        }
        if ((du = (int)((end = this.endTimePanel.getTime().getTime() % 86400000L) - (beg = this.startTimePanel.getTime().getTime() % 86400000L)) / 60000) < 0) {
            du += 1440;
        }
        if (du != 0) {
            appt.setDuration(new Integer(du));
        }
        if (this.apptTitleField.getText().trim().isEmpty() && validate) {
            this.apptTitleField.requestFocus();
            throw new Warning(Resource.getResourceString("Please_enter_some_appointment_text"));
        }
        t = this.apptTitleField.getText();
        if (this.appointmentBodyTextArea.getText() != null && !this.appointmentBodyTextArea.getText().equals("")) {
            t = t + "\n" + this.appointmentBodyTextArea.getText();
        }
        appt.setText(t);
        appt.setTodo(this.todoCheckBox.isSelected());
        if (this.vacationCheckBox.isSelected() && this.halfDayVacationCheckBox.isSelected()) {
            throw new Warning(Resource.getResourceString("vacation_warning"));
        }
        if (this.vacationCheckBox.isSelected()) {
            appt.setVacation(new Integer(1));
        }
        if (this.halfDayVacationCheckBox.isSelected()) {
            appt.setVacation(new Integer(2));
        }
        if (this.holidayCheckBox.isSelected()) {
            appt.setHoliday(new Integer(1));
        }
        appt.setPrivate(this.privateCheckBox.isSelected());
        appt.setColor((String)this.colorComboBox.getSelectedItem());
        if (this.repeatFrequencyComboBox.getSelectedIndex() != 0) {
            daylist = new ArrayList<Integer>();
            if (this.dayToggles[0].isSelected()) {
                daylist.add(new Integer(1));
            }
            if (this.dayToggles[1].isSelected()) {
                daylist.add(new Integer(2));
            }
            if (this.dayToggles[2].isSelected()) {
                daylist.add(new Integer(3));
            }
            if (this.dayToggles[3].isSelected()) {
                daylist.add(new Integer(4));
            }
            if (this.dayToggles[4].isSelected()) {
                daylist.add(new Integer(5));
            }
            if (this.dayToggles[5].isSelected()) {
                daylist.add(new Integer(6));
            }
            if (this.dayToggles[6].isSelected()) {
                daylist.add(new Integer(7));
            }
            if (!Repeat.isCompatible((Calendar)g, (String)((String)this.repeatFrequencyComboBox.getSelectedItem()), daylist)) {
                throw new Warning(Resource.getResourceString("recur_compat"));
            }
            appt.setFrequency(Repeat.freqString((String)((String)this.repeatFrequencyComboBox.getSelectedItem()), (Integer)((Integer)this.nTimesValue.getValue()), (boolean)this.showRepeatNumberCheckBox.isSelected(), daylist));
        }
        tm = null;
        tm = this.repeatForeverRadio.isSelected() != false ? new Integer(9999) : (Integer)this.numberOfRepeatsSpinner.getValue();
        appt.setRepeatFlag(false);
        if (tm > 1 && this.repeatFrequencyComboBox.getSelectedIndex() != 0) {
            try {
                appt.setTimes(tm);
                if (tm <= 1) ** GOTO lbl82
                appt.setRepeatFlag(true);
            }
            catch (Exception e) {
                throw new Exception(Resource.getResourceString("Could_not_parse_times:_") + tm);
            }
        } else {
            appt.setTimes(new Integer(1));
        }
lbl82:
        // 3 sources

        if (this.repeatUntilRadio.isSelected() && this.repeatFrequencyComboBox.getSelectedIndex() != 0) {
            until = this.untilDate.getDate();
            if (until.before(appt.getDate())) {
                throw new Exception(Resource.getResourceString("until_date_error"));
            }
            appt.setRepeatUntil(until);
            appt.setRepeatFlag(true);
        } else {
            appt.setRepeatUntil(null);
        }
        cat = (String)this.categoryBox.getSelectedItem();
        if (cat.equals("") || cat.equals(CategoryModel.UNCATEGORIZED)) {
            appt.setCategory(null);
        } else {
            appt.setCategory(cat);
        }
        appt.setReminderTimes(new String(this.custRemTimes));
        appt.setPriority((Integer)this.prioritySpinner.getValue());
        return dateChg;
    }

    private void setCustRemTimes(Appointment appt) {
        if (appt == null) {
            this.custRemTimes = new char[ReminderTimes.getNum()];
            for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                this.custRemTimes[i] = 78;
            }
        } else {
            try {
                this.custRemTimes = appt.getReminderTimes().toCharArray();
            }
            catch (Exception e) {
                for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                    this.custRemTimes[i] = 78;
                }
            }
        }
    }

    public void setDate(int year, int month, int day) {
        this.year_ = year;
        this.month_ = month;
        this.day_ = day;
    }

    public void setStartTime(int hour, int minute) {
        this.starthour = hour;
        if (minute - 15 < 0) {
            this.startminute = 0;
        } else if (minute - 45 < 0) {
            this.startminute = 30;
        } else {
            this.starthour = hour + 1;
            this.startminute = 0;
        }
    }

    @Override
    public void setPopupTimesString(String reminderTimes) {
        StringBuffer line1 = new StringBuffer(ReminderTimes.getNum() * 5 + 15);
        StringBuffer line2 = new StringBuffer(ReminderTimes.getNum() * 5 + 15);
        this.custRemTimes = reminderTimes.toCharArray();
        if (this.custRemTimes != null) {
            int i;
            for (i = 0; ReminderTimes.getTimes((int)i) < 0 && i < ReminderTimes.getNum(); ++i) {
                if (this.custRemTimes[i] != 'Y') continue;
                int abs = -ReminderTimes.getTimes((int)i);
                line1 = line1.length() > 0 ? line1.append(", ").append(abs) : line1.append(abs);
            }
            if (line1.length() > 0) {
                line1 = line1.append("   ").append(Resource.getResourceString("min_aft_app"));
            }
            while (i < ReminderTimes.getNum()) {
                if (this.custRemTimes[i] == 'Y') {
                    line2 = line2.length() > 0 ? line2.append(", ").append(ReminderTimes.getTimes((int)i)) : line2.append(ReminderTimes.getTimes((int)i));
                }
                ++i;
            }
            if (line2.length() > 0) {
                line2 = line2.append("   ").append(Resource.getResourceString("min_bef_app"));
            }
        }
        this.popupTimesLabel.setText("<html><p align=RIGHT>" + line1.toString() + "<br>" + line2.toString());
    }

    public void showapp(int key, Appointment defaultApptIn) {
        Appointment defaultAppt = defaultApptIn;
        this.currentlyShownAppointmentKey = key;
        this.startTimePanel.setEnabled(false);
        this.endTimePanel.setEnabled(false);
        this.untimedCheckBox.setSelected(true);
        this.dateChangeCheckBox.setSelected(false);
        this.encryptBox.setSelected(false);
        this.appointmentBodyTextArea.setEditable(true);
        this.apptTitleField.setEditable(true);
        this.decryptButton.setEnabled(false);
        this.saveButton.setEnabled(true);
        this.saveCloseButton.setEnabled(true);
        for (JToggleButton tog : this.dayToggles) {
            tog.setSelected(false);
        }
        if (defaultAppt == null) {
            defaultAppt = AppointmentModel.getReference().getDefaultAppointment();
        }
        if (this.currentlyShownAppointmentKey == -1 && defaultAppt == null) {
            if (this.starthour > 0) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.set(11, this.starthour);
                cal.set(12, this.startminute);
                cal.set(13, 0);
                cal.set(14, 0);
                this.startTimePanel.setTime(cal.getTime());
                cal.set(11, this.starthour + 1);
                this.endTimePanel.setTime(cal.getTime());
                this.startTimePanel.setEnabled(true);
                this.endTimePanel.setEnabled(true);
                this.untimedCheckBox.setSelected(false);
            } else {
                this.startTimePanel.setTime(DateUtil.setToMidnight(new Date()));
                this.endTimePanel.setTime(DateUtil.setToMidnight(new Date()));
            }
            this.categoryBox.setSelectedIndex(0);
            this.apptTitleField.setText("");
            this.todoCheckBox.setSelected(false);
            this.colorComboBox.setSelectedIndex(3);
            this.vacationCheckBox.setSelected(false);
            this.halfDayVacationCheckBox.setSelected(false);
            this.holidayCheckBox.setSelected(false);
            this.privateCheckBox.setSelected(false);
            this.appointmentBodyTextArea.setText("");
            this.repeatFrequencyComboBox.setSelectedIndex(0);
            this.numberOfRepeatsSpinner.setEnabled(true);
            this.numberOfRepeatsSpinner.setValue(new Integer(1));
            this.repeatForeverRadio.setSelected(false);
            this.repeatUntilRadio.setSelected(false);
            this.untilDate.setEnabled(false);
            this.showRepeatNumberCheckBox.setSelected(false);
            this.showRepeatNumberCheckBox.setEnabled(false);
            ResourceHelper.setText(this.newAppointmentIndicatorLabel, "*****_NEW_APPT_*****");
            this.dateChangeCheckBox.setEnabled(false);
            this.newdatefield.setEnabled(false);
            this.setCustRemTimes(null);
            this.setPopupTimesString(new String(this.custRemTimes));
        } else {
            try {
                Collection daylist;
                Appointment appt = null;
                if (this.currentlyShownAppointmentKey == -1) {
                    ResourceHelper.setText(this.newAppointmentIndicatorLabel, "*****_NEW_APPT_*****");
                    appt = defaultAppt;
                    this.linkPanel.setOwner(null);
                } else {
                    this.newAppointmentIndicatorLabel.setText("    ");
                    appt = AppointmentModel.getReference().getAppt(this.currentlyShownAppointmentKey);
                    this.linkPanel.setOwner((KeyedEntity<?>)appt);
                }
                Integer duration = appt.getDuration();
                int dur = 0;
                if (duration != null) {
                    dur = duration;
                }
                if (this.currentlyShownAppointmentKey == -1 && this.starthour > 0) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.set(11, this.starthour);
                    cal.set(12, this.startminute);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    this.startTimePanel.setTime(cal.getTime());
                    cal.set(11, this.starthour + 1);
                    this.endTimePanel.setTime(cal.getTime());
                    this.startTimePanel.setEnabled(true);
                    this.endTimePanel.setEnabled(true);
                    this.untimedCheckBox.setSelected(false);
                } else {
                    this.startTimePanel.setTime(appt.getDate());
                    Date end = new Date();
                    end.setTime(appt.getDate().getTime() + (long)(dur * 60 * 1000));
                    this.endTimePanel.setTime(end);
                    boolean untimed = AppointmentModel.isNote((Appointment)appt);
                    if (!untimed) {
                        this.startTimePanel.setEnabled(true);
                        this.endTimePanel.setEnabled(true);
                        this.untimedCheckBox.setSelected(false);
                    }
                }
                this.todoCheckBox.setSelected(appt.isTodo());
                this.vacationCheckBox.setSelected(false);
                Integer ii = appt.getVacation();
                if (ii != null && ii == 1) {
                    this.vacationCheckBox.setSelected(true);
                }
                this.halfDayVacationCheckBox.setSelected(false);
                if (ii != null && ii == 2) {
                    this.halfDayVacationCheckBox.setSelected(true);
                }
                this.holidayCheckBox.setSelected(false);
                ii = appt.getHoliday();
                if (ii != null && ii == 1) {
                    this.holidayCheckBox.setSelected(true);
                }
                this.privateCheckBox.setSelected(appt.isPrivate());
                if (appt.isEncrypted()) {
                    this.apptTitleField.setText(Resource.getResourceString("EncryptedItem"));
                    this.apptTitleField.setEditable(false);
                    this.appointmentBodyTextArea.setText("");
                    this.appointmentBodyTextArea.setEditable(false);
                    this.decryptButton.setEnabled(true);
                } else {
                    int newlineIndex;
                    String t = appt.getText();
                    String title = "";
                    String body = "";
                    if (t == null) {
                        t = "";
                    }
                    if ((newlineIndex = t.indexOf(10)) != -1) {
                        title = t.substring(0, newlineIndex);
                        body = t.substring(newlineIndex + 1);
                    } else {
                        title = t;
                    }
                    this.appointmentBodyTextArea.setText(body);
                    this.apptTitleField.setText(title);
                }
                String sel = appt.getColor();
                if (sel != null) {
                    if (sel.equals("black")) {
                        this.colorComboBox.setSelectedIndex(3);
                    } else if (sel.equals("red")) {
                        this.colorComboBox.setSelectedIndex(0);
                    } else if (sel.equals("blue")) {
                        this.colorComboBox.setSelectedIndex(1);
                    } else if (sel.equals("green")) {
                        this.colorComboBox.setSelectedIndex(2);
                    } else if (sel.equals("white")) {
                        this.colorComboBox.setSelectedIndex(4);
                    } else {
                        this.colorComboBox.setSelectedIndex(5);
                    }
                } else {
                    this.colorComboBox.setSelectedIndex(3);
                }
                this.dateChangeCheckBox.setEnabled(true);
                this.newdatefield.setEnabled(false);
                String rpt = Repeat.getFreq((String)appt.getFrequency());
                if (rpt != null && (rpt.equals("ndays") || rpt.equals("nweeks") || rpt.equals("nmonths") | rpt.equals("nyears"))) {
                    this.nTimesValue.setValue(new Integer(Repeat.getNValue((String)appt.getFrequency())));
                }
                if (rpt != null && rpt.equals("dlist") && (daylist = Repeat.getDaylist((String)appt.getFrequency())) != null) {
                    if (daylist.contains(new Integer(1))) {
                        this.dayToggles[0].setSelected(true);
                    }
                    if (daylist.contains(new Integer(2))) {
                        this.dayToggles[1].setSelected(true);
                    }
                    if (daylist.contains(new Integer(3))) {
                        this.dayToggles[2].setSelected(true);
                    }
                    if (daylist.contains(new Integer(4))) {
                        this.dayToggles[3].setSelected(true);
                    }
                    if (daylist.contains(new Integer(5))) {
                        this.dayToggles[4].setSelected(true);
                    }
                    if (daylist.contains(new Integer(6))) {
                        this.dayToggles[5].setSelected(true);
                    }
                    if (daylist.contains(new Integer(7))) {
                        this.dayToggles[6].setSelected(true);
                    }
                }
                this.showRepeatNumberCheckBox.setSelected(Repeat.getRptNum((String)appt.getFrequency()));
                this.repeatFrequencyComboBox.setSelectedItem(Repeat.getFreqString((String)rpt));
                Integer tm = appt.getTimes();
                this.numberOfRepeatsSpinner.setValue(new Integer(1));
                this.untilDate.setDate(null);
                if (appt.getRepeatUntil() != null) {
                    this.untilDate.setDate(appt.getRepeatUntil());
                    this.repeatUntilRadio.setSelected(true);
                } else if (tm != null) {
                    if (tm == 9999) {
                        this.repeatForeverRadio.setSelected(true);
                    } else {
                        this.numberOfRepeatsSpinner.setValue(tm);
                        this.repeatTimesRadio.setSelected(true);
                    }
                } else {
                    this.repeatTimesRadio.setSelected(true);
                }
                String cat = appt.getCategory();
                if (cat != null && !cat.equals("")) {
                    this.categoryBox.setSelectedItem(cat);
                } else {
                    this.categoryBox.setSelectedIndex(0);
                }
                this.setCustRemTimes(appt);
                this.setPopupTimesString(new String(this.custRemTimes));
                this.encryptBox.setSelected(appt.isEncrypted());
                if (appt.isEncrypted()) {
                    this.saveButton.setEnabled(false);
                    this.saveCloseButton.setEnabled(false);
                }
                Integer p = new Integer(5);
                Integer priority = appt.getPriority();
                if (priority != null) {
                    p = priority;
                }
                this.prioritySpinner.setValue(p);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                Exception ne = new Exception(Resource.getResourceString("appt_error"));
                Errmsg.getErrorHandler().errmsg(ne);
            }
        }
        this.timesEnable();
        this.apptTitleField.requestFocus();
    }

    private void timesEnable() {
        if (this.repeatFrequencyComboBox.getSelectedIndex() == 0) {
            this.numberOfRepeatsSpinner.setEnabled(false);
            this.repeatForeverRadio.setEnabled(false);
            this.repeatTimesRadio.setEnabled(false);
            this.repeatUntilRadio.setEnabled(false);
            this.showRepeatNumberCheckBox.setEnabled(false);
            this.untilDate.setEnabled(false);
        } else {
            this.numberOfRepeatsSpinner.setEnabled(true);
            this.repeatForeverRadio.setEnabled(true);
            this.repeatTimesRadio.setEnabled(true);
            this.repeatUntilRadio.setEnabled(true);
            this.showRepeatNumberCheckBox.setEnabled(true);
            this.untilDate.setEnabled(true);
        }
        String english = Repeat.freqToEnglish((String)((String)this.repeatFrequencyComboBox.getSelectedItem()));
        if (english.equals("ndays") || english.equals("nweeks") || english.equals("nmonths") || english.equals("nyears")) {
            this.nTimesValue.setVisible(true);
            this.selectDayButtonPanel.setVisible(false);
        } else if (english.equals("dlist")) {
            this.selectDayButtonPanel.setVisible(true);
            this.nTimesValue.setVisible(false);
        } else {
            this.selectDayButtonPanel.setVisible(false);
            this.nTimesValue.setVisible(false);
        }
    }

    private static class SolidComboBoxIcon
    implements Icon {
        private Color color = Color.BLACK;
        private final int h = 10;
        private final int w = 60;

        public SolidComboBoxIcon(Color col) {
            this.color = col;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public int getIconWidth() {
            return 60;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.BLACK);
            g2.drawRect(x, y, 60, 10);
            g2.setColor(this.color);
            g2.fillRect(x, y, 60, 10);
        }
    }

    private static class ColorBoxRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public ColorBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String sel = (String)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            this.setText(" ");
            Theme t = Theme.getCurrentTheme();
            if (sel.equals("black")) {
                this.setIcon(new SolidComboBoxIcon(new Color(t.getTextColor4())));
            } else if (sel.equals("red")) {
                this.setIcon(new SolidComboBoxIcon(new Color(t.getTextColor1())));
            } else if (sel.equals("blue")) {
                this.setIcon(new SolidComboBoxIcon(new Color(t.getTextColor2())));
            } else if (sel.equals("green")) {
                this.setIcon(new SolidComboBoxIcon(new Color(t.getTextColor3())));
            } else if (sel.equals("white")) {
                this.setIcon(new SolidComboBoxIcon(new Color(t.getTextColor5())));
            } else {
                this.setText(Resource.getResourceString("strike"));
                this.setIcon(null);
            }
            return this;
        }
    }
}

