/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Repeat;
import net.sf.borg.model.entity.Appointment;

public class AppointmentTextFormat {
    public static String format(Appointment appt, Date date) {
        Date d;
        if (appt.getText() == null) {
            return "";
        }
        GregorianCalendar day = new GregorianCalendar();
        day.setTime(date);
        String theFormattedText = "";
        if (!AppointmentModel.isNote((Appointment)appt) && (d = appt.getDate()) != null) {
            SimpleDateFormat sdf = AppointmentModel.getTimeFormat();
            theFormattedText = theFormattedText + sdf.format(d) + " ";
        }
        if (appt.isEncrypted()) {
            theFormattedText = theFormattedText + Resource.getResourceString("EncryptedItemShort");
        } else {
            int ii;
            String xx = appt.getText();
            String trunc = Prefs.getPref(PrefName.TRUNCAPPT);
            theFormattedText = trunc.equals("true") ? ((ii = xx.indexOf(10)) != -1 ? theFormattedText + xx.substring(0, ii) : theFormattedText + xx) : theFormattedText + xx;
        }
        if (Repeat.getRptNum((String)appt.getFrequency())) {
            theFormattedText = theFormattedText + " (" + Repeat.calculateRepeatNumber((Calendar)day, (Appointment)appt) + ")";
        }
        if (appt.getVacation() != null && appt.getVacation() != 0) {
            day.set(11, 11);
            double vacationCount = AppointmentModel.getReference().vacationCount(day.getTime());
            theFormattedText = "[" + vacationCount + "] " + theFormattedText;
        }
        return theFormattedText;
    }
}

