/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Day;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.NavPanel;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.calendar.ApptBoxPanel;
import net.sf.borg.ui.calendar.ButtonBox;
import net.sf.borg.ui.calendar.MonthPrintPanel;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class MonthPanel
extends JPanel
implements Printable,
MultiView.CalendarModule {
    private static final long serialVersionUID = 1L;
    private NavPanel nav = null;
    private MonthViewSubPanel monthSubPanel = null;
    private boolean isInitialized = false;

    @Override
    public void goTo(Calendar cal) {
        if (this.isInitialized) {
            this.monthSubPanel.goTo(cal);
            this.nav.setLabel(this.monthSubPanel.getNavLabel());
        }
    }

    @Override
    public int print(Graphics arg0, PageFormat arg1, int arg2) throws PrinterException {
        return this.monthSubPanel.print(arg0, arg1, arg2);
    }

    public void printMonths() {
        try {
            MonthPrintPanel.printMonths(this.monthSubPanel.month_, this.monthSubPanel.year_);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/month.jpg")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.MONTH);
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.MONTH);
            }
        });
    }

    @Override
    public JPanel getComponent() {
        if (!this.isInitialized) {
            this.monthSubPanel = new MonthViewSubPanel();
            this.nav = new NavPanel(this.monthSubPanel);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.nav, GridBagConstraintsFactory.create(0, 0, 1));
            this.add((Component)this.monthSubPanel, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("Month_View");
    }

    @Override
    public void print() {
        this.printMonths();
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.MONTH;
    }

    private class MonthViewSubPanel
    extends ApptBoxPanel
    implements Printable,
    NavPanel.Navigator,
    Model.Listener,
    Prefs.Listener,
    MouseWheelListener {
        private static final long serialVersionUID = 1L;
        private final int numBoxes = 42;
        private int colwidth;
        Color[] colors = new Color[42];
        private int daytop;
        private int lastDrawDate = -1;
        private int month_;
        private int year_;
        boolean needLoad = true;
        private int rowheight;

        public MonthViewSubPanel() {
            Prefs.addListener(this);
            this.addMouseWheelListener(this);
            AppointmentModel.getReference().addListener((Model.Listener)this);
            TaskModel.getReference().addListener((Model.Listener)this);
            this.goTo(new GregorianCalendar());
        }

        public void clearData() {
            this.clearBoxes();
            this.needLoad = true;
            this.setToolTipText(null);
        }

        private int drawIt(Graphics g, double width, double height, double pageWidth, double pageHeight, double pagex, double pagey) {
            int row;
            Theme t = Theme.getCurrentTheme();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Font sm_font = Font.decode(Prefs.getPref(PrefName.APPTFONT));
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(0, 0, (int)width, (int)height);
            g2.setColor(new Color(t.getDefaultFg()));
            int fontHeight = g2.getFontMetrics().getHeight();
            int fontDesent = g2.getFontMetrics().getDescent();
            g2.translate(pagex, pagey);
            Shape s = g2.getClip();
            GregorianCalendar now = new GregorianCalendar();
            int tmon = now.get(2);
            int tyear = now.get(1);
            int tdate = now.get(5);
            if (this.lastDrawDate != tdate) {
                this.needLoad = true;
            }
            this.lastDrawDate = tdate;
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, 1);
            cal.setFirstDayOfWeek(Prefs.getIntPref(PrefName.FIRSTDOW));
            int caltop = 0;
            this.daytop = caltop + fontHeight + fontDesent;
            int weekbutwidth = fontHeight + fontDesent;
            this.rowheight = ((int)pageHeight - this.daytop) / 6;
            this.colwidth = (int)(pageWidth - (double)weekbutwidth) / 7;
            int calbot = 6 * this.rowheight + this.daytop;
            int calright = 7 * this.colwidth;
            this.setDragBounds(this.daytop, calbot, 0, (int)pageWidth - weekbutwidth);
            this.setResizeBounds(0, 0);
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(0, caltop, calright, this.daytop - caltop);
            g2.setColor(new Color(t.getDefaultFg()));
            SimpleDateFormat dfw = new SimpleDateFormat("EEE");
            cal.add(7, cal.getFirstDayOfWeek() - cal.get(7));
            for (int col = 0; col < 7; ++col) {
                int colleft = col * this.colwidth;
                String dayofweek = dfw.format(cal.getTime());
                int swidth = g2.getFontMetrics().stringWidth(dayofweek);
                g2.drawString(dayofweek, colleft + (this.colwidth - swidth) / 2, caltop + fontHeight);
                cal.add(7, 1);
            }
            cal.set(this.year_, this.month_, 1);
            int fdow = cal.get(7) - cal.getFirstDayOfWeek();
            if (fdow == -1) {
                fdow = 6;
            }
            cal.add(5, -1 * fdow);
            for (int box = 0; box < 42; ++box) {
                int boxcol = box % 7;
                int boxrow = box / 7;
                int rowtop = boxrow * this.rowheight + this.daytop;
                int colleft = boxcol * this.colwidth;
                int dow = cal.getFirstDayOfWeek() + boxcol;
                if (dow == 8) {
                    dow = 1;
                }
                g2.setFont(sm_font);
                int smfontHeight = g2.getFontMetrics().getHeight();
                g2.clipRect(colleft, rowtop, this.colwidth, this.rowheight);
                if (this.needLoad) {
                    try {
                        this.addDateZone(cal.getTime(), new Rectangle(colleft, rowtop, this.colwidth, this.rowheight));
                        Day dayInfo = Day.getDay((int)cal.get(1), (int)cal.get(2), (int)cal.get(5));
                        Color c = null;
                        c = tmon == this.month_ && tyear == this.year_ && tdate == cal.get(5) ? new Color(t.getTodayBg()) : (dayInfo.getHoliday() != 0 ? new Color(t.getHolidayBg()) : (dayInfo.getVacation() == 1 ? new Color(Theme.getCurrentTheme().getVacationBg()) : (dayInfo.getVacation() == 2 ? new Color(t.getHalfdayBg()) : (dow == 1 || dow == 7 ? new Color(t.getWeekendBg()) : new Color(t.getWeekdayBg())))));
                        if (cal.get(2) != this.month_) {
                            c = new Color(t.getDefaultBg());
                        }
                        this.colors[box] = c;
                        int notey = rowtop + smfontHeight;
                        for (CalendarEntity entity : dayInfo.getItems()) {
                            if (this.addNoteBox(cal.getTime(), entity, new Rectangle(colleft + 2, notey, this.colwidth - 4, smfontHeight), new Rectangle(colleft, rowtop, this.colwidth, this.rowheight)) == null) continue;
                            notey += smfontHeight;
                        }
                        ImageIcon clipIcon = null;
                        if (notey > rowtop + this.rowheight) {
                            clipIcon = new ImageIcon(this.getClass().getResource("/resource/Import16.gif"));
                        }
                        String datetext = Integer.toString(cal.get(5));
                        if (Prefs.getPref(PrefName.DAYOFYEAR).equals("true")) {
                            datetext = datetext + "   [" + cal.get(6) + "]";
                        }
                        this.boxes.add(new ButtonBox(cal.getTime(), datetext, clipIcon, new Rectangle(colleft + 2, rowtop, this.colwidth - 4, smfontHeight), new Rectangle(colleft, rowtop, this.colwidth, smfontHeight + 2), c){

                            @Override
                            public void onClick() {
                                MultiView.getMainView().setView(MultiView.ViewType.DAY);
                                GregorianCalendar gc = new GregorianCalendar();
                                gc.setTime(this.getDate());
                                MultiView.getMainView().goTo(gc);
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                g2.setClip(s);
                g2.setColor(this.colors[box]);
                g2.fillRect(colleft, rowtop, this.colwidth, this.rowheight);
                cal.add(5, 1);
            }
            if (this.needLoad) {
                if (Prefs.getPref(PrefName.ISOWKNUMBER).equals("true")) {
                    cal.setMinimalDaysInFirstWeek(4);
                } else {
                    cal.setMinimalDaysInFirstWeek(1);
                }
                for (row = 0; row < 6; ++row) {
                    cal.set(this.year_, this.month_, 1 + 7 * row);
                    int wk = cal.get(3);
                    int rowtop = row * this.rowheight + this.daytop;
                    this.boxes.add(new ButtonBox(cal.getTime(), Integer.toString(wk), null, new Rectangle((int)pageWidth - weekbutwidth, rowtop, weekbutwidth, this.rowheight), new Rectangle((int)pageWidth - weekbutwidth, rowtop, weekbutwidth + 1, this.rowheight + 1)){

                        @Override
                        public void onClick() {
                            MultiView.getMainView().setView(MultiView.ViewType.WEEK);
                            GregorianCalendar gc = new GregorianCalendar();
                            gc.setTime(this.getDate());
                            MultiView.getMainView().goTo(gc);
                        }
                    });
                }
            }
            this.needLoad = false;
            this.drawBoxes(g2);
            g2.setClip(s);
            g2.setColor(new Color(t.getDefaultFg()));
            g2.drawLine(0, caltop, calright, caltop);
            for (row = 0; row < 7; ++row) {
                int rowtop = row * this.rowheight + this.daytop;
                g2.drawLine(0, rowtop, calright, rowtop);
            }
            for (int col = 0; col < 8; ++col) {
                int colleft = col * this.colwidth;
                g2.drawLine(colleft, caltop, colleft, calbot);
            }
            return 0;
        }

        @Override
        public Date getDateForCoord(double x, double y) {
            int row;
            int col = (int)x / this.colwidth;
            if (col > 6) {
                col = 6;
            }
            if ((row = ((int)y - this.daytop) / this.rowheight) > 5) {
                row = 5;
            }
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, 1);
            cal.setFirstDayOfWeek(Prefs.getIntPref(PrefName.FIRSTDOW));
            int fdow = cal.get(7) - cal.getFirstDayOfWeek();
            if (fdow < 0) {
                fdow += 7;
            }
            cal.add(5, -1 * fdow);
            cal.add(5, row * 7 + col);
            return cal.getTime();
        }

        @Override
        public String getNavLabel() {
            SimpleDateFormat df = new SimpleDateFormat("MMMM yyyy");
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, 1);
            return df.format(cal.getTime());
        }

        @Override
        public void goTo(Calendar cal) {
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.clearData();
            this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() > 0) {
                this.next();
                MonthPanel.this.nav.setLabel(this.getNavLabel());
            } else if (e.getWheelRotation() < 0) {
                this.prev();
                MonthPanel.this.nav.setLabel(this.getNavLabel());
            }
        }

        @Override
        public void next() {
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, 1, 23, 59);
            cal.add(2, 1);
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.clearData();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            try {
                this.drawIt(g, this.getWidth(), this.getHeight(), this.getWidth() - 20, this.getHeight() - 20, 10.0, 10.0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void prefsChanged() {
            this.clearData();
            this.repaint();
        }

        @Override
        public void prev() {
            GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, 1, 23, 59);
            cal.add(2, -1);
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.clearData();
            this.repaint();
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 1) {
                return 1;
            }
            return this.drawIt(g, pageFormat.getWidth(), pageFormat.getHeight(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight(), pageFormat.getImageableX(), pageFormat.getImageableY());
        }

        @Override
        public void refresh() {
            this.clearData();
            this.repaint();
        }

        public void update(Model.ChangeEvent event) {
            this.refresh();
        }

        @Override
        public void today() {
            GregorianCalendar cal = new GregorianCalendar();
            this.year_ = cal.get(1);
            this.month_ = cal.get(2);
            this.clearData();
            this.repaint();
        }
    }
}

