/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.text.AttributedString;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.PrintHelper;
import net.sf.borg.common.Resource;
import net.sf.borg.model.Day;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.ui.calendar.AppointmentTextFormat;
import net.sf.borg.ui.calendar.ApptBoxPanel;

public class MonthPrintPanel
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    private static final double prev_scale = 1.5;
    private int month_;
    private int pages_ = 1;
    private int year_;

    public static void printMonths(int month, int year) throws Exception {
        MonthPrintPanel cp = new MonthPrintPanel(month, year);
        Object[] options = new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9), new Integer(10), new Integer(11), new Integer(12)};
        Object choice = JOptionPane.showInputDialog(null, Resource.getResourceString("nummonths"), Resource.getResourceString("Print_Chooser"), 3, null, options, options[0]);
        if (choice == null) {
            return;
        }
        Integer i = (Integer)choice;
        cp.setPages(i);
        PrintHelper.printPrintable(cp);
    }

    public MonthPrintPanel(int month, int year) {
        this.year_ = year;
        this.month_ = month;
    }

    private int drawIt(Graphics g, double width, double height, double pageWidth, double pageHeight, double pagex, double pagey, int pageIndex) {
        Graphics2D g2 = (Graphics2D)g;
        String cp = "false";
        try {
            cp = Prefs.getPref(PrefName.COLORPRINT);
        }
        catch (Exception e) {
            // empty catch block
        }
        Font def_font = g2.getFont();
        Font sm_font = Font.decode(Prefs.getPref(PrefName.PRINTFONT));
        HashMap<TextAttribute, Serializable> stmap = new HashMap<TextAttribute, Serializable>();
        stmap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        stmap.put(TextAttribute.FONT, sm_font);
        g2.setColor(Color.white);
        g2.fillRect(0, 0, (int)width, (int)height);
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        g2.translate(pagex, pagey);
        Shape s = g2.getClip();
        GregorianCalendar cal = new GregorianCalendar(this.year_, this.month_, 1);
        cal.add(2, pageIndex);
        int year = cal.get(1);
        int month = cal.get(2);
        cal.setFirstDayOfWeek(Prefs.getIntPref(PrefName.FIRSTDOW));
        Date then = cal.getTime();
        SimpleDateFormat sd = new SimpleDateFormat("MMMM yyyy");
        String title = sd.format(then);
        int titlewidth = g2.getFontMetrics().stringWidth(title);
        int caltop = fontHeight + fontDesent;
        int daytop = caltop + fontHeight + fontDesent;
        g2.drawString(title, ((int)pageWidth - titlewidth) / 2, fontHeight);
        int rowheight = ((int)pageHeight - daytop) / 6;
        int colwidth = (int)pageWidth / 7;
        int calbot = 6 * rowheight + daytop;
        int calright = 7 * colwidth;
        SimpleDateFormat dfw = new SimpleDateFormat("EEE");
        cal.add(7, cal.getFirstDayOfWeek() - cal.get(7));
        for (int col = 0; col < 7; ++col) {
            int colleft = col * colwidth;
            String dayofweek = dfw.format(cal.getTime());
            int swidth = g2.getFontMetrics().stringWidth(dayofweek);
            g2.drawString(dayofweek, colleft + (colwidth - swidth) / 2, caltop + fontHeight);
            cal.add(7, 1);
        }
        cal.set(year, month, 1);
        int fdow = cal.get(7) - cal.getFirstDayOfWeek();
        if (fdow < 0) {
            fdow += 7;
        }
        for (int box = 0; box < 42; ++box) {
            int mlen = cal.getActualMaximum(5);
            int boxcol = box % 7;
            int boxrow = box / 7;
            int rowtop = boxrow * rowheight + daytop;
            int colleft = boxcol * colwidth;
            int dow = cal.getFirstDayOfWeek() + boxcol;
            if (dow == 8) {
                dow = 1;
            }
            if (box < fdow || box > fdow + mlen - 1) {
                if (!cp.equals("false")) continue;
                g2.setColor(new Color(235, 235, 235));
                g2.fillRect(colleft, rowtop, colwidth, rowheight);
                g2.setColor(Color.black);
                continue;
            }
            int date = box - fdow + 1;
            g2.setFont(sm_font);
            int smfontHeight = g2.getFontMetrics().getHeight();
            g2.clipRect(colleft, rowtop, colwidth, rowheight);
            try {
                GregorianCalendar gc = new GregorianCalendar(year, month, date);
                Day dayInfo = Day.getDay((int)year, (int)month, (int)date);
                if (dayInfo != null) {
                    Collection appts;
                    if (cp.equals("true")) {
                        if (dayInfo.getVacation() != 0) {
                            g2.setColor(new Color(225, 255, 225));
                        } else if (dayInfo.getHoliday() == 1) {
                            g2.setColor(new Color(255, 225, 195));
                        } else if (dow == 1 || dow == 7) {
                            g2.setColor(new Color(255, 225, 195));
                        } else {
                            g2.setColor(new Color(255, 245, 225));
                        }
                        g2.fillRect(colleft, rowtop, colwidth, rowheight);
                        g2.setColor(Color.black);
                    }
                    if ((appts = dayInfo.getItems()) != null) {
                        int apptx = colleft + 2 * fontDesent;
                        int appty = rowtop + fontHeight + smfontHeight;
                        for (CalendarEntity entity : appts) {
                            if (cp.equals("false")) {
                                g2.setColor(Color.black);
                            } else if (entity.getColor().equals("red")) {
                                g2.setColor(Color.red);
                            } else if (entity.getColor().equals("green")) {
                                g2.setColor(Color.green);
                            } else if (entity.getColor().equals("blue")) {
                                g2.setColor(Color.blue);
                            }
                            String text = entity.getText();
                            if (entity instanceof Appointment) {
                                text = AppointmentTextFormat.format((Appointment)entity, gc.getTime());
                            }
                            if (ApptBoxPanel.isStrike(entity, gc.getTime())) {
                                if (Prefs.getBoolPref(PrefName.HIDESTRIKETHROUGH)) continue;
                                AttributedString as = new AttributedString(text, stmap);
                                g2.drawString(as.getIterator(), apptx, appty);
                            } else {
                                g2.drawString(text, apptx, appty);
                            }
                            appty += smfontHeight;
                            g2.setColor(Color.black);
                        }
                    }
                }
                g2.setClip(s);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
            g2.setFont(def_font);
            g2.drawString(Integer.toString(date), colleft + fontDesent, rowtop + fontHeight);
        }
        g2.drawLine(0, caltop, calright, caltop);
        for (int row = 0; row < 7; ++row) {
            int rowtop = row * rowheight + daytop;
            g2.drawLine(0, rowtop, calright, rowtop);
        }
        for (int col = 0; col < 8; ++col) {
            int colleft = col * colwidth;
            g2.drawLine(colleft, caltop, colleft, calbot);
        }
        return 0;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            Graphics2D g2 = (Graphics2D)g;
            g2.scale(1.5, 1.5);
            this.drawIt(g, (double)this.getWidth() / 1.5, (double)this.getHeight() / 1.5, (double)this.getWidth() / 1.5 - 20.0, (double)this.getHeight() / 1.5 - 20.0, 10.0, 10.0, 0);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > this.pages_ - 1) {
            return 1;
        }
        return this.drawIt(g, pageFormat.getWidth(), pageFormat.getHeight(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight(), pageFormat.getImageableX(), pageFormat.getImageableY(), pageIndex);
    }

    public void setPages(int p) {
        this.pages_ = p;
    }
}

