/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.CategoryModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.model.entity.KeyedEntity;
import net.sf.borg.model.entity.Project;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.model.entity.Task;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.calendar.AppointmentListView;
import net.sf.borg.ui.calendar.AppointmentTextFormat;
import net.sf.borg.ui.task.ProjectView;
import net.sf.borg.ui.task.TaskView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TablePrinter;
import net.sf.borg.ui.util.TableSorter;

public class TodoView
extends DockableView
implements Prefs.Listener,
MultiView.Module {
    private static final long serialVersionUID = 1L;
    private ActionListener changeDateAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ArrayList<Appointment> aplist = new ArrayList<Appointment>();
            for (KeyedEntity ke : TodoView.this.getSelectedItems(true)) {
                aplist.add((Appointment)ke);
            }
            AppointmentListView.onChangeDate(aplist);
        }
    };
    private ActionListener doneDeleteAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            TodoView.this.doTodoAction(true);
        }
    };
    private ActionListener doneNoDeleteAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            TodoView.this.doTodoAction(false);
        }
    };
    private ActionListener moveToFollowingDayAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ArrayList<Appointment> aplist = new ArrayList<Appointment>();
            for (KeyedEntity ke : TodoView.this.getSelectedItems(true)) {
                aplist.add((Appointment)ke);
            }
            AppointmentListView.onMoveToFollowingDay(aplist);
        }
    };
    private JComboBox<String> categoryComboBox;
    private JToggleButton blackToggleButton;
    private JToggleButton blueToggleButton;
    private JToggleButton greenToggleButton;
    private JToggleButton redToggleButton;
    private JToggleButton whiteToggleButton;
    private Collection<KeyedEntity<?>> theTodoList;
    private JDateChooser todoDate;
    private StripedTable todoTable;
    private JTextField todoText;
    private JSpinner todoPrioritySpinner;
    private boolean user_colors = false;
    private JLabel totalLabel;
    private boolean isInitialized = false;

    private void addTodoActionPerformed() {
        String tdtext = this.todoText.getText();
        Calendar c = this.todoDate.getCalendar();
        if (c == null && Prefs.getBoolPref(PrefName.TODO_QUICK_ENTRY_AUTO_SET_DATE_FIELD)) {
            c = new GregorianCalendar();
            c.setTime(new Date());
        }
        if (tdtext.trim().isEmpty() || c == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("todomissingdata"));
            return;
        }
        Appointment appt = AppointmentModel.getReference().getDefaultAppointment();
        if (appt == null) {
            appt = AppointmentModel.getReference().newAppt();
        }
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(9, 0);
        appt.setDate(c.getTime());
        appt.setText(tdtext);
        appt.setTodo(true);
        appt.setPrivate(false);
        if (this.redToggleButton.isSelected()) {
            appt.setColor("red");
        } else if (this.blueToggleButton.isSelected()) {
            appt.setColor("blue");
        } else if (this.greenToggleButton.isSelected()) {
            appt.setColor("green");
        } else if (this.whiteToggleButton.isSelected()) {
            appt.setColor("white");
        } else {
            appt.setColor("black");
        }
        appt.setFrequency("once");
        appt.setTimes(new Integer(1));
        appt.setRepeatFlag(false);
        String cat = (String)this.categoryComboBox.getSelectedItem();
        if (cat.equals("") || cat.equals(CategoryModel.UNCATEGORIZED)) {
            appt.setCategory(null);
        } else {
            appt.setCategory(cat);
        }
        appt.setPriority((Integer)this.todoPrioritySpinner.getValue());
        AppointmentModel.getReference().saveAppt(appt);
        if (Prefs.getBoolPref(PrefName.TODO_QUICK_ENTRY_AUTO_CLEAR_TEXT_FIELD)) {
            this.todoText.setText("");
        }
        this.requestFocus();
    }

    private boolean allAppointmentsSelected() {
        List<KeyedEntity<?>> items = this.getSelectedItems(false);
        for (int i = 0; i < items.size(); ++i) {
            KeyedEntity<?> o = items.get(i);
            if (o instanceof Appointment) continue;
            return false;
        }
        return true;
    }

    private void doTodoAction(boolean del) {
        List<KeyedEntity<?>> items = this.getSelectedItems(false);
        for (int i = 0; i < items.size(); ++i) {
            try {
                KeyedEntity<?> o = items.get(i);
                if (o instanceof Appointment) {
                    int key = ((Appointment)o).getKey();
                    AppointmentModel.getReference().do_todo(key, del);
                    continue;
                }
                if (o instanceof Project) {
                    Project p = (Project)o;
                    TaskModel.getReference().closeProject(p.getKey());
                    continue;
                }
                if (o instanceof Task) {
                    Task t = (Task)o;
                    TaskModel.getReference().close(t.getKey());
                    continue;
                }
                if (!(o instanceof Subtask)) continue;
                Subtask s = (Subtask)o;
                s.setCloseDate(new Date());
                TaskModel.getReference().saveSubTask(s);
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    @Override
    public JPanel getComponent() {
        if (!this.isInitialized) {
            Prefs.addListener(this);
            this.addModel((Model)AppointmentModel.getReference());
            this.addModel((Model)TaskModel.getReference());
            this.addModel((Model)CategoryModel.getReference());
            this.initComponents();
            this.todoTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Date"), Resource.getResourceString("To_Do"), Resource.getResourceString("Category"), Resource.getResourceString("Color"), "key", Resource.getResourceString("Priority")}, new Class[]{Date.class, String.class, String.class, String.class, Integer.class, Integer.class}));
            this.todoTable.getColumnModel().getColumn(0).setPreferredWidth(140);
            this.todoTable.getColumnModel().getColumn(1).setPreferredWidth(400);
            this.todoTable.getColumnModel().getColumn(2).setPreferredWidth(120);
            this.todoTable.getColumnModel().getColumn(5).setPreferredWidth(50);
            this.user_colors = Prefs.getBoolPref(PrefName.UCS_ONTODO);
            TableCellRenderer defaultObjectRenderer = this.todoTable.getDefaultRenderer(Object.class);
            this.todoTable.setDefaultRenderer(Object.class, new TodoTableCellRenderer(defaultObjectRenderer));
            TableCellRenderer defaultDateRenderer = this.todoTable.getDefaultRenderer(Date.class);
            this.todoTable.setDefaultRenderer(Date.class, new TodoTableCellRenderer(defaultDateRenderer));
            TableCellRenderer defaultIntegerRenderer = this.todoTable.getDefaultRenderer(Integer.class);
            this.todoTable.setDefaultRenderer(Integer.class, new TodoTableCellRenderer(defaultIntegerRenderer));
            this.todoTable.removeColumn(this.todoTable.getColumnModel().getColumn(3));
            this.todoTable.removeColumn(this.todoTable.getColumnModel().getColumn(3));
            this.refresh();
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public String getFrameTitle() {
        return Resource.getResourceString("To_Do_List");
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("To_Do");
    }

    private List<KeyedEntity<?>> getSelectedItems(boolean appts_only) {
        ArrayList lst = new ArrayList();
        int[] indices = this.todoTable.getSelectedRows();
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            try {
                TableSorter tm = (TableSorter)this.todoTable.getModel();
                int k = tm.getMappedIndex(index);
                if (k == 0) continue;
                Object o = this.theTodoList.toArray()[k - 1];
                if (appts_only && !(o instanceof Appointment)) continue;
                lst.add((KeyedEntity)o);
                continue;
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        return lst;
    }

    private JLabel getTotalLabel() {
        if (this.totalLabel == null) {
            this.totalLabel = new JLabel();
        }
        return this.totalLabel;
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.TODO;
    }

    private void initComponents() {
        JScrollPane tableScroll = new JScrollPane();
        this.todoTable = new StripedTable();
        this.todoText = new JTextField();
        this.todoText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    TodoView.this.addTodoActionPerformed();
                }
            }
        });
        this.todoDate = new JDateChooser();
        JButton addTodoButton = new JButton();
        JLabel todoLabel = new JLabel();
        JLabel dateLabel = new JLabel();
        this.categoryComboBox = new JComboBox();
        this.redToggleButton = new JToggleButton("", false);
        this.blueToggleButton = new JToggleButton("", false);
        this.greenToggleButton = new JToggleButton("", false);
        this.blackToggleButton = new JToggleButton("", true);
        this.whiteToggleButton = new JToggleButton("", false);
        int val = 5;
        int min = 1;
        int max = 10;
        int step = 1;
        this.todoPrioritySpinner = new JSpinner(new SpinnerNumberModel(val, min, max, step));
        this.loadCategories();
        this.todoTable.setBorder(new LineBorder(new Color(0, 0, 0)));
        DefaultListSelectionModel mylsmodel = new DefaultListSelectionModel();
        mylsmodel.setSelectionMode(2);
        this.todoTable.setSelectionModel(mylsmodel);
        this.todoTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() < 2) {
                    return;
                }
                TodoView.this.onEditTodo();
            }
        });
        tableScroll.setViewportView(this.todoTable);
        JPanel quickEntryPanel = new JPanel();
        quickEntryPanel.setLayout(new GridBagLayout());
        quickEntryPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("todoquickentry"), 0, 0, null, null));
        addTodoButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Save16.gif")));
        ResourceHelper.setText(addTodoButton, "Add");
        addTodoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TodoView.this.addTodoActionPerformed();
            }
        });
        JPanel toggleButtonPanel = new JPanel();
        toggleButtonPanel.setLayout(new FlowLayout());
        toggleButtonPanel.add(this.redToggleButton);
        toggleButtonPanel.add(this.blueToggleButton);
        toggleButtonPanel.add(this.greenToggleButton);
        toggleButtonPanel.add(this.blackToggleButton);
        toggleButtonPanel.add(this.whiteToggleButton);
        Theme t = Theme.getCurrentTheme();
        this.redToggleButton.setIcon(new ToggleButtonIcon(new Color(t.getTextColor1())));
        this.blueToggleButton.setIcon(new ToggleButtonIcon(new Color(t.getTextColor2())));
        this.greenToggleButton.setIcon(new ToggleButtonIcon(new Color(t.getTextColor3())));
        this.blackToggleButton.setIcon(new ToggleButtonIcon(new Color(t.getTextColor4())));
        this.whiteToggleButton.setIcon(new ToggleButtonIcon(new Color(t.getTextColor5())));
        ButtonGroup mutator = new ButtonGroup();
        mutator.add(this.redToggleButton);
        mutator.add(this.blueToggleButton);
        mutator.add(this.greenToggleButton);
        mutator.add(this.blackToggleButton);
        mutator.add(this.whiteToggleButton);
        JLabel categoryLabel = new JLabel();
        ResourceHelper.setText(categoryLabel, "Category");
        categoryLabel.setLabelFor(this.categoryComboBox);
        toggleButtonPanel.add(categoryLabel);
        toggleButtonPanel.add(this.categoryComboBox);
        JLabel priorityLabel = new JLabel();
        ResourceHelper.setText(priorityLabel, "Priority");
        priorityLabel.setLabelFor(this.todoPrioritySpinner);
        toggleButtonPanel.add(priorityLabel);
        toggleButtonPanel.add(this.todoPrioritySpinner);
        ResourceHelper.setText(todoLabel, "To_Do");
        todoLabel.setLabelFor(this.todoText);
        ResourceHelper.setText(dateLabel, "Date");
        dateLabel.setLabelFor((Component)this.todoDate);
        quickEntryPanel.add((Component)todoLabel, GridBagConstraintsFactory.create(0, 0, 2));
        quickEntryPanel.add((Component)this.todoText, GridBagConstraintsFactory.create(0, 1, 2, 10.0, 0.0));
        quickEntryPanel.add((Component)toggleButtonPanel, GridBagConstraintsFactory.create(0, 2, 1, 1.0, 0.0));
        quickEntryPanel.add((Component)dateLabel, GridBagConstraintsFactory.create(1, 0, 2, 1.0, 0.0));
        quickEntryPanel.add((Component)this.todoDate, GridBagConstraintsFactory.create(1, 1, 2));
        quickEntryPanel.add((Component)addTodoButton, GridBagConstraintsFactory.create(2, 1));
        ActionListener alEdit = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TodoView.this.onEditTodo();
            }
        };
        final JPopupMenu apptPopupMenu = PopupMenuHelper.createPopupMenu(new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(this.doneDeleteAction, "Done_(Delete)"), new PopupMenuHelper.Entry(this.doneNoDeleteAction, "Done_(No_Delete)"), new PopupMenuHelper.Entry(alEdit, "Edit"), new PopupMenuHelper.Entry(this.moveToFollowingDayAction, "Move_To_Following_Day"), new PopupMenuHelper.Entry(this.changeDateAction, "changedate")});
        final JPopupMenu todoPopupMenu = PopupMenuHelper.createPopupMenu(new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(this.doneDeleteAction, "Done_(No_Delete)"), new PopupMenuHelper.Entry(alEdit, "Edit")});
        this.todoTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 525: {
                        int[] selIndices = TodoView.this.todoTable.getSelectedRows();
                        if (selIndices.length == 0) {
                            return;
                        }
                        int rowIndex = selIndices[0];
                        Rectangle rct = TodoView.this.todoTable.getCellRect(rowIndex, 0, false);
                        if (TodoView.this.getSelectedItems(false).isEmpty()) {
                            return;
                        }
                        if (TodoView.this.allAppointmentsSelected()) {
                            apptPopupMenu.show(TodoView.this.todoTable, rct.x, rct.y + rct.height);
                            break;
                        }
                        todoPopupMenu.show(TodoView.this.todoTable, rct.x, rct.y + rct.height);
                    }
                }
            }
        });
        this.todoTable.addMouseListener(new MouseAdapter(){

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row = TodoView.this.todoTable.rowAtPoint(e.getPoint());
                    if (row != -1 && !TodoView.this.todoTable.isRowSelected(row)) {
                        TodoView.this.todoTable.getSelectionModel().setSelectionInterval(row, row);
                    }
                    if (TodoView.this.getSelectedItems(false).isEmpty()) {
                        return;
                    }
                    if (TodoView.this.allAppointmentsSelected()) {
                        apptPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    } else {
                        todoPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }
        });
        JPanel buttonPanel = new JPanel();
        JButton doneButton = new JButton();
        ResourceHelper.setText(doneButton, "Done_(No_Delete)");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TodoView.this.doTodoAction(false);
            }
        });
        doneButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Properties16.gif")));
        buttonPanel.add((Component)doneButton, null);
        JButton doneDeleteButton = new JButton();
        ResourceHelper.setText(doneDeleteButton, "Done_(Delete)");
        doneDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TodoView.this.doTodoAction(true);
            }
        });
        doneDeleteButton.setIcon(new ImageIcon(this.getClass().getResource("/resource/Delete16.gif")));
        buttonPanel.add((Component)doneDeleteButton, null);
        this.setLayout(new GridBagLayout());
        this.add((Component)tableScroll, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JPanel medPanel = new JPanel(new BorderLayout());
        medPanel.add((Component)this.getTotalLabel(), "West");
        medPanel.add((Component)buttonPanel, "Center");
        this.add((Component)medPanel, GridBagConstraintsFactory.create(0, 1, 1));
        this.add((Component)quickEntryPanel, GridBagConstraintsFactory.create(0, 2, 2, 1.0, 0.0));
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/Properties16.gif")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(TodoView.this.getViewType());
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(TodoView.this.getViewType());
            }
        });
    }

    private void loadCategories() {
        try {
            this.categoryComboBox.removeAllItems();
            Collection acats = CategoryModel.getReference().getCategories();
            Iterator ait = acats.iterator();
            while (ait.hasNext()) {
                this.categoryComboBox.addItem((String)ait.next());
            }
            this.categoryComboBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void onEditTodo() {
        int row = this.todoTable.getSelectedRow();
        if (row == -1) {
            return;
        }
        this.todoTable.getSelectionModel().setSelectionInterval(row, row);
        TableSorter tm = (TableSorter)this.todoTable.getModel();
        int k = tm.getMappedIndex(row);
        if (k == 0) {
            return;
        }
        Object o = this.theTodoList.toArray()[k - 1];
        if (o instanceof Appointment) {
            Date d = (Date)tm.getValueAt(row, 0);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(d);
            AppointmentListView ag = new AppointmentListView(cal.get(1), cal.get(2), cal.get(5));
            Appointment ap = (Appointment)o;
            ag.showView();
            ag.showApp(ap.getKey());
        } else {
            if (o instanceof Project) {
                try {
                    new ProjectView((Project)o, ProjectView.Action.CHANGE, null).showView();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
            if (o instanceof Task) {
                try {
                    new TaskView((Task)o, TaskView.Action.CHANGE, null).showView();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
            if (o instanceof Subtask) {
                int taskid = ((Subtask)o).getTask();
                try {
                    Task t = TaskModel.getReference().getTask(taskid);
                    TaskView tskg = new TaskView(t, TaskView.Action.CHANGE, null);
                    tskg.setVisible(true);
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
        }
    }

    @Override
    public void prefsChanged() {
        this.user_colors = Prefs.getBoolPref(PrefName.UCS_ONTODO);
        this.refresh();
    }

    @Override
    public void print() {
        try {
            TablePrinter.printTable(this.todoTable);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void refresh() {
        this.theTodoList = new ArrayList();
        this.theTodoList.addAll(AppointmentModel.getReference().get_todos());
        TableSorter tm = (TableSorter)this.todoTable.getModel();
        tm.addMouseListenerToHeaderInTable(this.todoTable);
        tm.setRowCount(0);
        GregorianCalendar gc = new GregorianCalendar();
        gc.set(11, 23);
        gc.set(12, 59);
        Date d = gc.getTime();
        Object[] tod = new Object[6];
        tod[0] = d;
        tod[1] = Resource.getResourceString("======_Today_======");
        tod[2] = "Today is";
        tod[3] = "pink";
        tod[4] = null;
        tm.addRow(tod);
        tm.tableChanged(new TableModelEvent(tm));
        Iterator<KeyedEntity<?>> tdit = this.theTodoList.iterator();
        int totalCount = 0;
        while (tdit.hasNext()) {
            Appointment r = (Appointment)tdit.next();
            try {
                Date nt = r.getNextTodo();
                if (nt == null) {
                    nt = r.getDate();
                }
                String tx = AppointmentTextFormat.format(r, nt);
                Object[] ro = new Object[]{nt, tx, r.getCategory(), r.getColor() == null ? "black" : r.getColor(), new Integer(r.getKey()), r.getPriority()};
                tm.addRow(ro);
                tm.tableChanged(new TableModelEvent(tm));
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
            this.getTotalLabel().setText(++totalCount + " items");
        }
        String show_abb = Prefs.getPref(PrefName.TASK_SHOW_ABBREV);
        if (Prefs.getBoolPref(PrefName.CAL_SHOW_TASKS)) {
            Object[] ro;
            String abb;
            try {
                Collection pjs = TaskModel.getReference().getProjects();
                for (Project pj : pjs) {
                    if (pj.getDueDate() == null || pj.getStatus().equals(Resource.getResourceString("CLOSED")) || !CategoryModel.getReference().isShown(pj.getCategory())) continue;
                    abb = "";
                    if (show_abb.equals("true")) {
                        abb = "PR" + pj.getKey() + " ";
                    }
                    String todostring = abb + pj.getText();
                    ro = new Object[]{pj.getDueDate(), todostring, pj.getCategory(), "navy", null, null};
                    tm.addRow(ro);
                    this.theTodoList.add((KeyedEntity<?>)pj);
                    tm.tableChanged(new TableModelEvent(tm));
                }
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
                return;
            }
            Vector mrs = TaskModel.getReference().get_tasks();
            for (int i = 0; i < mrs.size(); ++i) {
                Task mr = (Task)mrs.elementAt(i);
                if (mr.getDueDate() == null) continue;
                try {
                    abb = "";
                    if (show_abb.equals("true")) {
                        abb = "BT" + mr.getKey() + " ";
                    }
                    String btstring = abb + mr.getText();
                    ro = new Object[]{mr.getDueDate(), btstring, mr.getCategory(), "navy", null, mr.getPriority()};
                    tm.addRow(ro);
                    this.theTodoList.add((KeyedEntity<?>)mr);
                    tm.tableChanged(new TableModelEvent(tm));
                    continue;
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                    return;
                }
            }
        }
        if (Prefs.getBoolPref(PrefName.CAL_SHOW_SUBTASKS)) {
            try {
                Collection sts = TaskModel.getReference().getSubTasks();
                for (Subtask st : sts) {
                    if (st.getDueDate() == null || st.getCloseDate() != null) continue;
                    Task task = TaskModel.getReference().getTask(st.getTask().intValue());
                    String cat = task.getCategory();
                    if (!CategoryModel.getReference().isShown(cat)) continue;
                    String abb = "";
                    if (show_abb.equals("true")) {
                        abb = "ST" + st.getKey() + " ";
                    }
                    String btstring = abb + st.getText();
                    Object[] ro = new Object[]{st.getDueDate(), btstring, cat, "navy", null, null};
                    tm.addRow(ro);
                    this.theTodoList.add((KeyedEntity<?>)st);
                    tm.tableChanged(new TableModelEvent(tm));
                }
            }
            catch (Exception e) {
                return;
            }
        }
        tm.sortByColumn(0);
    }

    public void update(Model.ChangeEvent event) {
        if (event.getModel() instanceof CategoryModel) {
            this.loadCategories();
        }
        this.refresh();
    }

    private static class ToggleButtonIcon
    implements Icon {
        private Color color = Color.BLACK;
        private final int height = 10;
        private final int width = 30;

        public ToggleButtonIcon(Color col) {
            this.color = col;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.BLACK);
            g2.drawRect(x, y, 30, 10);
            g2.setColor(this.color);
            g2.fillRect(x, y, 30, 10);
        }
    }

    class TodoTableCellRenderer
    extends DefaultTableCellRenderer {
        private TableCellRenderer originalRenderer = null;
        private static final long serialVersionUID = 1L;

        TodoTableCellRenderer(TableCellRenderer orig) {
            this.originalRenderer = orig;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.originalRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!TodoView.this.user_colors) {
                return c;
            }
            DateFormat sdf = DateFormat.getDateInstance();
            JLabel theTableCellComponent = (JLabel)c;
            if (isSelected) {
                theTableCellComponent.setForeground(Color.BLACK);
                theTableCellComponent.setBackground(Color.ORANGE);
            } else {
                Theme t = Theme.getCurrentTheme();
                String color = table.getModel().getValueAt(row, 3).toString();
                if (color.equals("red")) {
                    theTableCellComponent.setForeground(new Color(t.getTextColor1()));
                } else if (color.equals("blue")) {
                    theTableCellComponent.setForeground(new Color(t.getTextColor2()));
                } else if (color.equals("green")) {
                    theTableCellComponent.setForeground(new Color(t.getTextColor3()));
                } else if (color.equals("black")) {
                    theTableCellComponent.setForeground(new Color(t.getTextColor4()));
                } else if (color.equals("white")) {
                    theTableCellComponent.setForeground(new Color(t.getTextColor5()));
                } else if (color.equals("navy")) {
                    theTableCellComponent.setForeground(new Color(t.getTaskTextColor()));
                } else if (color.equals("brick")) {
                    theTableCellComponent.setForeground(new Color(t.getBirthdayTextColor()));
                } else if (color.equals("purple")) {
                    theTableCellComponent.setForeground(new Color(t.getHolidayTextColor()));
                } else if (color.equals("pink") && column > 1) {
                    theTableCellComponent.setForeground(new Color(t.getTodayBg()));
                } else {
                    theTableCellComponent.setForeground(Color.BLACK);
                }
                if (table.getModel().getValueAt(row, 1).equals(Resource.getResourceString("======_Today_======"))) {
                    theTableCellComponent.setBackground(new Color(t.getTodayBg()));
                } else {
                    theTableCellComponent.setBackground(new Color(t.getWeekdayBg()));
                }
            }
            if (column == 0) {
                theTableCellComponent.setText(sdf.format(value));
            } else if (column == 1) {
                theTableCellComponent.setToolTipText(theTableCellComponent.getText());
            }
            return theTableCellComponent;
        }
    }
}

