/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.calendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.PrintHelper;
import net.sf.borg.common.Resource;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.Day;
import net.sf.borg.model.Model;
import net.sf.borg.model.Theme;
import net.sf.borg.model.entity.CalendarEntity;
import net.sf.borg.model.entity.LabelEntity;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.NavPanel;
import net.sf.borg.ui.calendar.ApptBoxPanel;
import net.sf.borg.ui.calendar.ButtonBox;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class YearPanel
extends DockableView
implements Printable,
MultiView.CalendarModule {
    private static final long serialVersionUID = 1L;
    private NavPanel nav = null;
    private YearViewSubPanel yearPanel = null;
    private boolean isInitialized = false;

    @Override
    public void goTo(Calendar cal) {
        if (this.isInitialized) {
            this.yearPanel.goTo(cal);
            this.nav.setLabel(this.yearPanel.getNavLabel());
        }
    }

    @Override
    public int print(Graphics arg0, PageFormat arg1, int arg2) throws PrinterException {
        return this.yearPanel.print(arg0, arg1, arg2);
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("Year_View");
    }

    @Override
    public JPanel getComponent() {
        if (!this.isInitialized) {
            this.yearPanel = new YearViewSubPanel();
            this.nav = new NavPanel(this.yearPanel);
            this.setLayout(new GridBagLayout());
            this.add((Component)this.nav, GridBagConstraintsFactory.create(0, 0, 1));
            this.add((Component)this.yearPanel, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0));
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/year.jpg")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.YEAR);
            }
        });
    }

    @Override
    public void print() {
        try {
            PrintHelper.printPrintable(this);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.YEAR;
    }

    @Override
    public String getFrameTitle() {
        return this.getModuleName();
    }

    @Override
    public void refresh() {
    }

    public void update(Model.ChangeEvent event) {
    }

    private class YearViewSubPanel
    extends ApptBoxPanel
    implements Printable,
    NavPanel.Navigator,
    Model.Listener,
    Prefs.Listener,
    MouseWheelListener {
        private static final long serialVersionUID = 1L;
        private final int numBoxes = 444;
        Color[] colors = new Color[444];
        private int colwidth;
        private int gridtop;
        private int lastDrawDate = -1;
        boolean needLoad = true;
        private int rowheight;
        private int year_;

        public YearViewSubPanel() {
            Prefs.addListener(this);
            this.addMouseWheelListener(this);
            AppointmentModel.getReference().addListener((Model.Listener)this);
            this.goTo(new GregorianCalendar());
        }

        public void clearData() {
            this.clearBoxes();
            this.needLoad = true;
            this.setToolTipText(null);
        }

        private int drawIt(Graphics g, double width, double height, double pageWidth, double pageHeight, double pagex, double pagey, Font sm_font) {
            int row;
            Theme t = Theme.getCurrentTheme();
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setFont(sm_font);
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(0, 0, (int)width, (int)height);
            g2.setColor(new Color(t.getDefaultFg()));
            int fontHeight = g2.getFontMetrics().getHeight();
            int fontDesent = g2.getFontMetrics().getDescent();
            g2.translate(pagex, pagey);
            Shape s = g2.getClip();
            GregorianCalendar now = new GregorianCalendar();
            int tmon = now.get(2);
            int tyear = now.get(1);
            int tdate = now.get(5);
            if (this.lastDrawDate != tdate) {
                this.needLoad = true;
            }
            this.lastDrawDate = tdate;
            GregorianCalendar cal = new GregorianCalendar(this.year_, 0, 1);
            cal.setFirstDayOfWeek(Prefs.getIntPref(PrefName.FIRSTDOW));
            int caltop = 0;
            this.gridtop = caltop + fontHeight + fontDesent;
            int monthwidth = g2.getFontMetrics().stringWidth("12345678901");
            this.rowheight = ((int)pageHeight - this.gridtop) / 12;
            this.colwidth = (int)(pageWidth - (double)monthwidth) / 37;
            int calright = monthwidth + this.colwidth * 37;
            int calbot = this.gridtop + 12 * this.rowheight;
            this.setDragBounds(0, 0, 0, 0);
            this.setResizeBounds(0, 0);
            g2.setColor(new Color(t.getDefaultBg()));
            g2.fillRect(0, caltop, calright, this.gridtop - caltop);
            g2.setColor(new Color(t.getDefaultFg()));
            SimpleDateFormat dfm = new SimpleDateFormat("MMMM");
            SimpleDateFormat dfw = new SimpleDateFormat("E");
            cal.add(7, cal.getFirstDayOfWeek() - cal.get(7));
            for (int col = 0; col < 37; ++col) {
                int colleft = monthwidth + col * this.colwidth;
                String dayofweek = dfw.format(cal.getTime());
                dayofweek = dayofweek.substring(0, 1);
                int swidth = g2.getFontMetrics().stringWidth(dayofweek);
                g2.drawString(dayofweek, colleft + (this.colwidth - swidth) / 2, caltop + fontHeight);
                cal.add(7, 1);
            }
            int mon = 0;
            for (row = 0; row < 12; ++row) {
                cal.set(this.year_, mon, 1);
                int fdow = cal.get(7) - cal.getFirstDayOfWeek();
                if (fdow == -1) {
                    fdow = 6;
                }
                cal.add(5, -1 * fdow);
                for (int col = 0; col < 37; ++col) {
                    int numbox = row * 37 + col;
                    int rowtop = row * this.rowheight + this.gridtop;
                    int colleft = monthwidth + col * this.colwidth;
                    int dow = cal.get(7);
                    g2.clipRect(colleft, rowtop, this.colwidth, this.rowheight);
                    if (this.needLoad) {
                        try {
                            if (cal.get(2) != mon) {
                                this.colors[numbox] = new Color(t.getDefaultBg());
                            } else {
                                if (cal.get(5) == 1) {
                                    this.boxes.add(new ButtonBox(cal.getTime(), dfm.format(cal.getTime()), null, new Rectangle(2, rowtop, monthwidth - 4, fontHeight), new Rectangle(0, rowtop, monthwidth, this.rowheight)){

                                        @Override
                                        public void onClick() {
                                            MultiView.getMainView().setView(MultiView.ViewType.MONTH);
                                            GregorianCalendar gc = new GregorianCalendar();
                                            gc.setTime(this.getDate());
                                            MultiView.getMainView().goTo(gc);
                                        }
                                    });
                                }
                                Day dayInfo = Day.getDay((int)cal.get(1), (int)cal.get(2), (int)cal.get(5));
                                Color c = new Color(t.getWeekdayBg());
                                if (dayInfo != null) {
                                    c = tmon == cal.get(2) && tyear == this.year_ && tdate == cal.get(5) ? new Color(t.getTodayBg()) : (dayInfo.getHoliday() != 0 ? new Color(t.getHolidayBg()) : (dayInfo.getVacation() == 1 ? new Color(Theme.getCurrentTheme().getVacationBg()) : (dayInfo.getVacation() == 2 ? new Color(t.getHalfdayBg()) : (dow == 1 || dow == 7 ? new Color(t.getWeekendBg()) : new Color(t.getWeekdayBg())))));
                                }
                                this.colors[numbox] = c;
                                g2.setFont(sm_font);
                                int smfontHeight = g2.getFontMetrics().getHeight();
                                int notey = rowtop + smfontHeight;
                                if (dayInfo != null) {
                                    for (CalendarEntity entity : dayInfo.getItems()) {
                                        LabelEntity l = new LabelEntity();
                                        l.setColor(entity.getColor());
                                        l.setDate(entity.getDate());
                                        l.setText(entity.getText());
                                        if (this.addNoteBox(cal.getTime(), (CalendarEntity)l, new Rectangle(colleft + 2, notey, this.colwidth - 4, smfontHeight), new Rectangle(colleft, rowtop, this.colwidth, this.rowheight)) == null) continue;
                                        notey += smfontHeight;
                                    }
                                }
                                String datetext = Integer.toString(cal.get(5));
                                this.boxes.add(new ButtonBox(cal.getTime(), datetext, null, new Rectangle(colleft + 2, rowtop, this.colwidth - 4, fontHeight), new Rectangle(colleft, rowtop, this.colwidth, this.rowheight), c){

                                    @Override
                                    public void onClick() {
                                        MultiView.getMainView().setView(MultiView.ViewType.DAY);
                                        GregorianCalendar gc = new GregorianCalendar();
                                        gc.setTime(this.getDate());
                                        MultiView.getMainView().goTo(gc);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    g2.setClip(s);
                    g2.setColor(this.colors[numbox]);
                    g2.fillRect(colleft, rowtop, this.colwidth, this.rowheight);
                    cal.add(5, 1);
                }
                ++mon;
            }
            this.needLoad = false;
            this.drawBoxes(g2);
            g2.setClip(s);
            g2.setColor(new Color(t.getDefaultFg()));
            g2.drawLine(0, caltop, calright, caltop);
            g2.drawLine(0, caltop, 0, calbot);
            for (row = 0; row <= 12; ++row) {
                int rowtop = row * this.rowheight + this.gridtop;
                g2.drawLine(0, rowtop, calright, rowtop);
            }
            for (int col = 0; col <= 37; ++col) {
                int colleft = monthwidth + col * this.colwidth;
                g2.drawLine(colleft, caltop, colleft, calbot);
            }
            return 0;
        }

        @Override
        public Date getDateForCoord(double x, double y) {
            int col = (int)x / this.colwidth;
            int row = ((int)y - this.gridtop) / this.rowheight;
            GregorianCalendar cal = new GregorianCalendar(this.year_, row + 1, 1);
            cal.setFirstDayOfWeek(Prefs.getIntPref(PrefName.FIRSTDOW));
            int fdow = cal.get(7) - cal.getFirstDayOfWeek();
            cal.add(5, -1 * fdow);
            cal.add(5, row * 7 + col);
            return cal.getTime();
        }

        @Override
        public String getNavLabel() {
            SimpleDateFormat df = new SimpleDateFormat("yyyy");
            GregorianCalendar cal = new GregorianCalendar(this.year_, 0, 1);
            return df.format(cal.getTime());
        }

        @Override
        public void goTo(Calendar cal) {
            this.year_ = cal.get(1);
            this.clearData();
            this.repaint();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getWheelRotation() > 0) {
                this.next();
                YearPanel.this.nav.setLabel(this.getNavLabel());
            } else if (e.getWheelRotation() < 0) {
                this.prev();
                YearPanel.this.nav.setLabel(this.getNavLabel());
            }
        }

        @Override
        public void next() {
            ++this.year_;
            this.clearData();
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            try {
                Font sm_font = Font.decode(Prefs.getPref(PrefName.YEARVIEWFONT));
                this.drawIt(g, this.getWidth(), this.getHeight(), this.getWidth() - 20, this.getHeight() - 20, 10.0, 10.0, sm_font);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void prefsChanged() {
            this.clearData();
            this.repaint();
        }

        @Override
        public void prev() {
            --this.year_;
            this.clearData();
            this.repaint();
        }

        @Override
        public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
            if (pageIndex > 0) {
                return 1;
            }
            Font sm_font = Font.decode(Prefs.getPref(PrefName.PRINTFONT));
            this.clearData();
            int ret = this.drawIt(g, pageFormat.getWidth(), pageFormat.getHeight(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight(), pageFormat.getImageableX(), pageFormat.getImageableY(), sm_font);
            this.refresh();
            return ret;
        }

        @Override
        public void refresh() {
            this.clearData();
            this.repaint();
        }

        public void update(Model.ChangeEvent event) {
            this.refresh();
        }

        @Override
        public void today() {
            GregorianCalendar cal = new GregorianCalendar();
            this.year_ = cal.get(1);
            this.clearData();
            this.repaint();
        }
    }
}

