/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.memo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.MemoModel;
import net.sf.borg.model.Model;
import net.sf.borg.model.entity.Memo;
import net.sf.borg.ui.DockableView;
import net.sf.borg.ui.MultiView;
import net.sf.borg.ui.SunTrayIconProxy;
import net.sf.borg.ui.util.GridBagConstraintsFactory;
import net.sf.borg.ui.util.HTMLLimitDocument;
import net.sf.borg.ui.util.HTMLTextPane;
import net.sf.borg.ui.util.InputDialog;
import net.sf.borg.ui.util.PasswordHelper;
import net.sf.borg.ui.util.PopupMenuHelper;
import net.sf.borg.ui.util.StripedTable;
import net.sf.borg.ui.util.TableSorter;

public class MemoPanel
extends DockableView
implements ListSelectionListener,
MultiView.Module {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat memoDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");
    private JLabel dateLabel = new JLabel();
    private int editedMemoIndex = -1;
    private boolean isMemoEdited = false;
    private StripedTable memoListTable = null;
    private HTMLTextPane memoText = null;
    private JButton saveButton = null;
    private JButton decryptButton = null;
    private boolean isInitialized = false;
    private JCheckBox encryptBox = null;
    private ActionListener renameAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = MemoPanel.this.getSelectedMemoName();
            if (name == null) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_Memo_Warning"));
                return;
            }
            String newname = InputDialog.show(Resource.getResourceString("Enter_Memo_Name"), 50);
            if (newname == null || newname.isEmpty() || newname.equals(name)) {
                return;
            }
            if (newname.length() > 50) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("max_length", new String[]{Resource.getResourceString("Memo_Name"), "50"}));
                return;
            }
            try {
                Memo existing = MemoModel.getReference().getMemo(newname);
                if (existing != null) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("Existing_Memo"));
                    return;
                }
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
            }
            try {
                Memo m = MemoModel.getReference().getMemo(name);
                m.setMemoName(newname);
                MemoModel.getReference().saveMemo(m);
                MemoModel.getReference().delete(name, false);
                MemoPanel.this.loadMemosFromModel();
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
            }
        }
    };
    private String searchString = null;

    private void deleteMemo() {
        String name = this.getSelectedMemoName();
        if (name == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_Memo_Warning"));
            return;
        }
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_Delete_") + "?", Resource.getResourceString("Confirm_Delete"), 2, 3);
        if (ret != 0) {
            return;
        }
        try {
            MemoModel.getReference().delete(name, false);
            this.isMemoEdited = false;
            this.loadMemosFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private String getSelectedMemoName() {
        int row = this.memoListTable.getSelectedRow();
        if (row == -1) {
            return null;
        }
        TableSorter tm = (TableSorter)this.memoListTable.getModel();
        String memoName = (String)tm.getValueAt(row, 0);
        return memoName;
    }

    private void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JSplitPane memoSplitPane = new JSplitPane();
        memoSplitPane.setResizeWeight(0.2);
        JScrollPane memoListScroll = new JScrollPane();
        memoListScroll.setHorizontalScrollBarPolicy(31);
        memoListScroll.setPreferredSize(new Dimension(100, 423));
        this.memoListTable = new StripedTable();
        this.memoListTable.setSelectionMode(0);
        this.memoListTable.setShowGrid(true);
        memoListScroll.setViewportView(this.memoListTable);
        this.memoListTable.setModel(new TableSorter(new String[]{Resource.getResourceString("Memo_Name")}, new Class[]{String.class}));
        ListSelectionModel rowSM = this.memoListTable.getSelectionModel();
        rowSM.addListSelectionListener(this);
        memoSplitPane.setLeftComponent(memoListScroll);
        JScrollPane memoTextScroll = new JScrollPane();
        memoTextScroll.setPreferredSize(new Dimension(400, 400));
        HTMLLimitDocument newLimitDocument = new HTMLLimitDocument();
        newLimitDocument.setMaxLength(Prefs.getIntPref(PrefName.MAX_TEXT_SIZE));
        this.memoText = new HTMLTextPane((Document)newLimitDocument);
        this.memoText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MemoPanel.this.isMemoEdited = true;
                MemoPanel.this.editedMemoIndex = MemoPanel.this.memoListTable.getSelectedRow();
                MemoPanel.this.saveButton.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                MemoPanel.this.isMemoEdited = true;
                MemoPanel.this.editedMemoIndex = MemoPanel.this.memoListTable.getSelectedRow();
                MemoPanel.this.saveButton.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                MemoPanel.this.isMemoEdited = true;
                MemoPanel.this.editedMemoIndex = MemoPanel.this.memoListTable.getSelectedRow();
                MemoPanel.this.saveButton.setEnabled(true);
            }
        });
        this.memoText.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.isControlDown() && arg0.getKeyCode() == 70) {
                    MemoPanel.this.doFind();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        memoTextScroll.setViewportView(this.memoText);
        memoSplitPane.setRightComponent(memoTextScroll);
        this.add((Component)memoSplitPane, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        GridBagConstraints gridBagConstraints1 = GridBagConstraintsFactory.create(0, 0, 2);
        gridBagConstraints1.anchor = 17;
        JPanel dateAndPrivatePanel = new JPanel();
        dateAndPrivatePanel.setLayout(new GridBagLayout());
        dateAndPrivatePanel.add((Component)this.dateLabel, gridBagConstraints1);
        this.add((Component)dateAndPrivatePanel, GridBagConstraintsFactory.create(0, 1, 2));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton newButton = new JButton();
        newButton.setText(Resource.getResourceString("New_Memo"));
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoPanel.this.newMemo();
            }
        });
        buttonPanel.add((Component)newButton, null);
        this.saveButton = new JButton();
        this.saveButton.setText(Resource.getResourceString("Save_Memo"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoPanel.this.saveMemo();
            }
        });
        buttonPanel.add((Component)this.saveButton, null);
        JButton deleteButton = new JButton();
        deleteButton.setText(Resource.getResourceString("Delete_Memo"));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemoPanel.this.deleteMemo();
            }
        });
        buttonPanel.add((Component)deleteButton, null);
        JButton exportButton = new JButton();
        exportButton.setText(Resource.getResourceString("export"));
        exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name = MemoPanel.this.getSelectedMemoName();
                if (name == null) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_Memo_Warning"));
                    return;
                }
                if (MemoPanel.this.decryptButton.isEnabled()) {
                    Errmsg.getErrorHandler().notice(Resource.getResourceString("Export_Memo_Decrypt"));
                    return;
                }
                StringBuffer sb = new StringBuffer();
                String s = MemoPanel.this.memoText.getPlainText();
                for (int i = 0; i < s.length(); ++i) {
                    if (s.charAt(i) == '\n') {
                        sb.append('\r');
                    }
                    sb.append(s.charAt(i));
                }
                byte[] buf2 = sb.toString().getBytes();
                ByteArrayInputStream istr = new ByteArrayInputStream(buf2);
                try {
                    MemoPanel.fileSave(".", istr, "");
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                }
            }
        });
        buttonPanel.add((Component)exportButton, null);
        this.decryptButton = new JButton();
        this.decryptButton.setText(Resource.getResourceString("decrypt"));
        this.decryptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Memo m = MemoModel.getReference().getMemo(MemoPanel.this.getSelectedMemoName());
                    String pw = PasswordHelper.getReference().getPassword();
                    if (pw == null) {
                        return;
                    }
                    m.decrypt(pw);
                    MemoPanel.this.memoText.setText(m.getMemoText());
                    MemoPanel.this.memoText.setEditable(true);
                    MemoPanel.this.decryptButton.setEnabled(false);
                    MemoPanel.this.saveButton.setEnabled(false);
                    MemoPanel.this.clearEditFlag();
                    MemoPanel.this.memoText.setCaretPosition(0);
                }
                catch (Exception e1) {
                    Errmsg.getErrorHandler().errmsg(e1);
                }
            }
        });
        buttonPanel.add((Component)this.decryptButton, null);
        this.encryptBox = new JCheckBox();
        this.encryptBox.setText(Resource.getResourceString("EncryptOnSave"));
        buttonPanel.add((Component)this.encryptBox, null);
        this.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 2, 1));
    }

    private static void fileSave(String startDirectory, InputStream istr, String defaultFilename) throws Exception {
        int b;
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(startDirectory));
        chooser.setDialogTitle(Resource.getResourceString("Save"));
        chooser.setFileSelectionMode(0);
        int returnVal = chooser.showSaveDialog(null);
        if (returnVal != 0) {
            return;
        }
        String s = chooser.getSelectedFile().getAbsolutePath();
        FileOutputStream ostr = new FileOutputStream(s);
        while ((b = istr.read()) != -1) {
            ostr.write(b);
        }
        istr.close();
        ostr.close();
    }

    private void loadMemosFromModel() throws Exception {
        this.memoListTable.clearSelection();
        TableSorter tm = (TableSorter)this.memoListTable.getModel();
        tm.setRowCount(0);
        Collection names = MemoModel.getReference().getNames();
        Iterator it = names.iterator();
        while (it.hasNext()) {
            tm.addRow(new Object[]{it.next()});
        }
    }

    private void newMemo() {
        int ret;
        if (this.isMemoEdited && (ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Edited_Memo"), Resource.getResourceString("Discard_Text?"), 2, 3)) != 0) {
            return;
        }
        String name = InputDialog.show(Resource.getResourceString("Enter_Memo_Name"), 50);
        if (name == null || name.trim().isEmpty()) {
            return;
        }
        try {
            Memo existing = MemoModel.getReference().getMemo(name);
            if (existing != null) {
                Errmsg.getErrorHandler().notice(Resource.getResourceString("Existing_Memo"));
                return;
            }
        }
        catch (Exception e1) {
            Errmsg.getErrorHandler().errmsg(e1);
        }
        Memo m = new Memo();
        m.setMemoName(name);
        try {
            MemoModel.getReference().saveMemo(m);
            this.isMemoEdited = false;
            this.loadMemosFromModel();
            this.selectMemo(name);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public void refresh() {
        if (this.isMemoEdited) {
            return;
        }
        try {
            this.loadMemosFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    private void saveMemo() {
        String name = this.getSelectedMemoName();
        if (name == null) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Select_Memo_Warning"));
            return;
        }
        try {
            Memo m = MemoModel.getReference().getMemo(name);
            m.setMemoText(this.memoText.getPlainText());
            m.setEncrypted(false);
            if (this.encryptBox.isSelected()) {
                String pw = PasswordHelper.getReference().getPassword();
                if (pw == null) {
                    return;
                }
                m.encrypt(pw);
            }
            MemoModel.getReference().saveMemo(m);
            this.isMemoEdited = false;
            this.loadMemosFromModel();
            this.selectMemo(name);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    public void selectMemo(String memoName) {
        TableSorter tm = (TableSorter)this.memoListTable.getModel();
        int rows = tm.getRowCount();
        for (int i = 0; i < rows; ++i) {
            String name = (String)tm.getValueAt(i, 0);
            if (!memoName.equals(name)) continue;
            this.memoListTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String memoName;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.isMemoEdited) {
            if (this.editedMemoIndex == this.memoListTable.getSelectedRow()) {
                return;
            }
            int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Edited_Memo"), Resource.getResourceString("Discard_Text?"), 2, 3);
            if (ret != 0) {
                this.memoListTable.getSelectionModel().setSelectionInterval(this.editedMemoIndex, this.editedMemoIndex);
                return;
            }
        }
        if ((memoName = this.getSelectedMemoName()) == null) {
            this.memoText.setText("");
            this.memoText.setEditable(false);
            this.dateLabel.setText("");
            this.encryptBox.setSelected(false);
            this.decryptButton.setEnabled(false);
        } else {
            try {
                Memo m = MemoModel.getReference().getMemo(memoName);
                String text = m.getMemoText();
                String datetext = Resource.getResourceString("created") + ": ";
                datetext = m.getCreated() != null ? datetext + memoDateFormat.format(m.getCreated()) : datetext + Resource.getResourceString("unknown");
                datetext = datetext + "           " + Resource.getResourceString("updated") + ": ";
                datetext = m.getUpdated() != null ? datetext + memoDateFormat.format(m.getUpdated()) : datetext + Resource.getResourceString("unknown");
                this.dateLabel.setText(datetext);
                this.encryptBox.setSelected(m.isEncrypted());
                if (m.isEncrypted()) {
                    this.memoText.setText(Resource.getResourceString("EncryptedItem"));
                    this.memoText.setEditable(false);
                    this.decryptButton.setEnabled(true);
                } else {
                    this.memoText.setEditable(true);
                    this.memoText.setText(text);
                    this.decryptButton.setEnabled(false);
                }
                this.memoText.setCaretPosition(0);
            }
            catch (Exception e1) {
                Errmsg.getErrorHandler().errmsg(e1);
                return;
            }
        }
        this.isMemoEdited = false;
        this.saveButton.setEnabled(false);
    }

    @Override
    public JComponent getComponent() {
        if (!this.isInitialized) {
            this.initializeComponents();
            this.memoText.setEditable(false);
            this.saveButton.setEnabled(false);
            this.decryptButton.setEnabled(false);
            new PopupMenuHelper(this.memoListTable, new PopupMenuHelper.Entry[]{new PopupMenuHelper.Entry(this.renameAction, "Rename")});
            this.refresh();
            MemoModel.getReference().addListener((Model.Listener)this);
            this.isInitialized = true;
        }
        return this;
    }

    @Override
    public String getModuleName() {
        return Resource.getResourceString("Memos");
    }

    @Override
    public void initialize(MultiView parent) {
        final MultiView par = parent;
        parent.addToolBarItem(new ImageIcon(this.getClass().getResource("/resource/Edit16.gif")), this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.MEMO);
            }
        });
        SunTrayIconProxy.addAction(this.getModuleName(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                par.setView(MultiView.ViewType.MEMO);
            }
        });
    }

    @Override
    public void print() {
        try {
            String selectedMemo = this.getSelectedMemoName();
            if (selectedMemo == null) {
                return;
            }
            this.memoText.print(new MessageFormat(selectedMemo), new MessageFormat("{0}"));
        }
        catch (PrinterException e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    private void clearEditFlag() {
        this.isMemoEdited = false;
    }

    @Override
    public MultiView.ViewType getViewType() {
        return MultiView.ViewType.MEMO;
    }

    @Override
    public boolean canClose() {
        int ret;
        if (this.isMemoEdited && (ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Edited_Memo"), Resource.getResourceString("Discard_Text?"), 2, 3)) != 0) {
            return false;
        }
        try {
            this.isMemoEdited = false;
            this.loadMemosFromModel();
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
        return true;
    }

    private void doFind() {
        int caretIndex = this.memoText.getCaretPosition();
        this.searchString = JOptionPane.showInputDialog(null, Resource.getResourceString("Search_For"), this.searchString);
        if (this.searchString != null) {
            int foundIndex = this.memoText.getPlainText().indexOf(this.searchString, caretIndex);
            if (foundIndex != -1) {
                this.memoText.select(foundIndex, foundIndex + this.searchString.length());
            } else {
                JOptionPane.showMessageDialog(null, Resource.getResourceString("Not_Found_End"));
                this.memoText.setCaretPosition(0);
            }
        }
    }

    @Override
    public String getFrameTitle() {
        return this.getModuleName();
    }

    @Override
    public void cleanUp() {
        this.memoListTable.clearSelection();
    }
}

