/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.HelpLauncher;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class DatabaseOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = 7695315940556870216L;
    private JTextField dbDirText;
    private JTextField dbHostText;
    private JTextField dbNameText;
    private JTextField dbPortText;
    private ButtonGroup dbTypeGroup;
    private JPanel dbTypePanel = null;
    private JTextField dbUserText;
    private JRadioButton hsqldbButton;
    private JRadioButton h2Button;
    private JTextField hsqldbdir = new JTextField();
    private JTextField h2dir = new JTextField();
    private JPanel hsqldbPanel;
    private JPanel h2Panel;
    private JRadioButton jdbcButton = null;
    private JPanel jdbcPanel = null;
    private JTextField jdbcText = null;
    private JPasswordField jPasswordField1;
    private JRadioButton MySQLButton = null;
    private JPanel mysqlPanel;

    public DatabaseOptionsPanel() {
        this.dbNameText = new JTextField();
        this.dbHostText = new JTextField();
        this.dbPortText = new JTextField();
        this.dbUserText = new JTextField();
        this.jPasswordField1 = new JPasswordField();
        this.dbDirText = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbcm = GridBagConstraintsFactory.create(0, 1, 1, 1.0, 1.0);
        gbcm.gridwidth = 0;
        this.add((Component)this.getMysqlPanel(), gbcm);
        this.add((Component)this.getDbTypePanel(), GridBagConstraintsFactory.create(0, 0, 1));
        GridBagConstraints gridBagConstraints5 = GridBagConstraintsFactory.create(0, 7);
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 10;
        JButton chgdb = new JButton();
        this.add((Component)chgdb, gridBagConstraints5);
        chgdb.setForeground(new Color(255, 0, 51));
        chgdb.setIcon(new ImageIcon(this.getClass().getResource("/resource/Refresh16.gif")));
        ResourceHelper.setText(chgdb, "Apply_DB_Change");
        chgdb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DatabaseOptionsPanel.this.chgdbActionPerformed();
            }
        });
        JButton help = new JButton();
        GridBagConstraints gridBagConstraintsh = GridBagConstraintsFactory.create(1, 7);
        gridBagConstraintsh.weightx = 1.0;
        gridBagConstraintsh.anchor = 10;
        this.add((Component)help, gridBagConstraintsh);
        help.setForeground(new Color(255, 0, 51));
        help.setIcon(new ImageIcon(this.getClass().getResource("/resource/Help16.gif")));
        ResourceHelper.setText(help, "Help");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    HelpLauncher.launchHelp();
                }
                catch (Exception e) {
                    Errmsg.getErrorHandler().errmsg(e);
                }
            }
        });
        GridBagConstraints gridBagConstraints6h = GridBagConstraintsFactory.create(0, 4, 1, 1.0, 1.0);
        gridBagConstraints6h.gridwidth = 0;
        this.add((Component)this.getHSQLDBPanel(), gridBagConstraints6h);
        GridBagConstraints gridBagConstraints7h = GridBagConstraintsFactory.create(0, 5, 1, 1.0, 1.0);
        gridBagConstraints7h.gridwidth = 0;
        this.add((Component)this.getJdbcPanel(), gridBagConstraints7h);
        GridBagConstraints gridBagConstraints8h = GridBagConstraintsFactory.create(0, 6, 1, 1.0, 1.0);
        gridBagConstraints8h.gridwidth = 0;
        this.add((Component)this.getH2Panel(), gridBagConstraints8h);
    }

    @Override
    public void applyChanges() {
    }

    private void chgdbActionPerformed() {
        int ret = JOptionPane.showConfirmDialog(null, Resource.getResourceString("Really_change_the_database?"), Resource.getResourceString("Confirm_DB_Change"), 0);
        if (ret == 0) {
            String hh = this.hsqldbdir.getText();
            Prefs.putPref(PrefName.HSQLDBDIR, hh);
            String h2 = this.h2dir.getText();
            Prefs.putPref(PrefName.H2DIR, h2);
            if (this.MySQLButton.isSelected()) {
                Prefs.putPref(PrefName.DBTYPE, "mysql");
            } else if (this.hsqldbButton.isSelected()) {
                Prefs.putPref(PrefName.DBTYPE, "hsqldb");
            } else if (this.h2Button.isSelected()) {
                Prefs.putPref(PrefName.DBTYPE, "h2");
            } else {
                Prefs.putPref(PrefName.DBTYPE, "jdbc");
            }
            Prefs.putPref(PrefName.DBNAME, this.dbNameText.getText());
            Prefs.putPref(PrefName.DBPORT, this.dbPortText.getText());
            Prefs.putPref(PrefName.DBHOST, this.dbHostText.getText());
            Prefs.putPref(PrefName.DBUSER, this.dbUserText.getText());
            Prefs.putPref(PrefName.DBPASS, new String(this.jPasswordField1.getPassword()));
            Prefs.putPref(PrefName.JDBCURL, this.jdbcText.getText());
            Errmsg.getErrorHandler().notice(Resource.getResourceString("Restart_Warning"));
            System.exit(0);
        }
    }

    private void dbTypeChange(String type) {
        if (type.equals("mysql")) {
            this.mysqlPanel.setVisible(true);
            this.hsqldbPanel.setVisible(false);
            this.jdbcPanel.setVisible(false);
            this.h2Panel.setVisible(false);
        } else if (type.equals("hsqldb")) {
            this.mysqlPanel.setVisible(false);
            this.hsqldbPanel.setVisible(true);
            this.jdbcPanel.setVisible(false);
            this.h2Panel.setVisible(false);
        } else if (type.equals("h2")) {
            this.mysqlPanel.setVisible(false);
            this.hsqldbPanel.setVisible(false);
            this.jdbcPanel.setVisible(false);
            this.h2Panel.setVisible(true);
        } else {
            this.mysqlPanel.setVisible(false);
            this.hsqldbPanel.setVisible(false);
            this.jdbcPanel.setVisible(true);
            this.h2Panel.setVisible(false);
        }
    }

    private JPanel getDbTypePanel() {
        if (this.dbTypePanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(0);
            flowLayout.setHgap(40);
            this.dbTypePanel = new JPanel();
            this.dbTypePanel.setLayout(flowLayout);
            this.hsqldbButton = new JRadioButton();
            this.hsqldbButton.setActionCommand("hsqldb");
            ResourceHelper.setText(this.hsqldbButton, "hsqldb");
            this.hsqldbButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseOptionsPanel.this.dbTypeChange(e.getActionCommand());
                }
            });
            this.dbTypePanel.add((Component)this.hsqldbButton, null);
            this.h2Button = new JRadioButton();
            this.h2Button.setActionCommand("h2");
            this.h2Button.setText("H2");
            this.h2Button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseOptionsPanel.this.dbTypeChange(e.getActionCommand());
                }
            });
            this.dbTypePanel.add((Component)this.h2Button, null);
            this.MySQLButton = new JRadioButton();
            this.MySQLButton.setActionCommand("mysql");
            this.MySQLButton.setText("MySQL");
            this.MySQLButton.setMnemonic(77);
            this.MySQLButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseOptionsPanel.this.dbTypeChange(e.getActionCommand());
                }
            });
            this.dbTypePanel.add((Component)this.MySQLButton, null);
            this.jdbcButton = new JRadioButton();
            this.jdbcButton.setActionCommand("jdbc");
            ResourceHelper.setText(this.jdbcButton, "jdbc");
            this.jdbcButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseOptionsPanel.this.dbTypeChange(e.getActionCommand());
                }
            });
            this.dbTypePanel.add((Component)this.jdbcButton, null);
            this.dbTypeGroup = new ButtonGroup();
            this.dbTypeGroup.add(this.hsqldbButton);
            this.dbTypeGroup.add(this.h2Button);
            this.dbTypeGroup.add(this.MySQLButton);
            this.dbTypeGroup.add(this.jdbcButton);
        }
        return this.dbTypePanel;
    }

    private JPanel getHSQLDBPanel() {
        this.hsqldbPanel = new JPanel();
        this.hsqldbPanel.setLayout(new GridBagLayout());
        JLabel hs1 = new JLabel();
        this.hsqldbPanel.setBorder(new TitledBorder(Resource.getResourceString("hsqldbinfo")));
        ResourceHelper.setText(hs1, "DataBase_Directory");
        hs1.setLabelFor(this.dbDirText);
        this.hsqldbPanel.add((Component)hs1, GridBagConstraintsFactory.create(0, 0, 1));
        this.hsqldbPanel.add((Component)this.hsqldbdir, GridBagConstraintsFactory.create(0, 1, 1, 0.5, 0.0));
        JButton hsb1 = new JButton();
        ResourceHelper.setText(hsb1, "Browse");
        hsb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String dbdir = OptionsView.OptionsPanel.chooseDir();
                if (dbdir == null) {
                    return;
                }
                DatabaseOptionsPanel.this.hsqldbdir.setText(dbdir);
            }
        });
        this.hsqldbPanel.add((Component)hsb1, GridBagConstraintsFactory.create(1, 1, 1));
        return this.hsqldbPanel;
    }

    private JPanel getH2Panel() {
        this.h2Panel = new JPanel();
        this.h2Panel.setLayout(new GridBagLayout());
        JLabel hs1 = new JLabel();
        this.h2Panel.setBorder(new TitledBorder(Resource.getResourceString("h2info")));
        ResourceHelper.setText(hs1, "DataBase_Directory");
        hs1.setLabelFor(this.dbDirText);
        this.h2Panel.add((Component)hs1, GridBagConstraintsFactory.create(0, 0, 1));
        this.h2Panel.add((Component)this.h2dir, GridBagConstraintsFactory.create(0, 1, 1, 0.5, 0.0));
        JButton hsb1 = new JButton();
        ResourceHelper.setText(hsb1, "Browse");
        hsb1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String dbdir = OptionsView.OptionsPanel.chooseDir();
                if (dbdir == null) {
                    return;
                }
                DatabaseOptionsPanel.this.h2dir.setText(dbdir);
            }
        });
        this.h2Panel.add((Component)hsb1, GridBagConstraintsFactory.create(1, 1, 1));
        return this.h2Panel;
    }

    private JPanel getJdbcPanel() {
        if (this.jdbcPanel == null) {
            JLabel enturlLabel = new JLabel();
            ResourceHelper.setText(enturlLabel, "enturl");
            this.jdbcText = new JTextField();
            enturlLabel.setLabelFor(this.jdbcText);
            enturlLabel.setHorizontalTextPosition(2);
            enturlLabel.setHorizontalAlignment(2);
            this.jdbcPanel = new JPanel();
            this.jdbcPanel.setLayout(new GridBagLayout());
            this.jdbcPanel.setBorder(BorderFactory.createTitledBorder(null, Resource.getResourceString("jdbc"), 0, 0, null, null));
            this.jdbcPanel.add((Component)enturlLabel, GridBagConstraintsFactory.create(0, 0, 1));
            this.jdbcPanel.add((Component)this.jdbcText, GridBagConstraintsFactory.create(0, 1, 1, 1.0, 0.0));
        }
        return this.jdbcPanel;
    }

    private JPanel getMysqlPanel() {
        this.mysqlPanel = new JPanel();
        this.mysqlPanel.setLayout(new GridBagLayout());
        this.mysqlPanel.setBorder(new TitledBorder(Resource.getResourceString("MySQLInfo")));
        JLabel jLabel7 = new JLabel();
        ResourceHelper.setText(jLabel7, "DatabaseName");
        jLabel7.setLabelFor(this.dbNameText);
        this.mysqlPanel.add((Component)jLabel7, GridBagConstraintsFactory.create(0, 0, 1));
        this.mysqlPanel.add((Component)this.dbNameText, GridBagConstraintsFactory.create(1, 0, 1));
        JLabel jLabel17 = new JLabel();
        ResourceHelper.setText(jLabel17, "hostname");
        jLabel17.setLabelFor(this.dbHostText);
        this.mysqlPanel.add((Component)jLabel17, GridBagConstraintsFactory.create(0, 1, 1));
        this.mysqlPanel.add((Component)this.dbHostText, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        JLabel jLabel18 = new JLabel();
        ResourceHelper.setText(jLabel18, "port");
        jLabel18.setLabelFor(this.dbPortText);
        this.mysqlPanel.add((Component)jLabel18, GridBagConstraintsFactory.create(0, 2, 1));
        this.mysqlPanel.add((Component)this.dbPortText, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        JLabel jLabel19 = new JLabel();
        ResourceHelper.setText(jLabel19, "User");
        jLabel19.setLabelFor(this.dbUserText);
        this.mysqlPanel.add((Component)jLabel19, GridBagConstraintsFactory.create(0, 3, 1));
        this.mysqlPanel.add((Component)this.dbUserText, GridBagConstraintsFactory.create(1, 3, 1, 1.0, 0.0));
        JLabel jLabel20 = new JLabel();
        ResourceHelper.setText(jLabel20, "Password");
        jLabel20.setLabelFor(this.jPasswordField1);
        this.mysqlPanel.add((Component)jLabel20, GridBagConstraintsFactory.create(0, 4, 1));
        this.mysqlPanel.add((Component)this.jPasswordField1, GridBagConstraintsFactory.create(1, 4, 1));
        return this.mysqlPanel;
    }

    @Override
    public void loadOptions() {
        String dbtype = Prefs.getPref(PrefName.DBTYPE);
        if (dbtype.equals("mysql")) {
            this.MySQLButton.setSelected(true);
        } else if (dbtype.equals("hsqldb")) {
            this.hsqldbButton.setSelected(true);
        } else if (dbtype.equals("h2")) {
            this.h2Button.setSelected(true);
        } else {
            this.jdbcButton.setSelected(true);
        }
        this.dbTypeChange(dbtype);
        this.dbNameText.setText(Prefs.getPref(PrefName.DBNAME));
        this.dbPortText.setText(Prefs.getPref(PrefName.DBPORT));
        this.dbHostText.setText(Prefs.getPref(PrefName.DBHOST));
        this.dbUserText.setText(Prefs.getPref(PrefName.DBUSER));
        this.jPasswordField1.setText(Prefs.getPref(PrefName.DBPASS));
        this.jdbcText.setText(Prefs.getPref(PrefName.JDBCURL));
        this.hsqldbdir.setText(Prefs.getPref(PrefName.HSQLDBDIR));
        this.h2dir.setText(Prefs.getPref(PrefName.H2DIR));
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("DatabaseInformation");
    }
}

