/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.EmailReminder;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

class EmailOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = 795364188303457966L;
    private JCheckBox emailbox = new JCheckBox();
    private JTextField emailtext = new JTextField();
    private JTextField emailfrom = new JTextField();
    private JSpinner emailtimebox = new JSpinner();
    private JPasswordField smpw = new JPasswordField();
    private JTextField smtpport = new JTextField();
    private JTextField smtptext = new JTextField();
    private JCheckBox tlsbox = new JCheckBox();
    private JTextField usertext = new JTextField();

    public EmailOptionsPanel() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel1 = new JLabel();
        ResourceHelper.setText(jLabel1, "SMTP_Server");
        this.add((Component)jLabel1, GridBagConstraintsFactory.create(0, 1, 1));
        jLabel1.setLabelFor(this.smtptext);
        this.smtptext.setColumns(30);
        this.add((Component)this.smtptext, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        JLabel portLabel = new JLabel();
        ResourceHelper.setText(portLabel, "SMTP_Port");
        this.add((Component)portLabel, GridBagConstraintsFactory.create(0, 2, 1));
        jLabel1.setLabelFor(this.smtpport);
        this.smtpport.setColumns(30);
        this.add((Component)this.smtpport, GridBagConstraintsFactory.create(1, 2, 1, 1.0, 0.0));
        JLabel userlabel = new JLabel();
        ResourceHelper.setText(userlabel, "SMTP_user");
        this.add((Component)userlabel, GridBagConstraintsFactory.create(0, 3, 1));
        userlabel.setLabelFor(this.usertext);
        this.add((Component)this.usertext, GridBagConstraintsFactory.create(1, 3, 1));
        JLabel passlabel = new JLabel();
        ResourceHelper.setText(passlabel, "SMTP_password");
        this.add((Component)passlabel, GridBagConstraintsFactory.create(0, 4, 1));
        passlabel.setLabelFor(this.smpw);
        this.add((Component)this.smpw, GridBagConstraintsFactory.create(1, 4, 1));
        JLabel jLabel2 = new JLabel();
        ResourceHelper.setText(jLabel2, "Your_Email_Address");
        this.add((Component)jLabel2, GridBagConstraintsFactory.create(0, 5, 1));
        jLabel2.setLabelFor(this.emailtext);
        this.emailtext.setColumns(30);
        this.add((Component)this.emailtext, GridBagConstraintsFactory.create(1, 5, 1, 1.0, 0.0));
        this.add((Component)new JLabel(Resource.getResourceString("EmailFrom")), GridBagConstraintsFactory.create(0, 6, 1));
        this.emailfrom.setColumns(30);
        this.add((Component)this.emailfrom, GridBagConstraintsFactory.create(1, 6, 1, 1.0, 0.0));
        ResourceHelper.setText(this.emailbox, "Enable_Email");
        this.add((Component)this.emailbox, GridBagConstraintsFactory.create(0, 0, 1));
        JLabel remtimelabel = new JLabel();
        ResourceHelper.setText(remtimelabel, "reminder_time");
        remtimelabel.setLabelFor(this.emailtimebox);
        this.add((Component)remtimelabel, GridBagConstraintsFactory.create(0, 7, 1));
        this.emailtimebox = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor de = new JSpinner.DateEditor(this.emailtimebox, "HH:mm");
        this.emailtimebox.setEditor(de);
        this.add((Component)this.emailtimebox, GridBagConstraintsFactory.create(1, 7, 1, 1.0, 0.0));
        this.tlsbox.setText(Resource.getResourceString("enable_tls"));
        this.add((Component)this.tlsbox, GridBagConstraintsFactory.create(0, 8, 1));
    }

    @Override
    public void applyChanges() {
        OptionsView.OptionsPanel.setBooleanPref(this.emailbox, PrefName.EMAILENABLED);
        OptionsView.OptionsPanel.setBooleanPref(this.tlsbox, PrefName.ENABLETLS);
        if (this.emailbox.isSelected()) {
            Prefs.putPref(PrefName.EMAILSERVER, this.smtptext.getText());
            Prefs.putPref(PrefName.EMAILPORT, this.smtpport.getText());
            Prefs.putPref(PrefName.EMAILADDR, this.emailtext.getText());
            Prefs.putPref(PrefName.EMAILFROM, this.emailfrom.getText());
            Prefs.putPref(PrefName.EMAILUSER, this.usertext.getText());
            try {
                EmailReminder.sep((String)new String(this.smpw.getPassword()));
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
        Date d = (Date)this.emailtimebox.getValue();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(d);
        int hour = cal.get(11);
        int min = cal.get(12);
        Prefs.putPref(PrefName.EMAILTIME, new Integer(hour * 60 + min));
    }

    @Override
    public void loadOptions() {
        int emmins = Prefs.getIntPref(PrefName.EMAILTIME);
        GregorianCalendar cal = new GregorianCalendar(1980, 1, 1, 0, 0, 0);
        ((Calendar)cal).add(12, emmins);
        this.emailtimebox.setValue(cal.getTime());
        OptionsView.OptionsPanel.setCheckBox(this.emailbox, PrefName.EMAILENABLED);
        OptionsView.OptionsPanel.setCheckBox(this.tlsbox, PrefName.ENABLETLS);
        this.smtptext.setText(Prefs.getPref(PrefName.EMAILSERVER));
        this.smtpport.setText(Prefs.getPref(PrefName.EMAILPORT));
        this.emailtext.setText(Prefs.getPref(PrefName.EMAILADDR));
        this.emailfrom.setText(Prefs.getPref(PrefName.EMAILFROM));
        this.usertext.setText(Prefs.getPref(PrefName.EMAILUSER));
        try {
            this.smpw.setText(EmailReminder.gep());
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("EmailParameters");
    }
}

