/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class MiscellaneousOptionsPanel
extends OptionsView.OptionsPanel {
    private static final Logger log = Logger.getLogger("net.sf.borg");
    private static final long serialVersionUID = 2246952528811147049L;
    private JTextField backupDir = new JTextField();
    private JCheckBox colorprint = new JCheckBox();
    private JTextField socketPort = new JTextField();
    private JCheckBox splashbox = new JCheckBox();
    private JCheckBox stackbox = new JCheckBox();
    private JCheckBox useSysTray = new JCheckBox();
    private JCheckBox startToSysTray = new JCheckBox();
    private JCheckBox dateInSysTray = new JCheckBox();
    private JCheckBox dynamicLoading = new JCheckBox();
    private JCheckBox verboseLogging = new JCheckBox();
    private JCheckBox useProxy = new JCheckBox();
    private JComboBox<String> shutdownAction = new JComboBox();
    private JTextField proxyHostText = new JTextField();
    private JTextField proxyPortText = new JTextField();

    public MiscellaneousOptionsPanel() {
        this.setLayout(new GridBagLayout());
        ResourceHelper.setText(this.splashbox, "splash");
        this.add((Component)this.splashbox, GridBagConstraintsFactory.create(0, 0, 1));
        ResourceHelper.setText(this.stackbox, "stackonerr");
        this.add((Component)this.stackbox, GridBagConstraintsFactory.create(0, 1, 1));
        JLabel sportlabel = new JLabel();
        ResourceHelper.setText(sportlabel, "socket_port");
        this.add((Component)sportlabel, GridBagConstraintsFactory.create(0, 2, 1));
        this.add((Component)this.socketPort, GridBagConstraintsFactory.create(1, 2, 1));
        this.useSysTray.setText(Resource.getResourceString("enable_systray"));
        this.add((Component)this.useSysTray, GridBagConstraintsFactory.create(0, 3, 1));
        this.startToSysTray.setText(Resource.getResourceString("StartToSysTray"));
        this.add((Component)this.startToSysTray, GridBagConstraintsFactory.create(0, 4, 1));
        this.dateInSysTray.setText(Resource.getResourceString("show_date_in_systray"));
        this.add((Component)this.dateInSysTray, GridBagConstraintsFactory.create(0, 5, 1));
        JPanel backp = new JPanel();
        backp.setLayout(new GridBagLayout());
        backp.add((Component)new JLabel(Resource.getResourceString("backup_dir") + ": "), GridBagConstraintsFactory.create(0, 0, 0));
        backp.add((Component)this.backupDir, GridBagConstraintsFactory.create(1, 0, 1, 1.0, 0.0));
        JButton bb = new JButton();
        ResourceHelper.setText(bb, "Browse");
        bb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String dbdir = OptionsView.OptionsPanel.chooseDir();
                if (dbdir == null) {
                    return;
                }
                MiscellaneousOptionsPanel.this.backupDir.setText(dbdir);
            }
        });
        backp.add((Component)bb, GridBagConstraintsFactory.create(2, 0, 0));
        backp.add((Component)new JLabel(Resource.getResourceString("on_shutdown")), GridBagConstraintsFactory.create(0, 1, 1));
        this.shutdownAction.addItem(Resource.getResourceString("prompt_for_backup"));
        this.shutdownAction.addItem(Resource.getResourceString("exit_no_backup"));
        this.shutdownAction.addItem(Resource.getResourceString("write_backup_file"));
        this.shutdownAction.addItem(Resource.getResourceString("backup_with_email"));
        backp.add(this.shutdownAction, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        GridBagConstraints gbc1 = GridBagConstraintsFactory.create(0, 6, 1, 1.0, 0.0);
        gbc1.gridwidth = 2;
        this.add((Component)backp, gbc1);
        ResourceHelper.setText(this.colorprint, "Print_In_Color?");
        this.add((Component)this.colorprint, GridBagConstraintsFactory.create(0, 8, 1));
        this.dynamicLoading.setText(Resource.getResourceString("enable_plugins"));
        gbc1 = GridBagConstraintsFactory.create(0, 9, 1);
        gbc1.gridwidth = 2;
        this.add((Component)this.dynamicLoading, gbc1);
        this.verboseLogging.setText(Resource.getResourceString("verbose_logging"));
        gbc1 = GridBagConstraintsFactory.create(0, 10, 1);
        gbc1.gridwidth = 2;
        this.add((Component)this.verboseLogging, gbc1);
        this.useProxy.setText(Resource.getResourceString("Use_Proxy"));
        gbc1 = GridBagConstraintsFactory.create(0, 11, 1);
        gbc1.gridwidth = 2;
        this.add((Component)this.useProxy, gbc1);
        this.add((Component)new JLabel(Resource.getResourceString("proxy_host")), GridBagConstraintsFactory.create(0, 12, 1));
        this.add((Component)this.proxyHostText, GridBagConstraintsFactory.create(1, 12, 1));
        this.add((Component)new JLabel(Resource.getResourceString("proxy_port")), GridBagConstraintsFactory.create(0, 13, 1));
        this.add((Component)this.proxyPortText, GridBagConstraintsFactory.create(1, 13, 1));
    }

    @Override
    public void applyChanges() {
        if (this.verboseLogging.isSelected()) {
            log.setLevel(Level.ALL);
        } else {
            log.setLevel(Level.INFO);
        }
        OptionsView.OptionsPanel.setBooleanPref(this.colorprint, PrefName.COLORPRINT);
        OptionsView.OptionsPanel.setBooleanPref(this.splashbox, PrefName.SPLASH);
        OptionsView.OptionsPanel.setBooleanPref(this.stackbox, PrefName.STACKTRACE);
        OptionsView.OptionsPanel.setBooleanPref(this.useSysTray, PrefName.USESYSTRAY);
        OptionsView.OptionsPanel.setBooleanPref(this.startToSysTray, PrefName.BACKGSTART);
        OptionsView.OptionsPanel.setBooleanPref(this.dateInSysTray, PrefName.SYSTRAYDATE);
        OptionsView.OptionsPanel.setBooleanPref(this.dynamicLoading, PrefName.DYNAMIC_LOADING);
        OptionsView.OptionsPanel.setBooleanPref(this.verboseLogging, PrefName.DEBUG);
        OptionsView.OptionsPanel.setBooleanPref(this.useProxy, PrefName.USE_PROXY);
        Prefs.putPref(PrefName.BACKUPDIR, this.backupDir.getText());
        if (this.shutdownAction.getSelectedIndex() == 0) {
            Prefs.putPref(PrefName.SHUTDOWN_ACTION, SHUTDOWN_ACTION.PROMPT.toString());
        } else if (this.shutdownAction.getSelectedIndex() == 1) {
            Prefs.putPref(PrefName.SHUTDOWN_ACTION, SHUTDOWN_ACTION.NONE.toString());
        } else if (this.shutdownAction.getSelectedIndex() == 2) {
            Prefs.putPref(PrefName.SHUTDOWN_ACTION, SHUTDOWN_ACTION.BACKUP.toString());
        } else if (this.shutdownAction.getSelectedIndex() == 3) {
            Prefs.putPref(PrefName.SHUTDOWN_ACTION, SHUTDOWN_ACTION.EMAIL.toString());
        }
        try {
            int socket = Integer.parseInt(this.socketPort.getText());
            Prefs.putPref(PrefName.SOCKETPORT, new Integer(socket));
        }
        catch (NumberFormatException e) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("socket_warn"));
            this.socketPort.setText("-1");
            Prefs.putPref(PrefName.SOCKETPORT, new Integer(-1));
        }
        Prefs.putPref(PrefName.PROXY_HOST, this.proxyHostText.getText());
        try {
            int port = Integer.parseInt(this.proxyPortText.getText());
            Prefs.putPref(PrefName.PROXY_PORT, new Integer(port));
        }
        catch (NumberFormatException e) {
            Errmsg.getErrorHandler().notice(Resource.getResourceString("proxy_warn"));
        }
    }

    @Override
    public void loadOptions() {
        this.backupDir.setText(Prefs.getPref(PrefName.BACKUPDIR));
        OptionsView.OptionsPanel.setCheckBox(this.colorprint, PrefName.COLORPRINT);
        OptionsView.OptionsPanel.setCheckBox(this.splashbox, PrefName.SPLASH);
        OptionsView.OptionsPanel.setCheckBox(this.stackbox, PrefName.STACKTRACE);
        OptionsView.OptionsPanel.setCheckBox(this.useSysTray, PrefName.USESYSTRAY);
        OptionsView.OptionsPanel.setCheckBox(this.startToSysTray, PrefName.BACKGSTART);
        OptionsView.OptionsPanel.setCheckBox(this.dateInSysTray, PrefName.SYSTRAYDATE);
        OptionsView.OptionsPanel.setCheckBox(this.dynamicLoading, PrefName.DYNAMIC_LOADING);
        OptionsView.OptionsPanel.setCheckBox(this.verboseLogging, PrefName.DEBUG);
        OptionsView.OptionsPanel.setCheckBox(this.useProxy, PrefName.USE_PROXY);
        String shutdown_action = Prefs.getPref(PrefName.SHUTDOWN_ACTION);
        if (shutdown_action.isEmpty() || SHUTDOWN_ACTION.PROMPT.toString().equals(shutdown_action)) {
            this.shutdownAction.setSelectedIndex(0);
        } else if (SHUTDOWN_ACTION.NONE.toString().equals(shutdown_action)) {
            this.shutdownAction.setSelectedIndex(1);
        } else if (SHUTDOWN_ACTION.BACKUP.toString().equals(shutdown_action)) {
            this.shutdownAction.setSelectedIndex(2);
        } else if (SHUTDOWN_ACTION.EMAIL.toString().equals(shutdown_action)) {
            this.shutdownAction.setSelectedIndex(3);
        }
        int socket = Prefs.getIntPref(PrefName.SOCKETPORT);
        this.socketPort.setText(Integer.toString(socket));
        this.proxyHostText.setText(Prefs.getPref(PrefName.PROXY_HOST));
        int port = Prefs.getIntPref(PrefName.PROXY_PORT);
        this.proxyPortText.setText(Integer.toString(port));
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("misc");
    }

    public static enum SHUTDOWN_ACTION {
        PROMPT,
        BACKUP,
        EMAIL,
        NONE;

    }
}

