/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.ui.ResourceHelper;
import net.sf.borg.ui.options.OptionsView;
import net.sf.borg.ui.popup.ReminderSound;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

class PopupOptionsPanel
extends OptionsView.OptionsPanel {
    private static final long serialVersionUID = -5238561005974597879L;
    private JSpinner checkfreq = new JSpinner();
    private int numberOfReminderTimes = 0;
    private JCheckBox popenablebox = new JCheckBox();
    private JCheckBox reminderListBox = new JCheckBox();
    private JCheckBox taskReminderBox = new JCheckBox();
    private JComboBox<String> soundbox = new JComboBox();
    private JSpinner[] spinners;
    private JSpinner birthdayDays = new JSpinner();

    public PopupOptionsPanel() {
        this.setLayout(new GridBagLayout());
        this.numberOfReminderTimes = ReminderTimes.getNum();
        ResourceHelper.setText(this.popenablebox, "enable_popups");
        this.add((Component)this.popenablebox, GridBagConstraintsFactory.create(0, 0, 1));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText(Resource.getResourceString("todo_reminder_freq"));
        this.add((Component)jLabel15, GridBagConstraintsFactory.create(0, 1, 1));
        this.checkfreq.setMinimumSize(new Dimension(50, 20));
        this.add((Component)this.checkfreq, GridBagConstraintsFactory.create(1, 1, 1, 1.0, 0.0));
        JPanel soundPanel = new JPanel();
        soundPanel.setLayout(new GridBagLayout());
        soundPanel.add((Component)new JLabel(Resource.getResourceString("beep_options")), GridBagConstraintsFactory.create(0, 0, 1));
        this.soundbox.setEditable(true);
        this.soundbox.addItem(Resource.getResourceString("default"));
        this.soundbox.addItem(Resource.getResourceString("no_sound"));
        this.soundbox.addItem(Resource.getResourceString("Use_system_beep"));
        this.soundbox.addItem(Resource.getResourceString("Browse") + "...");
        this.soundbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PopupOptionsPanel.this.soundbox.getSelectedIndex() == 3) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setCurrentDirectory(new File("."));
                    chooser.setDialogTitle(Resource.getResourceString("choose_file"));
                    chooser.setFileSelectionMode(0);
                    int returnVal = chooser.showOpenDialog(null);
                    if (returnVal != 0) {
                        return;
                    }
                    String fileName = chooser.getSelectedFile().getAbsolutePath();
                    PopupOptionsPanel.this.soundbox.setSelectedItem(fileName);
                }
            }
        });
        soundPanel.add(this.soundbox, GridBagConstraintsFactory.create(1, 0, 1));
        JButton play = new JButton();
        play.setIcon(new ImageIcon(this.getClass().getResource("/resource/Forward16.gif")));
        play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReminderSound.playReminderSound(PopupOptionsPanel.this.getSoundOption());
            }
        });
        soundPanel.add((Component)play, GridBagConstraintsFactory.create(2, 0, 1));
        GridBagConstraints sPanelGBC = GridBagConstraintsFactory.create(0, 2, 3);
        sPanelGBC.gridwidth = 0;
        sPanelGBC.anchor = 17;
        sPanelGBC.insets = new Insets(0, 0, 0, 0);
        this.add((Component)soundPanel, sPanelGBC);
        JPanel remTimePanel = new JPanel();
        String title = Resource.getResourceString("Popup_Times") + " (" + Resource.getResourceString("Minutes") + ")";
        TitledBorder b = BorderFactory.createTitledBorder(remTimePanel.getBorder(), title);
        remTimePanel.setBorder(b);
        remTimePanel.setLayout(new GridLayout(4, 0));
        this.spinners = new JSpinner[this.numberOfReminderTimes];
        for (int i = 0; i < this.numberOfReminderTimes; ++i) {
            this.spinners[i] = new JSpinner(new SpinnerNumberModel(0, -99999, 99999, 1));
            remTimePanel.add(this.spinners[i]);
        }
        GridBagConstraints remPanelGBC = GridBagConstraintsFactory.create(0, 3, 1);
        remPanelGBC.gridwidth = 0;
        remPanelGBC.anchor = 17;
        this.add((Component)remTimePanel, remPanelGBC);
        this.reminderListBox.setText(Resource.getResourceString("reminder_list"));
        this.add((Component)this.reminderListBox, GridBagConstraintsFactory.create(0, 4, 1));
        this.taskReminderBox.setText(Resource.getResourceString("show_task_reminders"));
        this.add((Component)this.taskReminderBox, GridBagConstraintsFactory.create(0, 5, 1));
        this.add((Component)new JLabel(Resource.getResourceString("bd_rem_days")), GridBagConstraintsFactory.create(0, 6, 1));
        this.birthdayDays.setMinimumSize(new Dimension(50, 20));
        this.add((Component)this.birthdayDays, GridBagConstraintsFactory.create(1, 6, 1, 1.0, 0.0));
    }

    @Override
    public void applyChanges() {
        OptionsView.OptionsPanel.setBooleanPref(this.popenablebox, PrefName.REMINDERS);
        OptionsView.OptionsPanel.setBooleanPref(this.reminderListBox, PrefName.REMINDERLIST);
        OptionsView.OptionsPanel.setBooleanPref(this.taskReminderBox, PrefName.TASKREMINDERS);
        Prefs.putPref(PrefName.BEEPINGREMINDERS, this.getSoundOption());
        Integer checkMins = (Integer)this.checkfreq.getValue();
        int cur = Prefs.getIntPref(PrefName.TODOREMINDERMINS);
        if (checkMins != cur) {
            Prefs.putPref(PrefName.TODOREMINDERMINS, checkMins);
        }
        Integer bddays = (Integer)this.birthdayDays.getValue();
        Prefs.putPref(PrefName.BIRTHDAYREMINDERDAYS, bddays);
        int[] arr = new int[this.numberOfReminderTimes];
        for (int i = 0; i < this.numberOfReminderTimes; ++i) {
            Integer ii = (Integer)this.spinners[i].getValue();
            arr[i] = ii;
        }
        ReminderTimes.setTimes((int[])arr);
        this.loadTimes();
    }

    @Override
    public void loadOptions() {
        OptionsView.OptionsPanel.setCheckBox(this.popenablebox, PrefName.REMINDERS);
        OptionsView.OptionsPanel.setCheckBox(this.reminderListBox, PrefName.REMINDERLIST);
        OptionsView.OptionsPanel.setCheckBox(this.taskReminderBox, PrefName.TASKREMINDERS);
        String beep = Prefs.getPref(PrefName.BEEPINGREMINDERS);
        if (beep.equals("true")) {
            this.soundbox.setSelectedIndex(0);
        } else if (beep.equals("false")) {
            this.soundbox.setSelectedIndex(1);
        } else if (beep.equals("system-beep")) {
            this.soundbox.setSelectedIndex(2);
        } else {
            this.soundbox.setSelectedItem(beep);
        }
        int mins = Prefs.getIntPref(PrefName.TODOREMINDERMINS);
        this.checkfreq.setValue(new Integer(mins));
        int bddays = Prefs.getIntPref(PrefName.BIRTHDAYREMINDERDAYS);
        this.birthdayDays.setValue(new Integer(bddays));
        this.loadTimes();
    }

    private void loadTimes() {
        for (int i = 0; i < this.numberOfReminderTimes; ++i) {
            this.spinners[i].setValue(new Integer(ReminderTimes.getTimes((int)i)));
        }
    }

    private String getSoundOption() {
        String option = "";
        int i = this.soundbox.getSelectedIndex();
        option = i == 0 ? "true" : (i == 1 ? "false" : (i == 2 ? "system-beep" : (String)this.soundbox.getSelectedItem()));
        return option;
    }

    @Override
    public String getPanelName() {
        return Resource.getResourceString("popup_reminders");
    }
}

