/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Date;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.model.AppointmentModel;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.entity.Appointment;
import net.sf.borg.ui.calendar.AppointmentTextFormat;
import net.sf.borg.ui.popup.ReminderInstance;

public class ApptReminderInstance
extends ReminderInstance {
    private Appointment appt;

    public ApptReminderInstance(Appointment appt, Date instanceTime) {
        this.appt = appt;
        this.setInstanceTime(instanceTime);
    }

    @Override
    public void do_todo(boolean delete) {
        if (this.appt != null) {
            try {
                AppointmentModel.getReference().do_todo(this.appt.getKey(), delete);
            }
            catch (Exception e) {
                Errmsg.getErrorHandler().errmsg(e);
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApptReminderInstance other = (ApptReminderInstance)obj;
        if (this.appt == null ? other.appt != null : this.appt.getKey() != other.appt.getKey()) {
            return false;
        }
        return !(this.getInstanceTime() == null ? other.getInstanceTime() != null : !this.getInstanceTime().equals(other.getInstanceTime()));
    }

    @Override
    public int getCurrentReminder() {
        char[] remTimes = new char[ReminderTimes.getNum()];
        try {
            remTimes = this.appt.getReminderTimes().toCharArray();
        }
        catch (Exception e) {
            for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                remTimes[i] = 78;
            }
        }
        long minutesToGo = this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L;
        int nextFutureReminder = 0;
        while ((long)ReminderTimes.getTimes((int)nextFutureReminder) < minutesToGo) {
            ++nextFutureReminder;
        }
        if (nextFutureReminder >= ReminderTimes.getNum()) {
            return -1;
        }
        if (remTimes[nextFutureReminder] == 'Y') {
            return nextFutureReminder;
        }
        return -1;
    }

    @Override
    public String getText() {
        if (this.appt != null) {
            return AppointmentTextFormat.format(this.appt, this.getInstanceTime());
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appt == null ? 0 : this.appt.getKey());
        result = 31 * result + (this.getInstanceTime() == null ? 0 : this.getInstanceTime().hashCode());
        return result;
    }

    @Override
    public boolean isNote() {
        if (this.appt != null) {
            return AppointmentModel.isNote((Appointment)this.appt);
        }
        return false;
    }

    private boolean isOutsideOfReminderTimes(boolean nonExpiring) {
        long minutesToGo = this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L;
        int latestReminderTime = 100000;
        int earliestReminderTime = -100000;
        char[] remTimes = new char[ReminderTimes.getNum()];
        try {
            remTimes = this.appt.getReminderTimes().toCharArray();
        }
        catch (Exception e) {
            for (int i = 0; i < ReminderTimes.getNum(); ++i) {
                remTimes[i] = 78;
            }
        }
        for (int i = 0; i < ReminderTimes.getNum(); ++i) {
            if (remTimes[i] != 'Y') continue;
            int time = ReminderTimes.getTimes((int)i);
            if (time > earliestReminderTime) {
                earliestReminderTime = ReminderTimes.getTimes((int)i);
            }
            if (time >= latestReminderTime) continue;
            latestReminderTime = ReminderTimes.getTimes((int)i);
        }
        if (earliestReminderTime == -100000) {
            return true;
        }
        return minutesToGo > (long)earliestReminderTime || !nonExpiring && minutesToGo < (long)latestReminderTime;
    }

    @Override
    public boolean isTodo() {
        if (this.appt != null) {
            return this.appt.isTodo();
        }
        return false;
    }

    @Override
    public boolean reloadAndCheckForChanges() {
        try {
            Appointment origAppt = this.appt;
            this.appt = AppointmentModel.getReference().getAppt(this.appt.getKey());
            if (this.appt == null) {
                return true;
            }
            if (!this.appt.getDate().equals(origAppt.getDate())) {
                return true;
            }
            if (!this.appt.getText().equals(origAppt.getText())) {
                return true;
            }
            if (this.isNote() && this.isTodo()) {
                Date nt = this.appt.getNextTodo();
                if (nt == null) {
                    nt = this.appt.getDate();
                }
                if (!this.getInstanceTime().equals(nt)) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.appt = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeShown() {
        if (this.appt == null) {
            return false;
        }
        boolean showpub = Prefs.getBoolPref(PrefName.SHOWPUBLIC);
        boolean showpriv = Prefs.getBoolPref(PrefName.SHOWPRIVATE);
        if (this.appt.isPrivate() ? !showpriv : !showpub) {
            return false;
        }
        if (this.isNote() && !this.isTodo()) {
            return false;
        }
        boolean expires = true;
        if (this.isNote() && this.isTodo() && this.appt.getReminderTimes() != null && this.appt.getReminderTimes().indexOf(89) != -1) {
            expires = false;
        }
        return !this.isOutsideOfReminderTimes(!expires);
    }
}

