/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.ArrayList;
import java.util.List;
import net.sf.borg.model.Model;
import net.sf.borg.ui.popup.ReminderInstance;
import net.sf.borg.ui.popup.ReminderList;
import net.sf.borg.ui.popup.ReminderManager;

public class ReminderListManager
extends ReminderManager {
    private ReminderList reminderList = new ReminderList();
    private List<ReminderInstance> reminders = new ArrayList<ReminderInstance>();

    public static ReminderManager getReference() {
        if (singleton == null) {
            singleton = new ReminderListManager();
        }
        return singleton;
    }

    private ReminderListManager() {
    }

    @Override
    public void addToUI(ReminderInstance instance) {
        if (this.reminders.contains(instance)) {
            return;
        }
        this.reminders.add(instance);
    }

    public List<ReminderInstance> getReminders() {
        return this.reminders;
    }

    @Override
    public void hideAll() {
        this.reminderList.setVisible(false);
    }

    @Override
    public void periodicUpdate() {
        boolean needUpdate = false;
        for (ReminderInstance reminderInstance : this.reminders) {
            if (reminderInstance.isHidden()) continue;
            if (reminderInstance.isNote() && reminderInstance.isTodo()) {
                if (reminderInstance.isShown() && !this.shouldShowUntimedTodosNow()) continue;
                needUpdate = true;
                break;
            }
            if (reminderInstance.dueForPopup() == -1) continue;
            needUpdate = true;
            break;
        }
        if (needUpdate) {
            this.reminderList.refresh();
        } else if (this.reminderList.isShowing()) {
            this.reminderList.updateTimes();
        }
    }

    public void update(Model.ChangeEvent event) {
        this.refresh();
    }

    @Override
    public void refresh() {
        ArrayList<ReminderInstance> deletedReminders = new ArrayList<ReminderInstance>();
        for (ReminderInstance reminderInstance : this.reminders) {
            if (reminderInstance.reloadAndCheckForChanges()) {
                deletedReminders.add(reminderInstance);
                continue;
            }
            if (reminderInstance.shouldBeShown()) continue;
            deletedReminders.add(reminderInstance);
        }
        for (ReminderInstance inst : deletedReminders) {
            this.reminders.remove(inst);
        }
        if (!deletedReminders.isEmpty()) {
            this.reminderList.refresh(!this.reminderList.isShowing());
        }
    }

    @Override
    public void remove() {
        super.remove();
        this.reminderList.destroy();
    }

    @Override
    public void showAll() {
        this.reminderList.setVisible(true);
        this.reminderList.toFront();
    }
}

