/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.popup;

import java.util.Date;
import net.sf.borg.common.Errmsg;
import net.sf.borg.common.PrefName;
import net.sf.borg.common.Prefs;
import net.sf.borg.common.Resource;
import net.sf.borg.model.ReminderTimes;
import net.sf.borg.model.TaskModel;
import net.sf.borg.model.entity.Subtask;
import net.sf.borg.ui.popup.ReminderInstance;

public class SubtaskReminderInstance
extends ReminderInstance {
    private Subtask subtask;

    @Override
    public void do_todo(boolean delete) {
        try {
            this.subtask = TaskModel.getReference().getSubTask(this.subtask.getKey());
            this.subtask.setCloseDate(new Date());
            TaskModel.getReference().saveSubTask(this.subtask);
        }
        catch (Exception e) {
            Errmsg.getErrorHandler().errmsg(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubtaskReminderInstance other = (SubtaskReminderInstance)obj;
        if (this.subtask == null ? other.subtask != null : this.subtask.getKey() != other.subtask.getKey()) {
            return false;
        }
        return !(this.getInstanceTime() == null ? other.getInstanceTime() != null : !this.getInstanceTime().equals(other.getInstanceTime()));
    }

    @Override
    public int getCurrentReminder() {
        return -1;
    }

    public SubtaskReminderInstance(Subtask subtask) {
        this.subtask = subtask;
        this.setInstanceTime(subtask.getDueDate());
    }

    @Override
    public String getText() {
        return this.subtask.getText();
    }

    @Override
    public String calculateToGoMessage() {
        return Resource.getResourceString("subtask");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subtask == null ? 0 : this.subtask.getKey());
        result = 31 * result + (this.getInstanceTime() == null ? 0 : this.getInstanceTime().hashCode());
        return result;
    }

    @Override
    public boolean isNote() {
        return true;
    }

    @Override
    public boolean isTodo() {
        return true;
    }

    @Override
    public boolean reloadAndCheckForChanges() {
        try {
            Subtask orig = this.subtask;
            this.subtask = TaskModel.getReference().getSubTask(this.subtask.getKey());
            if (this.subtask == null) {
                return true;
            }
            if (this.subtask.getCloseDate() != null) {
                return true;
            }
            if (this.subtask.getDueDate() == null || !this.subtask.getDueDate().equals(orig.getDueDate())) {
                return true;
            }
            if (!this.subtask.getDescription().equals(orig.getDescription())) {
                return true;
            }
        }
        catch (Exception e) {
            this.subtask = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeShown() {
        if (!Prefs.getBoolPref(PrefName.TASKREMINDERS)) {
            return false;
        }
        if (this.subtask == null || this.subtask.getCloseDate() != null) {
            return false;
        }
        long minutesToGo = this.getInstanceTime().getTime() / 60000L - new Date().getTime() / 60000L;
        int earliestReminderTime = -100000;
        for (int i = 0; i < ReminderTimes.getNum(); ++i) {
            int time = ReminderTimes.getTimes((int)i);
            if (time <= earliestReminderTime) continue;
            earliestReminderTime = time;
        }
        if (earliestReminderTime == -100000) {
            return false;
        }
        return minutesToGo < (long)earliestReminderTime;
    }
}

