/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class ColorChooserButton
extends JButton {
    private static final long serialVersionUID = 1L;
    protected Color colorProperty;

    public ColorChooserButton(String p_text, Color p_color) {
        this.setText(p_text);
        this.setColorProperty(p_color);
        this.addActionListener(new ModalListener());
    }

    public Color getColorProperty() {
        return this.colorProperty;
    }

    public void setColorProperty(Color color) {
        this.colorProperty = color;
        this.setIcon(new ColorIcon(color));
    }

    private class ModalListener
    implements ActionListener {
        private ModalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Color selected = JColorChooser.showDialog(null, "", ColorChooserButton.this.getColorProperty());
            if (selected != null) {
                ColorChooserButton.this.setColorProperty(selected);
            }
        }
    }

    private static class ColorIcon
    implements Icon {
        private Color color = Color.BLACK;
        private final int height = 10;
        private final int width = 30;

        public ColorIcon(Color col) {
            this.color = col;
        }

        @Override
        public int getIconHeight() {
            return 10;
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.BLACK);
            g2.drawRect(x, y, 30, 10);
            g2.setColor(this.color);
            g2.fillRect(x, y, 30, 10);
        }
    }
}

