/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.borg.common.Resource;
import net.sf.borg.ui.util.GridBagConstraintsFactory;

public class ModalMessage
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JScrollPane messageScroll = null;
    private JTextArea messageText = null;
    private JButton okButton = null;

    public ModalMessage(String s, boolean enabled) {
        this.initComponents();
        this.messageText.setText(s);
        this.okButton.setEnabled(enabled);
        this.setModal(true);
    }

    public void appendText(String s) {
        String t = this.messageText.getText();
        t = t + "\n" + s;
        this.messageText.setText(t);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.setTitle("BORG");
        this.setSize(165, 300);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridBagLayout());
        this.messageScroll = new JScrollPane();
        this.messageScroll.setPreferredSize(new Dimension(600, 200));
        this.messageText = new JTextArea();
        this.messageText.setEditable(false);
        this.messageText.setLineWrap(true);
        this.messageScroll.setViewportView(this.messageText);
        topPanel.add((Component)this.messageScroll, GridBagConstraintsFactory.create(0, 0, 1, 1.0, 1.0));
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.okButton.setText(Resource.getResourceString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModalMessage.this.dispose();
            }
        });
        buttonPanel.add((Component)this.okButton, null);
        topPanel.add((Component)buttonPanel, GridBagConstraintsFactory.create(0, 1, 1, 0.0, 0.0));
        this.setContentPane(topPanel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = this.messageScroll.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
    }

    @Override
    public void setEnabled(boolean e) {
        this.okButton.setEnabled(e);
    }

    public void setText(String s) {
        this.messageText.setText(s);
    }
}

