/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Color;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.sf.borg.model.Theme;

public class StripedTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private Color stripeColor = Color.white;
    private TableCellRenderer defaultBooleanRenderer = null;
    private TableCellRenderer defaultDateRenderer = null;
    private TableCellRenderer defaultStringRenderer = null;

    public void setStripeColor(Color c) {
        this.stripeColor = c;
    }

    public StripedTable() {
        this.setStripeColor(new Color(Theme.getCurrentTheme().getStripeBg()));
        this.defaultStringRenderer = this.getDefaultRenderer(String.class);
        this.defaultDateRenderer = this.getDefaultRenderer(Date.class);
        this.defaultBooleanRenderer = this.getDefaultRenderer(Boolean.class);
        this.setDefaultRenderer(Object.class, new StripedRenderer());
        this.setDefaultRenderer(Date.class, new StripedRenderer());
        this.setDefaultRenderer(Integer.class, new StripedRenderer());
        this.setDefaultRenderer(Boolean.class, new StripedRenderer());
    }

    private class StripedRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public StripedRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            if (obj instanceof Boolean) {
                Component c = StripedTable.this.defaultBooleanRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
                if (!isSelected && row % 2 == 0) {
                    c.setBackground(StripedTable.this.stripeColor);
                }
                return c;
            }
            JLabel l = obj instanceof Date ? (JLabel)StripedTable.this.defaultDateRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column) : (JLabel)StripedTable.this.defaultStringRenderer.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setForeground(l.getForeground());
            if (!isSelected && row % 2 == 0) {
                this.setBackground(StripedTable.this.stripeColor);
            } else {
                this.setBackground(l.getBackground());
            }
            if (obj instanceof Integer) {
                this.setText(((Integer)obj).toString());
                this.setHorizontalAlignment(0);
            } else if (obj instanceof Date) {
                this.setText(l.getText());
                this.setHorizontalAlignment(0);
            } else {
                this.setText(l.getText());
                this.setHorizontalAlignment(l.getHorizontalAlignment());
            }
            this.setBorder(new EmptyBorder(4, 2, 4, 2));
            return this;
        }
    }
}

