/*
 * Decompiled with CFR 0.152.
 */
package net.sf.borg.ui.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JTable;
import net.sf.borg.common.PrintHelper;

public class TablePrinter
implements Printable {
    private JTable theTable;

    public static void printTable(JTable tbl) throws Exception {
        PrintHelper.printPrintable(new TablePrinter(tbl));
    }

    private TablePrinter(JTable c) {
        this.theTable = c;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        double pageHeight = pageFormat.getImageableHeight() - (double)fontHeight;
        double pageWidth = pageFormat.getImageableWidth();
        double tableWidth = this.theTable.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)this.theTable.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)(this.theTable.getRowHeight() + this.theTable.getRowMargin()) * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.theTable.getRowCount() / (double)numRowsOnAPage);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        g2.drawString("Page: " + (pageIndex + 1), (int)pageWidth / 2 - 35, (int)(pageHeight + (double)fontHeight - (double)fontDesent));
        g2.translate(0.0, headerHeightOnPage);
        g2.translate(0.0, (double)(-pageIndex) * pageHeightForTable);
        if (pageIndex + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageIndex;
            int numRowsLeft = this.theTable.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)pageIndex), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        this.theTable.paint(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.translate(0.0, (double)pageIndex * pageHeightForTable);
        g2.translate(0.0, -headerHeightOnPage);
        g2.setClip(0, 0, (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(headerHeightOnPage));
        g2.scale(scale, scale);
        this.theTable.getTableHeader().paint(g2);
        return 0;
    }
}

