/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.mydragonfly.pj.DragonflyJournal;
import org.mydragonfly.pj.SelectJournalDialog;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.service.JournalService;
import org.mydragonfly.pj.service.exception.DatabaseLockedException;

public class NewJournalDialog
extends JDialog {
    private static final long serialVersionUID = -9088325117898289068L;
    private JLabel jLabel2;
    private JPasswordField jPasswordField1;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel jLabel1;
    private ArrayList<String> journalNames;
    private JTextField journalNameField;
    private boolean NewJournalCreated = false;

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame jFrame = new JFrame();
                try {
                    SelectJournalDialog selectJournalDialog = new SelectJournalDialog(jFrame);
                    selectJournalDialog.setVisible(true);
                }
                catch (DatabaseLockedException databaseLockedException) {
                    databaseLockedException.printStackTrace();
                }
            }
        });
    }

    public NewJournalDialog(JFrame jFrame) throws DatabaseLockedException {
        super(jFrame);
        this.initGUI();
    }

    public String getJournalName() {
        return this.journalNameField.getText();
    }

    public String getPassword() {
        return new String(this.jPasswordField1.getPassword());
    }

    private void initGUI() {
        this.setTitle("Create a New Journal");
        try {
            GroupLayout groupLayout = new GroupLayout((JComponent)this.getContentPane());
            this.getContentPane().setLayout(groupLayout);
            this.okButton = new JButton();
            this.okButton = new JButton();
            List<Journal> list = JournalService.getJournals();
            this.journalNames = new ArrayList();
            for (Journal journal : list) {
                this.journalNames.add(journal.getTitle());
            }
            this.jLabel1 = new JLabel();
            this.jLabel1.setName("jLabel1");
            this.journalNameField = new JTextField(150);
            this.jLabel2 = new JLabel();
            this.jLabel2.setName("jLabel2");
            this.jPasswordField1 = new JPasswordField(30);
            this.jPasswordField1.setName("jPasswordField1");
            this.okButton = new JButton();
            this.okButton.setName("okButton");
            this.okButton.setAction(this.getAppActionMap().get("okButton"));
            this.cancelButton = new JButton();
            this.cancelButton.setName("cancelButton");
            this.cancelButton.setAction(this.getAppActionMap().get("cancel"));
            groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.journalNameField, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.jLabel1, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jPasswordField1, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.jLabel2, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addGap(26).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton, GroupLayout.Alignment.BASELINE, -2, -2, -2).addComponent(this.cancelButton, GroupLayout.Alignment.BASELINE, -2, -2, -2)).addContainerGap(16, 16));
            groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup().addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -2, 124, -2).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -2, 124, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addGap(22).addComponent(this.okButton, -2, 89, -2).addGap(13))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup().addGroup(groupLayout.createSequentialGroup().addComponent(this.jPasswordField1, -2, 124, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addComponent(this.journalNameField, -2, 124, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addPreferredGap(this.jPasswordField1, this.cancelButton, LayoutStyle.ComponentPlacement.INDENT).addComponent(this.cancelButton, -2, 91, -2).addGap(0, 21, Short.MAX_VALUE))).addContainerGap(19, 19));
            groupLayout.linkSize(0, this.jLabel2, this.jLabel1);
            Application.getInstance().getContext().getResourceMap(this.getClass()).injectComponents(this.getContentPane());
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Action
    public void okButton() {
        if (this.getJournalName() == null || this.getJournalName().length() == 0) {
            JOptionPane.showMessageDialog(this, "Journal Name can not be empty. Please provide a name.", "Input error", 0);
        } else {
            Journal journal = new Journal(this.getJournalName(), this.getPassword(), new Date(), null);
            journal = JournalService.saveJournal(journal);
            DragonflyJournal dragonflyJournal = (DragonflyJournal)Application.getInstance();
            dragonflyJournal.setCurrentJournal(journal);
            this.NewJournalCreated = true;
        }
        this.dispose();
    }

    @Action
    public void cancel() {
        this.NewJournalCreated = false;
        this.dispose();
    }

    private ApplicationActionMap getAppActionMap() {
        return Application.getInstance().getContext().getActionMap(this);
    }

    public boolean isNewJournalCreated() {
        return this.NewJournalCreated;
    }
}

