/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.exception.JDBCConnectionException;
import org.mydragonfly.pj.data.Tag;
import org.mydragonfly.pj.service.PJService;
import org.mydragonfly.pj.service.exception.DatabaseLockedException;

public class TagService
extends PJService {
    static Logger logger = Logger.getLogger(TagService.class);

    public static String tagSetToString(Set<Tag> set) {
        String string = "";
        if (set != null && set.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Tag tag : set) {
                stringBuilder.append(tag.getTag_name()).append(", ");
            }
            Object object = stringBuilder.toString().trim();
            if (((String)object).length() > 0 && ((String)object).lastIndexOf(",") == ((String)object).length() - 1) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            string = ((String)object).trim();
        }
        return string;
    }

    public static Set<Tag> toTagSet(Set<String> set) {
        HashSet<Tag> hashSet = new HashSet<Tag>();
        if (set != null) {
            for (String string : set) {
                hashSet.add(new Tag(string));
            }
        }
        return hashSet;
    }

    public static HashSet<Tag> getTagsByName(Set<String> set) throws DatabaseLockedException {
        HashSet<Tag> hashSet = new HashSet<Tag>();
        if (set.size() < 1) {
            return hashSet;
        }
        Session session = TagService.getSession();
        StringBuilder stringBuilder = new StringBuilder("from Tag as tag where tag.tag_name in (");
        for (String iterator : set) {
            stringBuilder.append("'").append(iterator).append("', ");
        }
        if (stringBuilder.lastIndexOf(",") > 0) {
            stringBuilder.replace(stringBuilder.lastIndexOf(","), stringBuilder.lastIndexOf(",") + 1, ")");
        }
        try {
            if (session == null) {
                logger.error((Object)"session returnd was NULL!!");
            }
            Query query = session.createQuery(stringBuilder.toString());
            List list = query.list();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Tag tag = (Tag)iterator.next();
                hashSet.add(tag);
            }
            logger.debug((Object)(" Tags returned=" + hashSet.size()));
            if (hashSet.size() < set.size()) {
                for (Tag tag : hashSet) {
                    set.remove(tag.getTag_name());
                }
                for (String string : set) {
                    hashSet.add(new Tag(string));
                }
            }
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            throw new DatabaseLockedException();
        }
        finally {
            session.close();
        }
        return hashSet;
    }

    public static Set<Tag> parseTags(String string) {
        HashSet<Tag> hashSet = null;
        if (string != null && string.length() != 0) {
            hashSet = new HashSet<Tag>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",|");
            logger.debug((Object)("tag count=" + stringTokenizer.countTokens()));
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                logger.debug((Object)("tag: " + string2));
                Tag tag = null;
                try {
                    tag = TagService.getTag(string2);
                    if (logger.isDebugEnabled() && tag != null) {
                        logger.debug((Object)("Found existing tag id:" + tag.getId() + " name:" + tag.getTag_name()));
                    }
                }
                catch (DatabaseLockedException databaseLockedException) {
                    logger.error((Object)databaseLockedException);
                }
                if (tag == null) {
                    tag = new Tag(string2);
                }
                hashSet.add(tag);
            }
        }
        return hashSet;
    }

    public static Tag getTag(String string) throws DatabaseLockedException {
        Tag tag = null;
        Session session = TagService.getSession();
        try {
            if (session == null) {
                logger.error((Object)"session returnd was NULL!!");
            }
            Query query = session.createQuery("from Tag as tag where tag.tag_name = :name");
            query.setString("name", string);
            List list = query.list();
            if (list != null && list.size() > 0) {
                tag = (Tag)list.get(0);
                logger.debug((Object)("tag=" + tag.getId()));
                session.evict((Object)tag);
            }
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            throw new DatabaseLockedException();
        }
        finally {
            session.close();
        }
        return tag;
    }

    public static Set<String> toNameArray(Set<Tag> set) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Tag tag : set) {
            treeSet.add(tag.getTag_name());
        }
        return treeSet;
    }

    public static Set<String> toNameArray(List<Tag> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Tag tag : list) {
            treeSet.add(tag.getTag_name());
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Tag> getAllTags() {
        Session session = null;
        ArrayList<Tag> arrayList = new ArrayList();
        try {
            session = TagService.getSession();
            Query query = session.createQuery("from Tag as tag order by tag.tag_name");
            arrayList = query.list();
        }
        catch (Exception exception) {
            logger.debug((Object)"Error getting Tags", (Throwable)exception);
        }
        finally {
            session.close();
        }
        logger.debug((Object)("resultSet=" + arrayList));
        return arrayList;
    }
}

