/*
 * Decompiled with CFR 0.152.
 */
package de.wannawork.jcalendar;

import de.wannawork.jcalendar.FlatButton;
import de.wannawork.jcalendar.JMonthPanel;
import de.wannawork.jcalendar.LocaleStrings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JCalendarPanel
extends JPanel
implements ItemListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    public static final int FIRE_EVERYTIME = 1;
    public static final int FIRE_DAYCHANGES = 2;
    private int _listenermode = 1;
    private boolean _updating = false;
    private Calendar _cal;
    private DateFormat _format;
    private Locale _locale;
    private JComboBox _month;
    private JComboBox _year;
    private JMonthPanel _monthPanel;
    private ArrayList<ChangeListener> _changeListener = new ArrayList();
    private boolean _fireingChangeEvent = false;

    public JCalendarPanel() {
        this.createGUI(Calendar.getInstance(), Locale.getDefault(), DateFormat.getDateInstance(2, Locale.getDefault()), true, 2100);
    }

    public JCalendarPanel(Calendar calendar) {
        this.createGUI(calendar, Locale.getDefault(), DateFormat.getDateInstance(2, Locale.getDefault()), true, 2100);
    }

    public JCalendarPanel(Locale locale) {
        this.createGUI(Calendar.getInstance(locale), locale, DateFormat.getDateInstance(2, locale), true, 2100);
    }

    public JCalendarPanel(Calendar calendar, Locale locale) {
        this.createGUI(calendar, locale, DateFormat.getDateInstance(2, locale), true, 2100);
    }

    public JCalendarPanel(Calendar calendar, Locale locale, DateFormat dateFormat) {
        this.createGUI(calendar, locale, dateFormat, true, 2100);
    }

    public JCalendarPanel(Calendar calendar, Locale locale, DateFormat dateFormat, boolean bl) {
        this.createGUI(calendar, locale, dateFormat, bl, 2100);
    }

    public JCalendarPanel(Calendar calendar, Locale locale, DateFormat dateFormat, boolean bl, int n) {
        this.createGUI(calendar, locale, dateFormat, bl, n);
    }

    private void createGUI(Calendar calendar, Locale locale, DateFormat dateFormat, boolean bl, int n) {
        this._locale = locale;
        this._cal = Calendar.getInstance(locale);
        this._cal.set(5, calendar.get(5));
        this._cal.set(2, calendar.get(2));
        this._cal.set(1, calendar.get(1));
        this._format = dateFormat;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this._month = this.createMonth();
        this._month.addItemListener(this);
        this.add((Component)this._month, gridBagConstraints);
        this._year = this.createYear(n);
        this._year.addItemListener(this);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this._year, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this._monthPanel = new JMonthPanel(this._cal, this._locale);
        this._monthPanel.addChangeListener(this);
        this.add((Component)this._monthPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 1, 0);
        this.add((Component)this.createButtonPanel(bl), gridBagConstraints);
        this._monthPanel.grabFocus();
    }

    private JPanel createButtonPanel(boolean bl) {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel = new JPanel();
        if (bl) {
            jButton5 = new FlatButton("<<");
            jButton4 = new FlatButton("<");
            jButton3 = new FlatButton(LocaleStrings.getString("JCalendarPanel.Today"));
            jButton2 = new FlatButton(">");
            jButton = new FlatButton(">>");
        } else {
            jButton5 = new JButton("<<");
            jButton5.setMargin(new Insets(1, 1, 1, 1));
            jButton4 = new JButton("<");
            jButton4.setMargin(new Insets(1, 1, 1, 1));
            jButton3 = new JButton(LocaleStrings.getString("JCalendarPanel.Today"));
            jButton3.setMargin(new Insets(2, 2, 2, 2));
            jButton2 = new JButton(">");
            jButton2.setMargin(new Insets(1, 1, 1, 1));
            jButton = new JButton(">>");
            jButton.setMargin(new Insets(1, 1, 1, 1));
        }
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jButton5.setMargin(new Insets(1, 1, 1, 1));
        jButton5.setToolTipText(LocaleStrings.getString("JCalendarPanel.Last_Year"));
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JCalendarPanel.this._year.getSelectedIndex() > 0) {
                    int n = JCalendarPanel.this._cal.get(2);
                    JCalendarPanel.this._cal.set(1, JCalendarPanel.this._cal.get(1) - 1);
                    if (JCalendarPanel.this._cal.get(2) != n) {
                        JCalendarPanel.this._cal.set(2, n);
                    }
                    JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
                }
            }
        });
        jPanel.add((Component)jButton5, gridBagConstraints);
        jButton4.setMargin(new Insets(1, 1, 1, 1));
        jButton4.setToolTipText(LocaleStrings.getString("JCalendarPanel.Last_Month"));
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JCalendarPanel.this._cal.get(2);
                JCalendarPanel.this._cal.set(2, n - 1);
                if (JCalendarPanel.this._cal.get(2) == n) {
                    JCalendarPanel.this._cal.set(5, 0);
                }
                JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
            }
        });
        jPanel.add((Component)jButton4, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        jButton3.setMargin(new Insets(2, 2, 2, 2));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCalendarPanel.this.setCalendar(Calendar.getInstance());
                JCalendarPanel.this.fireChangeEvent();
            }
        });
        jPanel.add((Component)jButton3, gridBagConstraints2);
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jButton2.setMargin(new Insets(1, 1, 1, 1));
        jButton2.setToolTipText(LocaleStrings.getString("JCalendarPanel.Next_Month"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JCalendarPanel.this._cal.get(2);
                JCalendarPanel.this._cal.set(2, n + 1);
                if (JCalendarPanel.this._cal.get(2) != (n + 1) % 12) {
                    JCalendarPanel.this._cal.set(5, 0);
                }
                JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
            }
        });
        jPanel.add((Component)jButton2, gridBagConstraints);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setToolTipText(LocaleStrings.getString("JCalendarPanel.Next_Year"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (JCalendarPanel.this._year.getSelectedIndex() < JCalendarPanel.this._year.getItemCount() - 1) {
                    int n = JCalendarPanel.this._cal.get(2);
                    JCalendarPanel.this._cal.set(1, JCalendarPanel.this._cal.get(1) + 1);
                    if (JCalendarPanel.this._cal.get(2) != n) {
                        JCalendarPanel.this._cal.set(2, n);
                    }
                    JCalendarPanel.this.setCalendar(JCalendarPanel.this._cal, false);
                }
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private JComboBox createYear(int n) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i = 1900; i <= n; ++i) {
            jComboBox.addItem("" + i);
        }
        jComboBox.setSelectedIndex(this._cal.get(1) - 1900);
        return jComboBox;
    }

    private JComboBox createMonth() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setFocusable(false);
        String[] stringArray = DateFormatSymbols.getInstance(this._locale).getMonths();
        for (int i = 0; i < 12; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        jComboBox.setSelectedIndex(this._cal.get(2));
        return jComboBox;
    }

    private void updateCalendar() {
        if (!this._updating) {
            this._updating = true;
            this._cal.set(2, this._month.getSelectedIndex());
            this._cal.set(1, this._year.getSelectedIndex() + 1900);
            this._cal.set(5, this._monthPanel.getSelectedDayOfMonth());
            this._monthPanel.setCalendar(this._cal);
            this._monthPanel.grabFocus();
            this._updating = false;
        }
    }

    public Calendar getCalendar() {
        return this._cal;
    }

    public Date getDate() {
        if (this.isUnset()) {
            return null;
        }
        return this.getCalendar().getTime();
    }

    public void setCalendar(Calendar calendar) {
        this.setCalendar(calendar, true);
    }

    private void setCalendar(Calendar calendar, boolean bl) {
        this._updating = true;
        if (calendar == null) {
            calendar = Calendar.getInstance(this._locale);
            this._cal.set(5, calendar.get(5));
            this._cal.set(2, calendar.get(2));
            this._cal.set(1, calendar.get(1));
            this._monthPanel.setCalendar(null);
        } else {
            if (this._cal != calendar) {
                this._cal.set(5, calendar.get(5));
                this._cal.set(2, calendar.get(2));
                this._cal.set(1, calendar.get(1));
            }
            this._monthPanel.setCalendar(this._cal);
        }
        this._year.setSelectedIndex(this._cal.get(1) - 1900);
        this._month.setSelectedIndex(this._cal.get(2));
        this._monthPanel.grabFocus();
        if (bl) {
            this.fireChangeEvent();
        }
        this._updating = false;
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setCalendar(null);
        } else {
            this._cal.setTime(date);
            this.setCalendar(this._cal);
        }
    }

    @Override
    public String toString() {
        if (this.isUnset()) {
            return "<No Date>";
        }
        return this._format.format(this._cal.getTime());
    }

    public String toString(DateFormat dateFormat) {
        return dateFormat.format(this._cal.getTime());
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateCalendar();
        if (this._listenermode == 1) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this._updating) {
            this._cal.set(5, this._monthPanel.getSelectedDayOfMonth());
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeListener.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this._changeListener.remove(changeListener);
    }

    public ChangeListener[] getChangeListener() {
        return (ChangeListener[])this._changeListener.toArray();
    }

    protected void fireChangeEvent() {
        if (!this._fireingChangeEvent) {
            this._fireingChangeEvent = true;
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this._changeListener.size(); ++i) {
                this._changeListener.get(i).stateChanged(changeEvent);
            }
            this._fireingChangeEvent = false;
        }
    }

    public void setListenerModus(int n) {
        this._listenermode = n;
    }

    @Override
    public void setEnabled(boolean bl) {
        this._month.setEnabled(bl);
        this._year.setEnabled(bl);
        this._monthPanel.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this._month.isEnabled();
    }

    public void setDateFormat(DateFormat dateFormat) {
        if (dateFormat == null) {
            throw new NullPointerException("format is null");
        }
        this._format = dateFormat;
    }

    public DateFormat getDateFormat() {
        return this._format;
    }

    public boolean isUnset() {
        return this._monthPanel.isUnset();
    }
}

