/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.gtdfree.Messages;

public class DatabaseSelectionDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected boolean upgrade;
    protected boolean cont = false;
    private JRadioButton rbXML;
    private JRadioButton rbODB;
    private JCheckBox cb;

    public static void main(String[] args) {
        DatabaseSelectionDialog d = new DatabaseSelectionDialog(null);
        d.setVisible(true);
        System.out.println("Success " + d.isSuccess());
        System.out.println("DB " + d.getDatabase());
        System.out.println("Upgrade " + d.isUpgrade());
    }

    public DatabaseSelectionDialog(Window owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Messages.getString("DatabaseSelectionDialog.Title"));
        this.setModal(true);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        int row = 0;
        JLabel l = new JLabel(Messages.getString("DatabaseSelectionDialog.Question"));
        p.add((Component)l, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 4, 11), 0, 0));
        this.rbXML = new JRadioButton();
        this.rbXML.setText(Messages.getString("DatabaseSelectionDialog.XML"));
        bg.add(this.rbXML);
        p.add((Component)this.rbXML, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
        l = new JLabel(Messages.getString("DatabaseSelectionDialog.XMl.desc"));
        l.setFont(l.getFont().deriveFont(2));
        p.add((Component)l, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 22, 4, 11), 0, 0));
        this.cb = new JCheckBox();
        this.rbODB = new JRadioButton();
        this.rbODB.setText(Messages.getString("DatabaseSelectionDialog.ODB"));
        this.rbODB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DatabaseSelectionDialog.this.cb.setEnabled(DatabaseSelectionDialog.this.rbODB.isSelected());
            }
        });
        this.rbODB.setSelected(true);
        bg.add(this.rbODB);
        p.add((Component)this.rbODB, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
        l = new JLabel(Messages.getString("DatabaseSelectionDialog.ODB.desc"));
        l.setFont(l.getFont().deriveFont(2));
        p.add((Component)l, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 22, 4, 11), 0, 0));
        this.cb.setText(Messages.getString("DatabaseSelectionDialog.Import"));
        this.cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DatabaseSelectionDialog.this.upgrade = DatabaseSelectionDialog.this.cb.isSelected();
            }
        });
        p.add((Component)this.cb, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 22, 4, 11), 0, 0));
        JButton b = new JButton();
        b.setText(Messages.getString("DatabaseSelectionDialog.Continue"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseSelectionDialog.this.cont = true;
                DatabaseSelectionDialog.this.dispose();
            }
        });
        p.add((Component)b, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 13, 0, new Insets(11, 11, 11, 4), 0, 0));
        b = new JButton();
        b.setText(Messages.getString("DatabaseSelectionDialog.Abort"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseSelectionDialog.this.dispose();
            }
        });
        p.add((Component)b, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 17, 0, new Insets(11, 4, 11, 11), 0, 0));
        this.setContentPane(p);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public boolean isSuccess() {
        return this.cont;
    }

    public String getDatabase() {
        if (!this.cont) {
            return null;
        }
        if (this.rbODB.isSelected()) {
            return "odb";
        }
        return "xml";
    }
}

