/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.gui.FolderTree;
import org.gtdfree.gui.FoldingPanel;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModelAdapter;

public class FolderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private FolderTree folderTree;
    private AbstractAction addFolderAction;
    private JTextField folderNameField;
    private AbstractAction renameFolderAction;
    private GTDFreeEngine engine;
    private AbstractAction closeFolderAction;
    private AbstractAction reopenFolderAction;
    private FoldingPanel foldingPanel;

    public FolderPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.folderTree = new FolderTree();
        this.folderTree.addPropertyChangeListener("selectedFolder", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FolderPanel.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                FolderPanel.this.folderNameField.setEnabled(FolderPanel.this.folderTree.isFolderRenamePossible() || FolderPanel.this.folderTree.isFolderAddPossible());
                FolderPanel.this.getRenameFolderAction().setEnabled(FolderPanel.this.folderTree.isFolderRenamePossible());
                FolderPanel.this.getAddFolderAction().setEnabled(FolderPanel.this.folderTree.isFolderAddPossible());
                FolderPanel.this.getCloseFolderAction().setEnabled(FolderPanel.this.getSelectedFolder() != null && !FolderPanel.this.getSelectedFolder().isBuildIn() && FolderPanel.this.getSelectedFolder().getType() != Folder.FolderType.INBUCKET && FolderPanel.this.getSelectedFolder().getType() != Folder.FolderType.QUEUE && !FolderPanel.this.getSelectedFolder().isClosed() && FolderPanel.this.getSelectedFolder().getOpenCount() == 0);
                FolderPanel.this.getReopenFolderAction().setEnabled(FolderPanel.this.getSelectedFolder() != null && FolderPanel.this.getSelectedFolder().isClosed());
                if (FolderPanel.this.getSelectedFolder() != null) {
                    FolderPanel.this.folderNameField.setText(FolderPanel.this.getSelectedFolder().getName());
                }
            }
        });
        this.add((Component)new JScrollPane(this.folderTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        this.folderNameField = new JTextField();
        this.folderNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FolderPanel.this.getRenameFolderAction().isEnabled()) {
                    FolderPanel.this.getRenameFolderAction().actionPerformed(e);
                } else if (FolderPanel.this.getAddFolderAction().isEnabled()) {
                    FolderPanel.this.getAddFolderAction().actionPerformed(e);
                }
            }
        });
        p.add((Component)this.folderNameField, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        JButton b = new JButton(this.getRenameFolderAction());
        b.setText(null);
        b.setMargin(new Insets(1, 1, 1, 1));
        p.add((Component)b, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        b = new JButton(this.getAddFolderAction());
        b.setText(null);
        b.setMargin(new Insets(1, 1, 1, 1));
        p.add((Component)b, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        b = new JButton(this.getCloseFolderAction());
        b.setText(null);
        b.setMargin(new Insets(1, 1, 1, 1));
        p.add((Component)b, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        b = new JButton(this.getReopenFolderAction());
        b.setText(null);
        b.setMargin(new Insets(1, 1, 1, 1));
        p.add((Component)b, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.foldingPanel = new FoldingPanel();
        this.foldingPanel.addFold(Messages.getString("FolderPanel.Edit"), p, true, false);
        this.add((Component)this.foldingPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public Folder getSelectedFolder() {
        return this.folderTree.getSelectedFolder();
    }

    private Action getAddFolderAction() {
        if (this.addFolderAction == null) {
            this.addFolderAction = new AbstractAction(Messages.getString("FolderPanel.Add"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_add)){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderPanel.this.folderTree.addFolder(FolderPanel.this.folderNameField.getText());
                }
            };
            this.addFolderAction.putValue("ShortDescription", Messages.getString("FolderPanel.Add.desc"));
        }
        return this.addFolderAction;
    }

    private Action getRenameFolderAction() {
        if (this.renameFolderAction == null) {
            this.renameFolderAction = new AbstractAction(Messages.getString("FolderPanel.Ren"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_rename)){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderPanel.this.getSelectedFolder().rename(FolderPanel.this.folderNameField.getText());
                }
            };
            this.renameFolderAction.putValue("ShortDescription", Messages.getString("FolderPanel.Ren.desc"));
        }
        return this.renameFolderAction;
    }

    private Action getCloseFolderAction() {
        if (this.closeFolderAction == null) {
            this.closeFolderAction = new AbstractAction(Messages.getString("FolderPanel.Close"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_delete)){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FolderPanel.this.getSelectedFolder().getOpenCount() == 0) {
                        FolderPanel.this.getSelectedFolder().setClosed(true);
                    }
                }
            };
            this.closeFolderAction.putValue("ShortDescription", Messages.getString("FolderPanel.Close.desc"));
        }
        return this.closeFolderAction;
    }

    private Action getReopenFolderAction() {
        if (this.reopenFolderAction == null) {
            this.reopenFolderAction = new AbstractAction(Messages.getString("FolderPanel.Reop"), ApplicationHelper.getIcon(ApplicationHelper.icon_name_large_undelete)){
                private static final long serialVersionUID = 0L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    FolderPanel.this.getSelectedFolder().setClosed(false);
                }
            };
            this.reopenFolderAction.putValue("ShortDescription", Messages.getString("FolderPanel.Reop.desc"));
        }
        return this.reopenFolderAction;
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        this.folderTree.setEngine(this.engine);
        engine.getGTDModel().addGTDModelListener(new GTDModelAdapter(){

            @Override
            public void elementModified(org.gtdfree.model.ActionEvent a) {
                if (a.getAction().getParent() == FolderPanel.this.getSelectedFolder() || FolderPanel.this.getSelectedFolder() != null && a.getAction().getProject() != null && FolderPanel.this.getSelectedFolder().getId() == a.getAction().getProject().intValue()) {
                    FolderPanel.this.getCloseFolderAction().setEnabled(FolderPanel.this.getSelectedFolder() != null && !FolderPanel.this.getSelectedFolder().isBuildIn() && FolderPanel.this.getSelectedFolder().getType() != Folder.FolderType.INBUCKET && FolderPanel.this.getSelectedFolder().getType() != Folder.FolderType.QUEUE && !FolderPanel.this.getSelectedFolder().isClosed() && FolderPanel.this.getSelectedFolder().getOpenCount() == 0);
                    FolderPanel.this.getReopenFolderAction().setEnabled(FolderPanel.this.getSelectedFolder() != null && FolderPanel.this.getSelectedFolder().isClosed());
                }
            }
        });
    }

    public void setDefaultFoldersVisible(boolean b) {
        this.folderTree.setDefaultFoldersVisible(b);
    }

    public boolean isDefaultFoldersVisible() {
        return this.folderTree.isDefaultFoldersVisible();
    }

    public void setShowClosedFolders(boolean b) {
        this.folderTree.setShowClosedFolders(b);
    }

    public boolean isShowClosedFolders() {
        return this.folderTree.isShowClosedFolders();
    }

    public void setExpendedNodes(int[] ii) {
        this.folderTree.setExpendedNodes(ii);
    }

    public int[] getExpendedNodes() {
        return this.folderTree.getExpendedNodes();
    }

    public boolean[] getFoldingStates() {
        return this.foldingPanel.getFoldingStates();
    }

    public void setFoldingStates(boolean[] b) {
        this.foldingPanel.setFoldingStates(b);
    }

    public void setSelectedFolder(Folder f) {
        this.folderTree.setSelectedFolder(f, -1);
    }

    public void setShowEmptyFolders(boolean b) {
        this.folderTree.setShowEmptyFolders(b);
    }

    public int getLastDroppedActionIndex() {
        return this.folderTree.getLastDroppedActionIndex();
    }
}

