/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.gtdfree.Messages;
import org.gtdfree.gui.FolderSelectionDialog;
import org.gtdfree.gui.SelectionModel;
import org.gtdfree.model.Folder;
import org.gtdfree.model.GTDModel;
import org.gtdfree.model.Project;

public class SelectionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int BORDER = 11;
    public static final int INDENT = 18;
    private SelectionModel selectionModel = new SelectionModel();
    private ButtonGroup folderButtonGroup;
    private JButton selectFoldersButton;
    private ButtonGroup projectButtonGroup;
    private JButton selectProjectsButton;
    private FolderSelectionDialog foldersSelectionDialog;
    private FolderSelectionDialog projectsSelectionDialog;
    private GTDModel gtdModel;
    private JLabel folderLabel1;
    private JLabel folderLabel2;
    private JLabel projectLabel1;
    private JLabel projectLabel2;
    private JCheckBox includeResolved;
    private JCheckBox includeDeleted;
    private JCheckBox skipEmptyFolders;
    private JCheckBox skipEmptyProjects;
    private JCheckBox skipWithoutProject;

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setContentPane(new SelectionPanel());
        f.pack();
        f.setVisible(true);
    }

    public static Border createCategoryBorder(final Color c) {
        Border border = new Border(){
            Insets i = new Insets(0, 0, 1, 0);
            Color color = c;

            @Override
            public void paintBorder(Component c2, Graphics g, int x, int y, int width, int height) {
                g.setColor(this.color);
                g.drawLine(0, height - 1, width - 1, height - 1);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public Insets getBorderInsets(Component c2) {
                return this.i;
            }
        };
        return border;
    }

    public SelectionPanel() {
        this.initialize();
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void initialize() {
        Border border = SelectionPanel.createCategoryBorder(this.getForeground());
        this.setLayout(new GridBagLayout());
        int row = 0;
        JLabel l = new JLabel(Messages.getString("SelectionPanel.Folder"));
        l.setFont(l.getFont().deriveFont(2));
        l.setBorder(border);
        this.add((Component)l, new GridBagConstraints(0, row, 2, 1, 0.0, 0.0, 13, 2, new Insets(11, 11, 2, 11), 0, 0));
        this.folderButtonGroup = new ButtonGroup();
        JRadioButton rb = new JRadioButton(Messages.getString("SelectionPanel.All"));
        this.folderButtonGroup.add(rb);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setFolderCriteria(SelectionModel.SelectionCriteria.ALL);
            }
        });
        this.add((Component)rb, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        rb = new JRadioButton(Messages.getString("SelectionPanel.Custom"));
        this.folderButtonGroup.add(rb);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setFolderCriteria(SelectionModel.SelectionCriteria.CUSTOM);
            }
        });
        this.add((Component)rb, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.selectFoldersButton = new JButton(Messages.getString("SelectionPanel.Select"));
        this.selectFoldersButton.setEnabled(false);
        this.selectFoldersButton.setPreferredSize(new Dimension(this.selectFoldersButton.getPreferredSize().width, rb.getPreferredSize().height));
        this.selectFoldersButton.setMinimumSize(this.selectFoldersButton.getPreferredSize());
        this.selectFoldersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Folder[] f = SelectionPanel.this.getFoldersSelectionDialog().showFolderSelectionDialog();
                SelectionPanel.this.getSelectionModel().setCustomFolders(f);
            }
        });
        this.getSelectionModel().addPropertyChangeListener("folderCriteria", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectionPanel.this.selectFoldersButton.setEnabled(SelectionPanel.this.getSelectionModel().getFolderCriteria() == SelectionModel.SelectionCriteria.CUSTOM);
            }
        });
        this.add((Component)this.selectFoldersButton, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 2, 11), 0, 0));
        this.skipEmptyFolders = new JCheckBox(Messages.getString("SelectionPanel.SkipEmpty"));
        this.skipEmptyFolders.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setIncludeEmptyFolders(!SelectionPanel.this.skipEmptyFolders.isSelected());
            }
        });
        this.skipEmptyFolders.setSelected(true);
        this.add((Component)this.skipEmptyFolders, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.folderLabel1 = new JLabel(Messages.getString("SelectionPanel.Selected"));
        this.folderLabel1.setFont(this.folderLabel1.getFont().deriveFont(9.0f).deriveFont(2));
        this.add((Component)this.folderLabel1, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 0, 11), 0, 0));
        this.folderLabel2 = new JLabel("...");
        this.folderLabel2.setFont(this.folderLabel1.getFont().deriveFont(9.0f).deriveFont(2));
        this.add((Component)this.folderLabel2, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 11, 4, 11), 0, 0));
        this.getSelectionModel().addPropertyChangeListener("selectedFolders", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectionPanel.this.updateFolderSelection();
            }
        });
        l = new JLabel(Messages.getString("SelectionPanel.Proj"));
        l.setFont(l.getFont().deriveFont(2));
        l.setBorder(border);
        this.add((Component)l, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(11, 11, 2, 11), 0, 0));
        this.projectButtonGroup = new ButtonGroup();
        rb = new JRadioButton(Messages.getString("SelectionPanel.All"));
        this.projectButtonGroup.add(rb);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setProjectCriteria(SelectionModel.SelectionCriteria.ALL);
            }
        });
        this.add((Component)rb, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        rb = new JRadioButton(Messages.getString("SelectionPanel.Custom"));
        this.projectButtonGroup.add(rb);
        rb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setProjectCriteria(SelectionModel.SelectionCriteria.CUSTOM);
            }
        });
        this.add((Component)rb, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.selectProjectsButton = new JButton(Messages.getString("SelectionPanel.Select"));
        this.selectProjectsButton.setEnabled(false);
        this.selectProjectsButton.setPreferredSize(new Dimension(this.selectProjectsButton.getPreferredSize().width, rb.getPreferredSize().height));
        this.selectProjectsButton.setMinimumSize(this.selectProjectsButton.getPreferredSize());
        this.selectProjectsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Folder[] f = SelectionPanel.this.getProjectsSelectionDialog().showFolderSelectionDialog();
                SelectionPanel.this.getSelectionModel().setCustomProjects(f);
            }
        });
        this.getSelectionModel().addPropertyChangeListener("projectCriteria", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectionPanel.this.selectProjectsButton.setEnabled(SelectionPanel.this.getSelectionModel().getProjectCriteria() == SelectionModel.SelectionCriteria.CUSTOM);
            }
        });
        this.add((Component)this.selectProjectsButton, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 2, 2, 11), 0, 0));
        this.skipWithoutProject = new JCheckBox(Messages.getString("SelectionPanel.SkipNoProj"));
        this.skipWithoutProject.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setIncludeWithoutProject(!SelectionPanel.this.skipWithoutProject.isSelected());
            }
        });
        this.skipWithoutProject.setSelected(true);
        this.add((Component)this.skipWithoutProject, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.skipEmptyProjects = new JCheckBox(Messages.getString("SelectionPanel.SkipEmptyProj"));
        this.skipEmptyProjects.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.getSelectionModel().setIncludeEmptyProjects(!SelectionPanel.this.skipEmptyProjects.isSelected());
            }
        });
        this.skipEmptyProjects.setSelected(true);
        this.add((Component)this.skipEmptyProjects, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.projectLabel1 = new JLabel(Messages.getString("SelectionPanel.Selected"));
        this.projectLabel1.setFont(this.folderLabel1.getFont().deriveFont(9.0f).deriveFont(2));
        this.add((Component)this.projectLabel1, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 0, 11), 0, 0));
        this.projectLabel2 = new JLabel("...");
        this.projectLabel2.setFont(this.folderLabel1.getFont().deriveFont(9.0f).deriveFont(2));
        this.add((Component)this.projectLabel2, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 11, 4, 11), 0, 0));
        this.getSelectionModel().addPropertyChangeListener("selectedProjects", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SelectionPanel.this.updateProjectSelection();
            }
        });
        l = new JLabel(Messages.getString("SelectionPanel.Act"));
        l.setFont(l.getFont().deriveFont(2));
        l.setBorder(border);
        this.add((Component)l, new GridBagConstraints(0, ++row, 2, 1, 0.0, 0.0, 13, 2, new Insets(11, 11, 2, 11), 0, 0));
        this.includeResolved = new JCheckBox(Messages.getString("SelectionPanel.Res"));
        this.includeResolved.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.selectionModel.setIncludeResolved(SelectionPanel.this.includeResolved.isSelected());
            }
        });
        this.add((Component)this.includeResolved, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 18, 2, 11), 0, 0));
        this.includeDeleted = new JCheckBox(Messages.getString("SelectionPanel.Del"));
        this.includeDeleted.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SelectionPanel.this.selectionModel.setIncludeDeleted(SelectionPanel.this.includeDeleted.isSelected());
            }
        });
        this.add((Component)this.includeDeleted, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 18, 11, 11), 0, 0));
        this.folderButtonGroup.setSelected(this.folderButtonGroup.getElements().nextElement().getModel(), true);
        this.projectButtonGroup.setSelected(this.projectButtonGroup.getElements().nextElement().getModel(), true);
    }

    protected FolderSelectionDialog getFoldersSelectionDialog() {
        if (this.foldersSelectionDialog == null) {
            this.foldersSelectionDialog = new FolderSelectionDialog(false);
            this.foldersSelectionDialog.setGtdModel(this.gtdModel);
            this.foldersSelectionDialog.setLocationRelativeTo(this);
        }
        return this.foldersSelectionDialog;
    }

    protected FolderSelectionDialog getProjectsSelectionDialog() {
        if (this.projectsSelectionDialog == null) {
            this.projectsSelectionDialog = new FolderSelectionDialog(true);
            this.projectsSelectionDialog.setGtdModel(this.gtdModel);
            this.projectsSelectionDialog.setLocationRelativeTo(this);
        }
        return this.projectsSelectionDialog;
    }

    public GTDModel getGtdModel() {
        return this.gtdModel;
    }

    public void setGtdModel(GTDModel gtdModel) {
        this.gtdModel = gtdModel;
        this.selectionModel.setGtdModel(gtdModel);
        if (this.foldersSelectionDialog != null) {
            this.foldersSelectionDialog.setGtdModel(gtdModel);
        }
        if (this.projectsSelectionDialog != null) {
            this.projectsSelectionDialog.setGtdModel(gtdModel);
        }
        this.updateFolderSelection();
        this.updateProjectSelection();
    }

    private void updateFolderSelection() {
        Iterator<Folder> i = this.getSelectionModel().selectedFolders();
        this.folderLabel1.setText(Messages.getString("SelectionPanel.Selected") + " " + this.getSelectionModel().getSelectedFoldersCount() + " " + Messages.getString("SelectionPanel.folders"));
        StringBuilder sb = new StringBuilder();
        if (i.hasNext()) {
            sb.append(i.next().getName());
        }
        while (i.hasNext()) {
            sb.append(", ");
            sb.append(i.next().getName());
        }
        if (sb.length() == 0) {
            this.folderLabel2.setText(" ");
            this.folderLabel2.setToolTipText("");
        } else {
            this.folderLabel2.setText(sb.toString());
            this.folderLabel2.setToolTipText(sb.toString());
        }
    }

    private void updateProjectSelection() {
        Iterator<Project> i = this.getSelectionModel().selectedProjects();
        this.projectLabel1.setText(Messages.getString("SelectionPanel.Selected") + " " + this.getSelectionModel().getSelectedProjectsCount() + " " + Messages.getString("SelectionPanel.projects"));
        StringBuilder sb = new StringBuilder();
        if (i.hasNext()) {
            sb.append(i.next().getName());
        }
        while (i.hasNext()) {
            sb.append(", ");
            sb.append(i.next().getName());
        }
        if (sb.length() == 0) {
            this.projectLabel2.setText(" ");
            this.projectLabel2.setToolTipText("");
        } else {
            this.projectLabel2.setText(sb.toString());
            this.projectLabel2.setToolTipText(sb.toString());
        }
    }
}

