/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.html;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gtdfree.html.Attribute;

public final class TAG
implements Cloneable,
Iterable<Attribute> {
    public static final TAG DIV = new TAG("DIV");
    public static final TAG TR = new TAG("TR");
    public static final TAG TD = new TAG("TD");
    public static final TAG TH = new TAG("TH");
    public static final TAG A = new TAG("A");
    public static final TAG BR = new TAG("BR");
    public static final TAG TABLE = new TAG("TABLE");
    public static final TAG STRONG = new TAG("STRONG");
    public static final TAG P = new TAG("P");
    public static final TAG H1 = new TAG("H1");
    public static final TAG H2 = new TAG("H2");
    public static final TAG H3 = new TAG("H3");
    public static final TAG H4 = new TAG("H4");
    public static final TAG HTML = new TAG("HTML");
    public static final TAG BODY = new TAG("BODY");
    public static final TAG SPAN = new TAG("SPAN");
    public static final TAG STYLE = new TAG("STYLE").withAttribute(Attribute.TYPE, "text/css");
    private String name;
    private HashMap<Attribute, String> attributes;

    public static TAG withName(String name) {
        return new TAG(name);
    }

    private TAG(String name) {
        this.name = name;
    }

    private Map<Attribute, String> getAttr() {
        if (this.attributes == null) {
            this.attributes = new HashMap(10);
        }
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public String getCLASS() {
        return this.getAttr().get((Object)Attribute.CLASS);
    }

    public String getID() {
        return this.getAttr().get((Object)Attribute.ID);
    }

    private TAG copy() {
        try {
            return (TAG)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public TAG withAttribute(Attribute a, String val) {
        TAG t = this.copy();
        t.getAttr().put(a, val);
        return t;
    }

    public TAG withClass(String val) {
        return this.withAttribute(Attribute.CLASS, val);
    }

    public TAG withROWSPAN(int val) {
        return this.withAttribute(Attribute.ROWSPAN, String.valueOf(val));
    }

    public TAG withCOLSPAN(int val) {
        return this.withAttribute(Attribute.COLSPAN, String.valueOf(val));
    }

    @Override
    public Iterator<Attribute> iterator() {
        if (this.attributes != null) {
            return this.attributes.keySet().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public String getAttribute(Attribute a) {
        if (this.attributes != null) {
            return this.attributes.get((Object)a);
        }
        return null;
    }

    public TAG withHREF(URL url) {
        return this.withAttribute(Attribute.HREF, url.toString());
    }

    public int getAttributeCount() {
        if (this.attributes == null) {
            return 0;
        }
        return this.attributes.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(8);
        this.printTag(sb);
        return sb.toString();
    }

    public void printTag(StringBuilder sb) {
        sb.append('<');
        sb.append(this.name);
        for (Attribute att : this) {
            sb.append(' ');
            sb.append(att.name());
            sb.append('=');
            sb.append('\"');
            sb.append(this.getAttribute(att));
            sb.append('\"');
        }
        sb.append('>');
    }

    public void printTagEnd(StringBuilder sb) {
        sb.append('<');
        sb.append('/');
        sb.append(this.name);
        sb.append('>');
    }
}

