/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.model;

import org.gtdfree.model.Action;
import org.gtdfree.model.ActionFilter;
import org.gtdfree.model.Folder;
import org.gtdfree.model.Priority;

public final class PriorityFilter
implements ActionFilter {
    private Priority priority;
    private boolean exactMatch;

    public PriorityFilter(Priority priority, boolean exactMatch) {
        this.exactMatch = exactMatch;
        this.priority = priority;
    }

    @Override
    public boolean isAcceptable(Folder f, Action a) {
        if (this.exactMatch) {
            return this.priority == a.getPriority();
        }
        return this.priority.ordinal() <= a.getPriority().ordinal();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PriorityFilter) {
            PriorityFilter f = (PriorityFilter)obj;
            return f.exactMatch == this.exactMatch && f.priority == this.priority;
        }
        return false;
    }
}

