/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree;

import java.util.ArrayList;
import java.util.List;
import org.neodatis.odb.core.IError;
import org.neodatis.tool.wrappers.OdbString;

public class BTreeError
implements IError {
    private int code;
    private String description;
    private List parameters;
    public static final BTreeError MERGE_WITH_TWO_MORE_KEYS = new BTreeError(500, "Trying to merge two node with more keys than allowed! @1 // @2");
    public static final BTreeError LAZY_LOADING_NODE = new BTreeError(501, "Error while loading node lazily with oid @1");
    public static final BTreeError NODE_WITHOUT_ID = new BTreeError(502, "Node with id -1");
    public static final BTreeError NULL_PERSISTER_FOUND = new BTreeError(503, "Null persister for PersistentBTree");
    public static final BTreeError INVALID_ID_FOR_BTREE = new BTreeError(504, "Invalid id for Btree : id=@1");
    public static final BTreeError INVALID_NODE_TYPE = new BTreeError(505, "Node should be a PersistentNode but is a @1");
    public static final BTreeError INTERNAL_ERROR = new BTreeError(506, "Internal error: @1");

    public BTreeError(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public IError addParameter(Object o) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(o != null ? o.toString() : "null");
        return this;
    }

    public IError addParameter(String s) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(s);
        return this;
    }

    public IError addParameter(int i) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(new Integer(i));
        return this;
    }

    public IError addParameter(byte i) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(new Byte(i));
        return this;
    }

    public IError addParameter(long l) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(new Long(l));
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.code).append(":").append(this.description);
        String s = buffer.toString();
        if (this.parameters != null) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                String parameterName = "@" + (i + 1);
                String parameterValue = this.parameters.get(i).toString();
                int parameterIndex = s.indexOf(parameterName);
                if (parameterIndex == -1) continue;
                s = OdbString.replaceToken(s, parameterName, parameterValue, 1);
            }
        }
        return s;
    }
}

