/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.io.Serializable;
import org.neodatis.odb.OID;
import org.neodatis.tool.wrappers.OdbTime;

public class ObjectInfoHeader
implements Serializable {
    private long position;
    private OID previousObjectOID;
    private OID nextObjectOID;
    private OID classInfoId;
    private long[] attributesIdentification;
    private int[] attributeIds;
    private OID oid;
    private long creationDate;
    private long updateDate;
    private int objectVersion;

    public ObjectInfoHeader(long position, OID previousObjectOID, OID nextObjectOID, OID classInfoId, long[] attributesIdentification, int[] attributeIds) {
        this.position = position;
        this.oid = null;
        this.previousObjectOID = previousObjectOID;
        this.nextObjectOID = nextObjectOID;
        this.classInfoId = classInfoId;
        this.attributesIdentification = attributesIdentification;
        this.attributeIds = attributeIds;
        this.objectVersion = 1;
        this.creationDate = OdbTime.getCurrentTimeInMs();
    }

    public ObjectInfoHeader() {
        this.position = -1L;
        this.oid = null;
        this.objectVersion = 1;
        this.creationDate = OdbTime.getCurrentTimeInMs();
    }

    public int getNbAttributes() {
        return this.attributesIdentification.length;
    }

    public OID getNextObjectOID() {
        return this.nextObjectOID;
    }

    public void setNextObjectOID(OID nextObjectOID) {
        this.nextObjectOID = nextObjectOID;
    }

    public long getPosition() {
        return this.position;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public OID getPreviousObjectOID() {
        return this.previousObjectOID;
    }

    public void setPreviousObjectOID(OID previousObjectOID) {
        this.previousObjectOID = previousObjectOID;
    }

    public OID getClassInfoId() {
        return this.classInfoId;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("oid=").append(this.oid).append(" - ");
        buffer.append(" - position=").append(this.position).append(" | prev=").append(this.previousObjectOID);
        buffer.append(" | next=").append(this.nextObjectOID);
        buffer.append(" attrs =[");
        if (this.attributesIdentification != null) {
            for (int i = 0; i < this.attributesIdentification.length; ++i) {
                buffer.append(this.attributesIdentification[i]).append(" ");
            }
        } else {
            buffer.append(" nulls ");
        }
        buffer.append(" ]");
        return buffer.toString();
    }

    public long[] getAttributesIdentification() {
        return this.attributesIdentification;
    }

    public void setAttributesIdentification(long[] attributesIdentification) {
        this.attributesIdentification = attributesIdentification;
    }

    public OID getOid() {
        return this.oid;
    }

    public void setOid(OID oid) {
        this.oid = oid;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(long updateDate) {
        this.updateDate = updateDate;
    }

    public long getAttributeIdentificationFromId(int attributeId) {
        if (this.attributeIds == null) {
            return 0L;
        }
        for (int i = 0; i < this.attributeIds.length; ++i) {
            if (this.attributeIds[i] != attributeId) continue;
            return this.attributesIdentification[i];
        }
        return 0L;
    }

    public long getAttributeId(int attributeIndex) {
        return this.attributeIds[attributeIndex];
    }

    public void setAttributesIds(int[] ids) {
        this.attributeIds = ids;
    }

    public int[] getAttributeIds() {
        return this.attributeIds;
    }

    public void setClassInfoId(OID classInfoId2) {
        this.classInfoId = classInfoId2;
    }

    public int getObjectVersion() {
        return this.objectVersion;
    }

    public void setObjectVersion(int objectVersion) {
        this.objectVersion = objectVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.position ^ this.position >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectInfoHeader other = (ObjectInfoHeader)obj;
        return this.position == other.position;
    }

    public void incrementVersionAndUpdateDate() {
        ++this.objectVersion;
        this.updateDate = OdbTime.getCurrentTimeInMs();
    }

    public ObjectInfoHeader duplicate() {
        ObjectInfoHeader oih = new ObjectInfoHeader();
        oih.setAttributesIdentification(this.attributesIdentification);
        oih.setAttributesIds(this.attributeIds);
        oih.setClassInfoId(this.classInfoId);
        oih.setCreationDate(this.creationDate);
        oih.setNextObjectOID(this.nextObjectOID);
        oih.setObjectVersion(this.objectVersion);
        oih.setOid(this.oid);
        oih.setPosition(this.position);
        oih.setPreviousObjectOID(this.previousObjectOID);
        oih.setUpdateDate(this.updateDate);
        return oih;
    }
}

