/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.nq;

import java.lang.reflect.Method;
import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.nq.NativeQuery;
import org.neodatis.odb.core.query.nq.SimpleNativeQuery;
import org.neodatis.tool.wrappers.OdbReflection;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class NativeQueryManager {
    private static String MATCH_METHOD_NAME = "match";
    private Map<IQuery, Method> methodsCache = new OdbHashMap<IQuery, Method>();

    public String getFullClassName(IQuery query) {
        if (query instanceof NativeQuery) {
            return this.getFullClassName((NativeQuery)query);
        }
        return this.getFullClassName((SimpleNativeQuery)query);
    }

    protected String getFullClassName(NativeQuery query) {
        return query.getObjectType().getName();
    }

    protected String getFullClassName(SimpleNativeQuery query) {
        Class clazz = null;
        Method[] methods = OdbReflection.getMethods(query.getClass());
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            Class[] attributes = OdbReflection.getAttributeTypes(method);
            if (!method.getName().equals(MATCH_METHOD_NAME) || attributes.length != 1) continue;
            clazz = attributes[0];
            method.setAccessible(true);
            this.methodsCache.put(query, method);
            return clazz.getName();
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_NQ_MATCH_METHOD_NOT_IMPLEMENTED.addParameter(query.getClass().getName()));
    }

    protected boolean match(IQuery query, Object object) {
        if (query instanceof NativeQuery) {
            return this.match((NativeQuery)query, object);
        }
        return this.match((SimpleNativeQuery)query, object);
    }

    protected boolean match(NativeQuery query, Object object) {
        return query.match(object);
    }

    protected boolean match(SimpleNativeQuery query, Object object) {
        Object result;
        Method method = this.methodsCache.get(query);
        Object[] params = new Object[]{object};
        try {
            result = method.invoke((Object)query, params);
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.QUERY_NQ_EXCEPTION_RAISED_BY_NATIVE_QUERY_EXECUTION.addParameter(query.getClass().getName()), (Throwable)e);
        }
        return (Boolean)result;
    }
}

