/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.values;

import java.math.BigDecimal;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.execution.IQueryFieldAction;
import org.neodatis.odb.core.query.values.AbstractQueryFieldAction;
import org.neodatis.odb.impl.core.query.values.ValuesUtil;

public class MaxValueAction
extends AbstractQueryFieldAction {
    private BigDecimal maxValue = new BigDecimal(Long.MIN_VALUE);
    private OID oidOfMaxValues = null;

    public MaxValueAction(String attributeName, String alias) {
        super(attributeName, alias, false);
    }

    public void execute(OID oid, AttributeValuesMap values) {
        Number n = (Number)values.get(this.attributeName);
        BigDecimal bd = ValuesUtil.convert(n);
        if (bd.compareTo(this.maxValue) > 0) {
            this.oidOfMaxValues = oid;
            this.maxValue = bd;
        }
    }

    public Object getValue() {
        return this.maxValue;
    }

    public void end() {
    }

    public void start() {
    }

    public OID getOidOfMaxValues() {
        return this.oidOfMaxValues;
    }

    public IQueryFieldAction copy() {
        return new MaxValueAction(this.attributeName, this.alias);
    }
}

