/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.server.trigger;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectRepresentation;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.impl.core.layers.layer1.introspector.DefaultInstrumentationCallback;
import org.neodatis.odb.impl.core.server.trigger.ChangedValueNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectRepresentation
extends Observable
implements ObjectRepresentation {
    private final NonNativeObjectInfo nnoi;
    private Map<String, Object> changedValues;

    public DefaultObjectRepresentation(NonNativeObjectInfo nnoi) {
        this.nnoi = nnoi;
        this.changedValues = new HashMap<String, Object>();
    }

    @Override
    public Object getValueOf(String attributeName) {
        if (this.nnoi.isNull()) {
            throw new ODBRuntimeException(NeoDatisError.TRIGGER_CALLED_ON_NULL_OBJECT.addParameter(this.nnoi.getClassInfo().getFullClassName()).addParameter(attributeName));
        }
        AbstractObjectInfo aoi = this.nnoi.getMetaValueOf(attributeName);
        if (aoi == null || aoi.isNull()) {
            return null;
        }
        if (aoi.isAtomicNativeObject()) {
            return aoi.getObject();
        }
        if (aoi.isNonNativeObject()) {
            return new DefaultObjectRepresentation((NonNativeObjectInfo)aoi);
        }
        throw new ODBRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("getValueOf for " + aoi.getOdbType().getName()));
    }

    @Override
    public void setValueOf(String attributeName, Object value) {
        IObjectIntrospector introspector = OdbConfiguration.getCoreProvider().getLocalObjectIntrospector(null);
        AbstractObjectInfo aoi = introspector.getMetaRepresentation(value, null, true, null, new DefaultInstrumentationCallback());
        this.nnoi.setValueOf(attributeName, aoi);
        this.changedValues.put(attributeName, value);
        this.setChanged();
        this.notifyObservers(new ChangedValueNotification(this.nnoi, this.nnoi.getOid(), attributeName, value));
    }

    @Override
    public OID getOid() {
        return this.nnoi.getOid();
    }

    @Override
    public String getObjectClassName() {
        return this.nnoi.getClassInfo().getFullClassName();
    }

    public final NonNativeObjectInfo getNnoi() {
        return this.nnoi;
    }

    public Map<String, Object> getChangedValues() {
        return this.changedValues;
    }
}

