/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.xml.tool;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.xml.tool.NodeEventListener;
import org.neodatis.odb.xml.tool.XMLNode;
import org.neodatis.tool.wrappers.io.OdbFile;

public class XMLGenerator {
    private static List<NodeEventListener> listeners = new ArrayList<NodeEventListener>();
    private static String incrementalFileName;
    private static boolean writeIncremental;
    private static Writer incrementalWriter;
    private static boolean firstNode;

    public static void addListener(NodeEventListener listener) {
        listeners.add(listener);
    }

    public static void setIncrementalWriteOn(String fileName) throws IOException {
        incrementalFileName = fileName;
        writeIncremental = true;
        incrementalWriter = XMLGenerator.getWriter(fileName);
    }

    public static void end() throws IOException {
        if (writeIncremental && incrementalWriter != null) {
            incrementalWriter.close();
        }
    }

    public static XMLNode createRoot(String name) {
        XMLNode node = new XMLNode(name, true);
        XMLGenerator.startOfDocument(name);
        return node;
    }

    public static void startOfDocument(String name) {
        NodeEventListener listener = null;
        if (writeIncremental) {
            try {
                incrementalWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
                incrementalWriter.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ODBRuntimeException((IError)NeoDatisError.XML_HEADER, (Throwable)e);
            }
        }
        for (int i = 0; i < listeners.size(); ++i) {
            listener = listeners.get(i);
            listener.startOfDocument();
        }
    }

    public static void endOfDocument(String name) {
        NodeEventListener listener = null;
        for (int i = 0; i < listeners.size(); ++i) {
            listener = listeners.get(i);
            listener.endOfDocument();
        }
    }

    public static void startOfNode(String name, XMLNode node) {
        NodeEventListener listener = null;
        for (int i = 0; i < listeners.size(); ++i) {
            listener = listeners.get(i);
            listener.startOfNode(name, node);
        }
        if (writeIncremental) {
            try {
                XMLGenerator.writeIncrementalNodeHeader(node, false);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean endOfNode(String name, XMLNode node) {
        NodeEventListener listener = null;
        for (int i = 0; i < listeners.size(); ++i) {
            listener = listeners.get(i);
            listener.endOfNode(name, node);
        }
        if (writeIncremental) {
            try {
                if (!node.headerHasBeenWritten && !node.hasChildren()) {
                    XMLGenerator.writeIncrementalNodeHeader(node, true);
                    return true;
                }
                XMLGenerator.writeIncrementalNodeFooter(node);
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private static void writeIncrementalNodeHeader(XMLNode node, boolean closeTag) throws IOException {
        incrementalWriter.write(node.headerToString(closeTag));
        incrementalWriter.flush();
    }

    private static void writeIncrementalNodeFooter(XMLNode node) throws IOException {
        incrementalWriter.write(node.footerToString());
        incrementalWriter.flush();
    }

    public static void writeNodeToFile(XMLNode node, String fileName) throws IOException {
        Writer writer = XMLGenerator.getWriter(fileName);
        writer.write(node.toString());
        writer.close();
    }

    private static Writer getWriter(String fileName) throws IOException {
        OdbFile f = new OdbFile(fileName);
        if (!f.exists() && f.getParentFile() != null) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream out = new FileOutputStream(fileName);
        OutputStreamWriter writer = null;
        writer = OdbConfiguration.hasEncoding() ? new OutputStreamWriter((OutputStream)out, OdbConfiguration.getDatabaseCharacterEncoding()) : new OutputStreamWriter(out);
        return writer;
    }

    public static void close() throws IOException {
        if (incrementalWriter != null) {
            incrementalWriter.close();
        }
    }

    static {
        firstNode = true;
    }
}

