/*
 * Decompiled with CFR 0.152.
 */
package org.infoml.infocardOrganizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;
import org.infoml.infocardOrganizer.MainFrame;

public class AncestorDialog
extends JDialog
implements WindowListener,
KeyListener,
ContainerListener {
    public UndoManager ownUndoManager;
    public OwnUndoableEditListener ownUndoListener;
    MainFrame mainFr;
    Vector focusableComponents;
    int index = 0;
    int size;
    static int viewableInstances = 0;

    public AncestorDialog(Frame owner, String title, MainFrame mainFr) {
        super(owner, title);
        ++viewableInstances;
        this.focusableComponents = new Vector();
        this.mainFr = mainFr;
        this.addWindowListener(this);
        this.ownUndoListener = new OwnUndoableEditListener();
        this.ownUndoManager = new UndoManager();
        this.addKeyAndContainerListenerToAllChildren(this);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.mainFr.focusedDialog = this;
        this.mainFr.undoAction.updateUndoState();
        this.mainFr.redoAction.updateRedoState();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.mainFr.focusedDialog = null;
        this.ownUndoManager.die();
        --viewableInstances;
        this.mainFr.undoAction.updateUndoState();
        this.mainFr.redoAction.updateRedoState();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 90 && this.mainFr.undoAction.isEnabled()) {
            this.mainFr.performUndo();
        }
        if (e.getKeyCode() == 89 && this.mainFr.redoAction.isEnabled()) {
            this.mainFr.performRedo();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
            this.mainFr.undoAction.setEnabled(false);
            this.mainFr.redoAction.setEnabled(false);
            --viewableInstances;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public void addKeyAndContainerListenerToAllChildren(Component comp) {
        comp.addKeyListener(this);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerToAllChildren(children[i]);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerToAllChildren(e.getChild());
    }

    public void removeKeyAndContainerListenerFromAllChildren(Component comp) {
        comp.removeKeyListener(this);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerFromAllChildren(children[i]);
            }
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerFromAllChildren(e.getChild());
    }

    public boolean checkEmpty() {
        Component[] list = this.getContentPane().getComponents();
        for (int i = 0; i < list.length; ++i) {
            JTextComponent current;
            if (!(list[i] instanceof JTextComponent) || (current = (JTextComponent)list[i]).getDocument().getLength() == 0) continue;
            return false;
        }
        return true;
    }

    protected class OwnUndoableEditListener
    implements UndoableEditListener {
        protected OwnUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            AncestorDialog.this.ownUndoManager.addEdit(e.getEdit());
            AncestorDialog.this.mainFr.undoAction.updateUndoState();
            AncestorDialog.this.mainFr.redoAction.updateRedoState();
        }
    }
}

