/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.html.internal.dom;

import com.sun.org.apache.html.internal.dom.HTMLDocumentImpl;
import com.sun.org.apache.html.internal.dom.HTMLElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLTableCellElement;
import org.w3c.dom.html.HTMLTableRowElement;

public class HTMLTableCellElementImpl
extends HTMLElementImpl
implements HTMLTableCellElement {
    public int getCellIndex() {
        Node parent = this.getParentNode();
        int index = 0;
        if (parent instanceof HTMLTableRowElement) {
            Node child = parent.getFirstChild();
            while (child != null) {
                if (child instanceof HTMLTableCellElement) {
                    if (child == this) {
                        return index;
                    }
                    ++index;
                }
                child = child.getNextSibling();
            }
        }
        return -1;
    }

    public void setCellIndex(int cellIndex) {
        Node parent = this.getParentNode();
        if (parent instanceof HTMLTableRowElement) {
            Node child = parent.getFirstChild();
            while (child != null) {
                if (child instanceof HTMLTableCellElement) {
                    if (cellIndex == 0) {
                        if (this != child) {
                            parent.insertBefore(this, child);
                        }
                        return;
                    }
                    --cellIndex;
                }
                child = child.getNextSibling();
            }
        }
        parent.appendChild(this);
    }

    public String getAbbr() {
        return this.getAttribute("abbr");
    }

    public void setAbbr(String abbr) {
        this.setAttribute("abbr", abbr);
    }

    public String getAlign() {
        return this.capitalize(this.getAttribute("align"));
    }

    public void setAlign(String align) {
        this.setAttribute("align", align);
    }

    public String getAxis() {
        return this.getAttribute("axis");
    }

    public void setAxis(String axis) {
        this.setAttribute("axis", axis);
    }

    public String getBgColor() {
        return this.getAttribute("bgcolor");
    }

    public void setBgColor(String bgColor) {
        this.setAttribute("bgcolor", bgColor);
    }

    public String getCh() {
        String ch = this.getAttribute("char");
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        return ch;
    }

    public void setCh(String ch) {
        if (ch != null && ch.length() > 1) {
            ch = ch.substring(0, 1);
        }
        this.setAttribute("char", ch);
    }

    public String getChOff() {
        return this.getAttribute("charoff");
    }

    public void setChOff(String chOff) {
        this.setAttribute("charoff", chOff);
    }

    public int getColSpan() {
        return this.getInteger(this.getAttribute("colspan"));
    }

    public void setColSpan(int colspan) {
        this.setAttribute("colspan", String.valueOf(colspan));
    }

    public String getHeaders() {
        return this.getAttribute("headers");
    }

    public void setHeaders(String headers) {
        this.setAttribute("headers", headers);
    }

    public String getHeight() {
        return this.getAttribute("height");
    }

    public void setHeight(String height) {
        this.setAttribute("height", height);
    }

    public boolean getNoWrap() {
        return this.getBinary("nowrap");
    }

    public void setNoWrap(boolean noWrap) {
        this.setAttribute("nowrap", noWrap);
    }

    public int getRowSpan() {
        return this.getInteger(this.getAttribute("rowspan"));
    }

    public void setRowSpan(int rowspan) {
        this.setAttribute("rowspan", String.valueOf(rowspan));
    }

    public String getScope() {
        return this.getAttribute("scope");
    }

    public void setScope(String scope) {
        this.setAttribute("scope", scope);
    }

    public String getVAlign() {
        return this.capitalize(this.getAttribute("valign"));
    }

    public void setVAlign(String vAlign) {
        this.setAttribute("valign", vAlign);
    }

    public String getWidth() {
        return this.getAttribute("width");
    }

    public void setWidth(String width) {
        this.setAttribute("width", width);
    }

    public HTMLTableCellElementImpl(HTMLDocumentImpl owner, String name) {
        super(owner, name);
    }
}

