/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 * 
 * You can obtain a copy of the license at
 * https://jwsdp.dev.java.net/CDDLv1.0.html
 * See the License for the specific language governing
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * https://jwsdp.dev.java.net/CDDLv1.0.html  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 */
 
import java.io.FileInputStream;
import java.io.IOException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

// import java content classes generated by binding compiler
import org.example.*;
import extend.TravelTypeExtend;

/*
 * $Id: Main.java,v 1.1 2008/11/03 06:51:21 greggw Exp $
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
 
public class Main {
    // This sample application demonstrates how to modify a java content
    // tree and marshal it back to a xml data
    
    public static void main( String[] args ) {
	final boolean enlightened = true;

        try {
            // create a JAXBContext capable of handling classes generated into
            // the org.example package
            JAXBContext jc = JAXBContext.newInstance( "org.example" );
            
            // create an Unmarshaller
            Unmarshaller u = jc.createUnmarshaller();
            
            // unmarshal a po instance document into a tree of Java content
            // objects composed of classes from the primer.po package.
            Itinerary it = 
                (Itinerary)u.unmarshal( new FileInputStream( "itinerary.xml" ) );

            ObjectFactory of = new ObjectFactory();
	    java.util.Iterator iter = it.getTravel().listIterator();

            if (enlightened) {
	      System.out.println("Process references using polymorphic method");
            } else {
	      System.out.println("Process references using forest of if-then-else :(");
            }
	    for(int i=1; iter.hasNext(); i++) {
	        // Travel Entry Header
 	        System.out.println("****************************");
		System.out.println("[" + i + "]");

	        // Process travel entry
   	        TravelType travel = (TravelType)iter.next();
	        if (enlightened) {
	          ((TravelTypeExtend)travel).printTravelSummary();

                  Marshaller m = jc.createMarshaller();
                  m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
                  m.marshal( travel, System.out );
	         
                } else {
		  // Proceed down the forest of Ifs-then-elses.
  	          System.out.println("Origin=" + travel.getOrigin());
	          System.out.println("Destination=" + travel.getDestination());
		  if (travel instanceof Plane) {
	             Plane planet= (Plane)travel;
	             System.out.println("Flight Number: " + 
					 planet.getFlightNumber());
	             System.out.println("Meal: " + planet.getMeal());

                  } else if (travel instanceof Auto) {
	             Auto auto= (Auto)travel;
	             System.out.println("Rental Agency:" + auto.getRentalAgency());
   	             System.out.println("Rate Per Hour:" + auto.getRatePerHour());
                  } else if (travel instanceof Train) {
	             Train train= (Train)travel;
                     System.out.println("Track: " + train.getTrack());
                     System.out.println("Schedule# " + 
				train.getDailyScheduleNumber());
                  }
               }
              // Travel Entry footer
              System.out.println("****************************");
	      System.out.println();
            }

            // create a Marshaller and marshal to a file
            Marshaller m = jc.createMarshaller();
            m.setProperty( Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE );
            m.marshal( it, System.out );
            
        } catch( JAXBException je ) {
            je.printStackTrace();
        } catch( IOException ioe ) {
            ioe.printStackTrace();
        }
    }
}
