/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.ColorMapping;
import org.jpedal.color.ColorspaceDecoder;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.PdfPaint;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class SeparationColorSpace
extends GenericColorSpace {
    protected GenericColorSpace altCS;
    protected ColorMapping colorMapper;
    private float[] domain;

    public SeparationColorSpace() {
    }

    public SeparationColorSpace(PdfObjectReader pdfObjectReader, String string, Map map) {
        this.value = 10;
        this.processColorToken(pdfObjectReader, string, map);
    }

    protected void processColorToken(PdfObjectReader pdfObjectReader, String string, Map map) {
        int n;
        String string2 = "";
        String string3 = "";
        Map map2 = new Hashtable();
        Map map3 = new Hashtable();
        byte[] byArray = null;
        float[] fArray = null;
        this.domain = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() > 3) {
            Object object;
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("/Indexed")) {
                string4 = stringTokenizer.nextToken();
            }
            if (this.value == 10) {
                this.pantoneName = stringTokenizer.nextToken().substring(1);
                this.componentCount = 1;
            } else {
                object = stringTokenizer.nextToken();
                this.componentCount = 0;
                while (true) {
                    int n2 = n = ((String)(object = stringTokenizer.nextToken())).length() > 1 && ((String)object).endsWith("]") ? 1 : 0;
                    if (n != 0) {
                        ++this.componentCount;
                    }
                    if (((String)object).equals("]") || n != 0) break;
                    ++this.componentCount;
                }
            }
            string2 = stringTokenizer.nextToken();
            if (string2.equals("[")) {
                while (string2.indexOf(93) == -1) {
                    string2 = string2 + ' ' + stringTokenizer.nextToken();
                }
            }
            string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                if (string3.equals("0")) {
                    string2 = string2 + " 0 R";
                    map2 = pdfObjectReader.readObject(string2, false, null);
                    string3 = "";
                    stringTokenizer.nextToken();
                } else {
                    string3 = string3 + ' ';
                }
                if (this.value == 10) {
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = string3 + stringTokenizer.nextToken() + ' ';
                    }
                } else {
                    while (stringTokenizer.hasMoreTokens()) {
                        object = stringTokenizer.nextToken();
                        string3 = string3 + (String)object + ' ';
                        if (!(((String)object).equals("R") | ((String)object).equals("<<"))) continue;
                        break;
                    }
                }
                if ((string3 = string3.trim()).length() == 0) {
                    map3 = map;
                }
                if (string3.endsWith("R")) {
                    map3 = pdfObjectReader.readObject(string3, false, null);
                }
                if (string2.endsWith("R")) {
                    object = pdfObjectReader.readObject(string2, false, null);
                    string2 = (String)object.get("rawValue");
                }
            }
            byArray = pdfObjectReader.readStream(string3, true);
        } else {
            this.pantoneName = string.substring(11).trim();
            int n3 = this.pantoneName.indexOf(82);
            if (this.pantoneName.startsWith("/")) {
                this.pantoneName = this.pantoneName.substring(1);
                int n4 = this.pantoneName.indexOf(47);
                if (n4 != -1) {
                    string2 = this.pantoneName.substring(n4).trim();
                    this.pantoneName = this.pantoneName.substring(0, n4).trim();
                }
            } else if (n3 != -1) {
                string2 = this.pantoneName.substring(n3 + 1).trim();
                this.pantoneName = pdfObjectReader.getValue(this.pantoneName.substring(0, n3));
                if (string2.endsWith("R")) {
                    string2 = pdfObjectReader.getValue(string2);
                }
            }
            if (string2.length() == 0) {
                Iterator iterator = map.keySet().iterator();
                string2 = "";
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (string5.equals("rawValue")) continue;
                    string2 = string2 + string5;
                }
            }
            if (map != null) {
                map3 = (Map)map.get(string2);
            }
            if (map3 == null) {
                map3 = map;
            }
        }
        this.altCS = ColorspaceDecoder.getColorSpaceInstance(false, null, string2, map2, pdfObjectReader);
        if (this.pantoneName != null && this.pantoneName.indexOf(35) != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = this.pantoneName.length();
            for (n = 0; n < n5; ++n) {
                char c = this.pantoneName.charAt(n);
                if (c == '#') {
                    String string6 = this.pantoneName.substring(n + 1, n + 3);
                    stringBuffer.append((char)Integer.parseInt(string6, 16));
                    n += 2;
                    continue;
                }
                stringBuffer.append(c);
            }
            this.pantoneName = stringBuffer.toString();
        }
        this.colorMapper = new ColorMapping(pdfObjectReader, map3, byArray, fArray);
        this.domain = this.colorMapper.getDomain();
    }

    private void setColor(float f) {
        try {
            int n = 1;
            if (this.domain != null) {
                n = this.domain.length / 2;
            }
            float[] fArray = new float[n];
            for (int i = 0; i < n; ++i) {
                fArray[i] = f;
            }
            String[] stringArray = this.colorMapper.getOperand(fArray);
            if (stringArray.length == 4) {
                String[] stringArray2 = stringArray;
                for (int i = 1; i < 4; ++i) {
                    if (!stringArray[i].equals("0.0")) {
                        stringArray = stringArray2;
                        break;
                    }
                    stringArray[i] = stringArray[0];
                }
            }
            this.altCS.setColor(stringArray, stringArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setColor(String[] stringArray, int n) {
        this.setColor(Float.parseFloat(stringArray[0]));
    }

    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, String string) {
        BufferedImage bufferedImage = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ImageReader imageReader = null;
        ImageInputStream imageInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
            imageReader.setInput(imageInputStream, true);
            Raster raster = imageReader.readRaster(0, null);
            int n3 = raster.getWidth();
            int n4 = raster.getHeight();
            DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
            bufferedImage = this.createImage(n3, n4, dataBufferByte.getData());
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
        }
        try {
            byteArrayInputStream.close();
            imageReader.dispose();
            imageInputStream.close();
        }
        catch (Exception exception) {
            LogWriter.writeLog("Problem closing  " + exception);
        }
        return bufferedImage;
    }

    public BufferedImage dataToRGB(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.createImage(n, n2, byArray);
        }
        catch (Exception exception) {
            bufferedImage = null;
            LogWriter.writeLog("Couldn't convert Separation colorspace data: " + exception);
        }
        return bufferedImage;
    }

    private BufferedImage createImage(int n, int n2, byte[] byArray) {
        int n3;
        int n4 = byArray.length;
        float[] fArray = new float[256];
        for (n3 = 0; n3 < 255; ++n3) {
            fArray[n3] = -1.0f;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = byArray[n3] & 0xFF;
            if (fArray[n5] == -1.0f) {
                this.setColor((float)n5 / 255.0f);
                fArray[n5] = ((Color)((Object)this.getColor())).getRed();
            }
            byArray[n3] = (byte)fArray[n5];
        }
        int[] nArray = new int[]{0};
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 10);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n, n2, n, 1, nArray, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    public byte[] convertIndexToRGB(byte[] byArray) {
        byte[] byArray2 = new byte[768];
        try {
            int n = 0;
            String[] stringArray = new String[1];
            Color color = null;
            int n2 = byArray.length;
            float[] fArray = new float[this.componentCount];
            for (int i = 0; i < n2; i += this.componentCount) {
                if (this.componentCount == 1 && this.value == 10) {
                    stringArray = new String[1];
                    stringArray[1] = String.valueOf(byArray[i] & 0xFF);
                    this.setColor(stringArray, 1);
                    color = (Color)((Object)this.getColor());
                } else {
                    for (int j = 0; j < this.componentCount; ++j) {
                        fArray[this.componentCount - 1 - j] = (float)(byArray[i + j] & 0xFF) / 255.0f;
                    }
                    String[] stringArray2 = this.colorMapper.getOperand(fArray);
                    this.altCS.setColor(stringArray2, stringArray2.length);
                    color = (Color)((Object)this.altCS.getColor());
                }
                byArray2[n] = (byte)color.getBlue();
                byArray2[++n] = (byte)color.getGreen();
                byArray2[++n] = (byte)color.getRed();
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            LogWriter.writeLog("Exception  " + exception + " converting colorspace");
        }
        return byArray2;
    }

    public PdfPaint getColor() {
        return this.altCS.getColor();
    }

    public GenericColorSpace getAltColorSpace() {
        return this.altCS;
    }
}

