/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.jpaneldemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.exception.PdfException;

public class JPanelDemo
extends JFrame {
    private String viewerTitle = "Jpanel Demo";
    private PdfDecoder pdfDecoder;
    private String currentFile = null;
    private int currentPage = 1;
    private final JLabel pageCounter1 = new JLabel("Page ");
    private JTextField pageCounter2 = new JTextField(4);
    private JLabel pageCounter3 = new JLabel("of");

    public JPanelDemo(String string) {
        this.pdfDecoder = new PdfDecoder();
        this.currentFile = string;
        try {
            this.pdfDecoder.openPdfFile(this.currentFile);
            this.pdfDecoder.decodePage(this.currentPage);
            this.pdfDecoder.setPageParameters(1.0f, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initializeViewer();
        this.pageCounter2.setText(String.valueOf(this.currentPage));
        this.pageCounter3.setText("of " + this.pdfDecoder.getPageCount());
    }

    public JPanelDemo() {
        this.setTitle(this.viewerTitle);
        this.pdfDecoder = new PdfDecoder();
        this.initializeViewer();
    }

    private void selectFile() {
        JFileChooser jFileChooser = new JFileChooser(".");
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = -1;
        while (n == -1) {
            n = jFileChooser.showOpenDialog(this);
            if (n == -1) {
                System.err.println("JFileChooser error");
            }
            if (n != 0) continue;
            this.currentFile = jFileChooser.getSelectedFile().getAbsolutePath();
            this.currentPage = 1;
            try {
                this.pdfDecoder.closePdfFile();
                this.pdfDecoder.openPdfFile(this.currentFile);
                if (!this.checkEncryption()) {
                    n = 1;
                }
                this.pdfDecoder.decodePage(this.currentPage);
                this.pdfDecoder.setPageParameters(1.0f, 1);
                this.pdfDecoder.invalidate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pageCounter2.setText(String.valueOf(this.currentPage));
            this.pageCounter3.setText("of " + this.pdfDecoder.getPageCount());
            this.setTitle(this.viewerTitle + " - " + this.currentFile);
            this.repaint();
        }
    }

    private boolean checkEncryption() {
        if (this.pdfDecoder.isEncrypted()) {
            while (!this.pdfDecoder.isFileViewable()) {
                String string = JOptionPane.showInputDialog(this, (Object)"Please enter password");
                if (string == null) continue;
                try {
                    this.pdfDecoder.setEncryptionPassword(string);
                }
                catch (PdfException pdfException) {
                    pdfException.printStackTrace();
                }
            }
            return true;
        }
        return true;
    }

    private void initializeViewer() {
        this.setDefaultCloseOperation(3);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JButton jButton = this.initOpenBut();
        Component[] componentArray = this.initChangerPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(3, 0, 0));
        jPanel.add(jButton);
        for (int i = 0; i < componentArray.length; ++i) {
            jPanel.add(componentArray[i]);
        }
        container.add((Component)jPanel, "North");
        JScrollPane jScrollPane = this.initPDFDisplay();
        container.add((Component)jScrollPane, "Center");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension.width / 2, dimension.height / 2);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JButton initOpenBut() {
        JButton jButton = new JButton();
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/open.gif")));
        jButton.setText("Open");
        jButton.setToolTipText("Open a file");
        jButton.setBorderPainted(false);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelDemo.this.selectFile();
            }
        });
        return jButton;
    }

    private JScrollPane initPDFDisplay() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(this.pdfDecoder);
        return jScrollPane;
    }

    private Component[] initChangerPanel() {
        Component[] componentArray = new Component[11];
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        URL uRL = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/start.gif");
        jButton.setIcon(new ImageIcon(uRL));
        jButton.setToolTipText("Rewind to page 1");
        componentArray[0] = jButton;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage != 1) {
                    JPanelDemo.this.currentPage = 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("back to page 1");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton jButton2 = new JButton();
        jButton2.setBorderPainted(false);
        URL uRL2 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fback.gif");
        jButton2.setIcon(new ImageIcon(uRL2));
        jButton2.setToolTipText("Rewind 10 pages");
        componentArray[1] = jButton2;
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage > 10) {
                    JPanelDemo.this.currentPage -= 10;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("back 10 pages");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton jButton3 = new JButton();
        jButton3.setBorderPainted(false);
        URL uRL3 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/back.gif");
        jButton3.setIcon(new ImageIcon(uRL3));
        jButton3.setToolTipText("Rewind one page");
        componentArray[2] = jButton3;
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage > 1) {
                    JPanelDemo.this.currentPage -= 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("back 1 page");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        this.pageCounter2.setEditable(true);
        this.pageCounter2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JPanelDemo.this.pageCounter2.getText().trim();
                try {
                    int n = Integer.parseInt(string);
                    if (n > JPanelDemo.this.pdfDecoder.getPageCount() | n < 1) {
                        return;
                    }
                    JPanelDemo.this.currentPage = n;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("page number entered");
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, '>' + string + "< is Not a valid Value.\nPlease enter a number between 1 and " + JPanelDemo.this.pdfDecoder.getPageCount());
                }
            }
        });
        componentArray[3] = this.pageCounter1;
        componentArray[4] = new JPanel();
        componentArray[5] = this.pageCounter2;
        componentArray[6] = new JPanel();
        componentArray[7] = this.pageCounter3;
        JButton jButton4 = new JButton();
        jButton4.setBorderPainted(false);
        URL uRL4 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/forward.gif");
        jButton4.setIcon(new ImageIcon(uRL4));
        jButton4.setToolTipText("forward 1 page");
        componentArray[8] = jButton4;
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount()) {
                    JPanelDemo.this.currentPage += 1;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("forward 1 page");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton jButton5 = new JButton();
        jButton5.setBorderPainted(false);
        URL uRL5 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/fforward.gif");
        jButton5.setIcon(new ImageIcon(uRL5));
        jButton5.setToolTipText("Fast forward 10 pages");
        componentArray[9] = jButton5;
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount() - 9) {
                    JPanelDemo.this.currentPage += 10;
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("forward 10 pages");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        JButton jButton6 = new JButton();
        jButton6.setBorderPainted(false);
        URL uRL6 = this.getClass().getResource("/org/jpedal/examples/simpleviewer/res/end.gif");
        jButton6.setIcon(new ImageIcon(uRL6));
        jButton6.setToolTipText("Fast forward to last page");
        componentArray[10] = jButton6;
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JPanelDemo.this.currentFile != null && JPanelDemo.this.currentPage < JPanelDemo.this.pdfDecoder.getPageCount()) {
                    JPanelDemo.this.currentPage = JPanelDemo.this.pdfDecoder.getPageCount();
                    try {
                        JPanelDemo.this.pdfDecoder.decodePage(JPanelDemo.this.currentPage);
                        JPanelDemo.this.pdfDecoder.invalidate();
                        JPanelDemo.this.repaint();
                    }
                    catch (Exception exception) {
                        System.err.println("forward to last page");
                        exception.printStackTrace();
                    }
                    JPanelDemo.this.pageCounter2.setText(String.valueOf(JPanelDemo.this.currentPage));
                }
            }
        });
        return componentArray;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            JPanelDemo jPanelDemo = new JPanelDemo(stringArray[0]);
        } else {
            JPanelDemo jPanelDemo = new JPanelDemo();
        }
    }
}

