/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.function;

import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.function.Function;
import org.jpedal.io.PdfObjectReader;

class Exponential
extends Function {
    static final float[] C0_DEFAULT = new float[]{0.0f};
    static final float[] C1_DEFAULT = new float[]{1.0f};
    float[] C0;
    float[] C1;
    float[] domain;
    float[] range;
    float N;

    Exponential(Map map, float[] fArray, float[] fArray2, PdfObjectReader pdfObjectReader) {
        int n;
        StringTokenizer stringTokenizer;
        String string = (String)map.get("N");
        if (string != null) {
            this.N = Float.parseFloat(string);
        }
        if ((string = (String)map.get("C0")) != null) {
            string = pdfObjectReader.getValue(string);
            stringTokenizer = new StringTokenizer(string, "[] ");
            this.C0 = new float[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.C0[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            this.C0 = new float[1];
            this.C0[0] = 0.0f;
        }
        if ((string = (String)map.get("C1")) != null) {
            string = pdfObjectReader.getValue(string);
            stringTokenizer = new StringTokenizer(string, "[] ");
            this.C1 = new float[stringTokenizer.countTokens()];
            n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.C1[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
        } else {
            this.C1 = new float[1];
            this.C1[0] = 1.0f;
        }
        this.domain = fArray;
        this.range = fArray2;
    }

    public int getN() {
        return this.C0.length;
    }

    public final String[] compute(float[] fArray, float[] fArray2) {
        if (fArray2 == null) {
            fArray2 = this.domain;
        }
        int n = this.C0.length;
        float[] fArray3 = new float[n];
        String[] stringArray = new String[n];
        try {
            this.compute(fArray, fArray3, fArray2);
            for (int i = 0; i < n; ++i) {
                stringArray[i] = String.valueOf(fArray3[n - i - 1]);
            }
        }
        catch (Exception exception) {
            System.out.println("Exp error " + exception);
            exception.printStackTrace();
        }
        return stringArray;
    }

    public void compute(float[] fArray, float[] fArray2, float[] fArray3) {
        this.clip(fArray, fArray3);
        float f = fArray[0];
        int n = this.getN();
        if (this.N == 1.0f) {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = this.C0[i] + f * (this.C1[i] - this.C0[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = this.C0[i] + (float)Math.pow(f, this.N) * (this.C1[i] - this.C0[i]);
            }
        }
        if (this.range != null) {
            this.clip(fArray2, this.range);
        }
    }
}

